/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.dicom;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dcm4che3.data.UID;

public class UIDConfiguration {
    private static final ALogger log = ALogger.getLogger(UIDConfiguration.class);
    private static final UIDConfiguration instance = new UIDConfiguration();
    private static final String ROOT = "com.agfa.pacs.data.base";
    private static final String UIDS = "uids";
    private static final String SOPCLASSES = "sopclasses";
    private static final String UID = "uid";
    private static final String TYPES = "types";
    private static final String METHOD = "method";
    private static final String TRANSFERSYNTAXES = "transfersyntaxes";
    private IConfigurationProvider config = ConfigurationProviderFactory.getConfig();
    private IConfigurationProvider provider = this.config.getNode("com.agfa.pacs.data.base");
    private Map<String, Set<UIDType>> uidMap;
    private Map<UIDType, List<String>> uidTypeMap;
    private Map<String, UIDType> baseTypeMap;
    private Map<String, Set<UIDType>> tsUIDMap;
    private Map<UIDType, Set<String>> tsUIDTypeMap;
    private Map<String, String> compressionMethods;
    private Set<String> lossyTSUIDs;

    public static UIDConfiguration getInstance() {
        return instance;
    }

    private UIDConfiguration() {
        this.initTSUIDMaps();
        this.initUIDMaps();
    }

    public Set<UIDType> getSOPClassUIDTypes(String string) {
        return this.uidMap.get(string);
    }

    public boolean isType(String string, UIDType uIDType) {
        Set<UIDType> set = this.uidMap.get(string);
        if (set == null) {
            return false;
        }
        return set.contains(uIDType);
    }

    private UIDType getBaseType(Collection<UIDType> collection) {
        if (collection == null || collection.isEmpty()) {
            return UIDType.Composite;
        }
        for (UIDType uIDType : collection) {
            if (!uIDType.isBaseType()) continue;
            return uIDType;
        }
        return null;
    }

    public UIDType getBaseType(String string) {
        return this.baseTypeMap.get(string);
    }

    public List<String> getSOPClassUIDs() {
        return new ArrayList<String>(this.uidMap.keySet());
    }

    public List<String> getSOPClassUIDs(UIDType uIDType) {
        return this.uidTypeMap.get(uIDType);
    }

    public Set<UIDType> getTransferSyntaxUIDTypes(String string) {
        return this.tsUIDMap.get(string);
    }

    public boolean isTransferSyntaxType(String string, UIDType uIDType) {
        Set<UIDType> set = this.getTransferSyntaxUIDTypes(string);
        if (set == null) {
            return false;
        }
        return set.contains(uIDType);
    }

    public List<String> getTransferSyntaxUIDs() {
        return new ArrayList<String>(this.tsUIDMap.keySet());
    }

    public Set<String> getTransferSyntaxUIDs(UIDType uIDType) {
        return this.tsUIDTypeMap.get(uIDType);
    }

    public Set<String> getDefaultTransferSyntaxUIDs() {
        return this.getTransferSyntaxUIDs(UIDType.Default);
    }

    public Set<String> getImageTransferSyntaxUIDs() {
        return this.getTransferSyntaxUIDs(UIDType.Image);
    }

    public Set<String> getLossyTransferSyntaxUIDs() {
        return this.lossyTSUIDs;
    }

    public Set<String> getVideoTransferSyntaxUIDs() {
        return this.getTransferSyntaxUIDs(UIDType.Video);
    }

    public String getCompressionMethod(String string) {
        return this.compressionMethods.get(string);
    }

    private synchronized void initUIDMaps() {
        this.uidMap = new HashMap<String, Set<UIDType>>(256);
        this.uidTypeMap = new HashMap<UIDType, List<String>>(256);
        this.baseTypeMap = new HashMap<String, UIDType>(256);
        this.initUIDMap();
    }

    private void initUIDMap() {
        String string = SOPCLASSES;
        IConfigurationProvider iConfigurationProvider = this.provider.getNode(UIDS);
        IConfigurationList iConfigurationList = iConfigurationProvider.getList(string);
        log.debug("----- UIDMap (SOP Class UIDs) ----- (begin)");
        for (IConfigurationProvider iConfigurationProvider2 : iConfigurationList) {
            String string2 = iConfigurationProvider2.getString(UID);
            String string3 = null;
            if (iConfigurationProvider2.exists(TYPES)) {
                string3 = iConfigurationProvider2.getString(TYPES);
            }
            Set<UIDType> set = this.toSet(string3);
            this.uidMap.put(string2, set);
            this.baseTypeMap.put(string2, this.getBaseType(set));
            for (UIDType uIDType : set) {
                if (!this.uidTypeMap.containsKey(uIDType)) {
                    this.uidTypeMap.put(uIDType, new ArrayList());
                }
                this.uidTypeMap.get(uIDType).add(string2);
            }
            if (!log.isDebugEnabled()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append(" | ");
            stringBuilder.append(org.dcm4che3.data.UID.nameOf((String)string2));
            stringBuilder.append(" | ");
            for (UIDType uIDType : set) {
                stringBuilder.append(uIDType.dicom());
                stringBuilder.append(" ");
            }
            log.debug(stringBuilder.toString());
        }
        log.debug("----- UIDMap (SOP Class UIDs)  ----- (end)");
    }

    private synchronized void initTSUIDMaps() {
        this.tsUIDMap = new HashMap<String, Set<UIDType>>(16);
        this.tsUIDTypeMap = new HashMap<UIDType, Set<String>>(16);
        this.compressionMethods = new HashMap<String, String>(16);
        this.initTSUIDMap();
    }

    private void initTSUIDMap() {
        String string = TRANSFERSYNTAXES;
        IConfigurationProvider iConfigurationProvider = this.provider.getNode(UIDS);
        IConfigurationList iConfigurationList = iConfigurationProvider.getList(string);
        log.debug("----- UIDMap (Transfer Syntax UIDs) ----- (begin)");
        for (IConfigurationProvider iConfigurationProvider2 : iConfigurationList) {
            String string2 = iConfigurationProvider2.getString(UID);
            String string3 = null;
            if (iConfigurationProvider2.exists(TYPES)) {
                string3 = iConfigurationProvider2.getString(TYPES);
            }
            Set<UIDType> set = this.toSet(string3);
            this.tsUIDMap.put(string2, set);
            for (UIDType uIDType : set) {
                if (!this.tsUIDTypeMap.containsKey(uIDType)) {
                    this.tsUIDTypeMap.put(uIDType, new LinkedHashSet());
                }
                this.tsUIDTypeMap.get(uIDType).add(string2);
            }
            if (iConfigurationProvider2.exists(METHOD)) {
                this.compressionMethods.put(string2, iConfigurationProvider2.getString(METHOD));
            }
            if (!log.isDebugEnabled()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append(" | ");
            stringBuilder.append(org.dcm4che3.data.UID.nameOf((String)string2));
            stringBuilder.append(" | ");
            if (this.compressionMethods.containsKey(string2)) {
                stringBuilder.append(this.compressionMethods.get(string2));
                stringBuilder.append(" | ");
            }
            for (UIDType uIDType : set) {
                stringBuilder.append(uIDType.dicom());
                stringBuilder.append(" ");
            }
            log.debug(stringBuilder.toString());
        }
        log.debug("----- UIDMap (Transfer Syntax UIDs)  ----- (end)");
        this.lossyTSUIDs = new HashSet<String>(this.getTransferSyntaxUIDs(UIDType.Lossy));
    }

    private Set<UIDType> toSet(String string) {
        EnumSet<UIDType> enumSet = EnumSet.noneOf(UIDType.class);
        if (string != null) {
            String[] stringArray;
            String[] stringArray2 = stringArray = string.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                UIDType uIDType = UIDType.get(string2);
                if (uIDType != null) {
                    enumSet.add(uIDType);
                }
                ++n2;
            }
        }
        return enumSet;
    }
}

