/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.dicom;

import com.agfa.pacs.data.shared.NodeProperty;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.tools.CompareUtils;

public class SimpleDicomNode
implements IDicomNode {
    protected String host;
    private int port;
    private String callingAET;
    private String calledAET;
    protected String description;
    private boolean isSecure;
    private boolean closeImmediately;

    public SimpleDicomNode(IDicomNode iDicomNode) {
        this(iDicomNode.getHost(), iDicomNode.getPort(), iDicomNode.getCalledAET(), iDicomNode.getCallingAET(), iDicomNode.isEnabled(NodeProperty.Secure), !iDicomNode.isEnabled(NodeProperty.KeepAlive));
    }

    public SimpleDicomNode(String string, int n, String string2, String string3) {
        this(string, n, string2, string3, false, true);
    }

    public SimpleDicomNode(String string, int n, String string2, String string3, boolean bl, boolean bl2) {
        this.host = string;
        this.port = n;
        this.callingAET = string3;
        this.calledAET = string2;
        this.isSecure = bl;
        this.closeImmediately = bl2;
    }

    public SimpleDicomNode(String string, int n, String string2, String string3, boolean bl, String string4) {
        this(string, n, string2, string3, false, bl, string4);
    }

    public SimpleDicomNode(String string, int n, String string2, String string3, boolean bl, boolean bl2, String string4) {
        this(string, n, string2, string3, bl, bl2);
        this.description = string4;
    }

    @Override
    public String getCalledAET() {
        return this.calledAET;
    }

    @Override
    public String getCallingAET() {
        return this.callingAET;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getDescription();
    }

    public void setCalledAET(String string) {
        this.calledAET = string;
    }

    public void setCallingAET(String string) {
        this.callingAET = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof IDicomNode)) {
            return false;
        }
        IDicomNode iDicomNode = (IDicomNode)object;
        if (!CompareUtils.equals((Object)iDicomNode.getHost(), (Object)this.getHost())) {
            return false;
        }
        if (iDicomNode.getPort() != this.getPort()) {
            return false;
        }
        return CompareUtils.equals((Object)iDicomNode.getCalledAET(), (Object)this.getCalledAET());
    }

    public int hashCode() {
        return this.host.hashCode() ^ this.port ^ this.calledAET.hashCode();
    }

    @Override
    public boolean isEnabled(NodeProperty nodeProperty) {
        if (nodeProperty == NodeProperty.Secure) {
            return this.isSecure;
        }
        if (nodeProperty == NodeProperty.KeepAlive) {
            return !this.closeImmediately;
        }
        return false;
    }
}

