/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.data;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.WaitDicomDataListenerAdapter;
import com.agfa.pacs.data.shared.dicom.UIDConfiguration;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.data.shared.pixel.PixelDataReader;
import java.io.ByteArrayOutputStream;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.VR;

public class DatasetDicomDataWriter
extends WaitDicomDataListenerAdapter {
    private boolean pixelsStarted = false;
    private boolean encapsulated;
    private ByteArrayOutputStream pixelDataStream;
    private Attributes dataset;

    @Override
    public void dicomDataAvailable(String string, Attributes attributes, boolean bl) {
        this.dataset = attributes;
        this.pixelDataStream = new ByteArrayOutputStream();
        attributes.remove(2145386512);
        if (UIDConfiguration.getInstance().getDefaultTransferSyntaxUIDs().contains(attributes.getString(131088, null))) {
            this.encapsulated = false;
        }
    }

    @Override
    public void dicomDataError(String string, String string2, Throwable throwable) {
    }

    @Override
    public void pixelDataAvailable(String string, IPixelDataInfo iPixelDataInfo, int n) {
        PixelDataReader pixelDataReader = new PixelDataReader(iPixelDataInfo);
        try {
            Object object;
            ByteArrayContainer byteArrayContainer = (ByteArrayContainer)pixelDataReader.getData();
            if (!this.pixelsStarted) {
                if (this.encapsulated) {
                    object = this.dataset.newFragments(2145386512, null, 1);
                    object.add((Object)new byte[0]);
                }
                this.pixelsStarted = true;
            }
            if (this.encapsulated) {
                object = new byte[byteArrayContainer.getDataLength()];
                System.arraycopy(byteArrayContainer.getData(), byteArrayContainer.getOffset(), object, 0, byteArrayContainer.getDataLength());
                ((Fragments)this.dataset.getValue(2145386512)).add(object);
            } else {
                this.pixelDataStream.write(byteArrayContainer.getData(), byteArrayContainer.getOffset(), byteArrayContainer.getDataLength());
            }
        }
        finally {
            pixelDataReader.releaseData();
        }
    }

    @Override
    public void dicomDataFinished(String string, IDicomDataListener.Status status, Attributes attributes) {
        if (this.pixelsStarted && !this.encapsulated) {
            this.dataset.setBytes(2145386512, VR.OW, this.pixelDataStream.toByteArray());
        }
        super.dicomDataFinished(string, status, attributes);
    }

    public Attributes getDataset() {
        return this.dataset;
    }
}

