/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.data;

import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.pixel.EncodedPixelDataInfo;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Fragments;

public class DatasetDicomDataReader
implements Runnable {
    private final Attributes dataset;
    private int[] offsetTable;
    private String instanceUID;
    private int currentOffset;
    private ByteArrayOutputStream dataCollector;
    private int frame;
    private final IDicomDataListener listener;

    public DatasetDicomDataReader(Attributes attributes, IDicomDataListener iDicomDataListener) {
        this.dataset = attributes;
        this.frame = 0;
        this.currentOffset = 0;
        this.dataCollector = null;
        this.frame = 0;
        this.listener = iDicomDataListener;
    }

    @Override
    public void run() {
        try {
            boolean bl = this.dataset.contains(2145386512);
            this.instanceUID = this.dataset.getString(524312, null);
            this.listener.dicomDataAvailable(this.instanceUID, this.dataset, bl);
            if (bl) {
                Object object = this.dataset.getValue(2145386512);
                if (object instanceof Fragments) {
                    Fragments fragments = (Fragments)object;
                    if (fragments.get(0) instanceof byte[]) {
                        this.readOffsetTable((byte[])fragments.get(0), fragments.bigEndian());
                    }
                    int n = 1;
                    while (n < fragments.size()) {
                        this.readPixelData((byte[])fragments.get(n));
                        ++n;
                    }
                    if (this.dataCollector != null) {
                        this.listener.pixelDataAvailable(this.instanceUID, new EncodedPixelDataInfo(this.dataCollector.toByteArray(), this.dataset), this.frame);
                        ++this.frame;
                    }
                    this.dataCollector = null;
                } else {
                    byte[] byArray = this.dataset.getBytes(2145386512);
                    int n = this.dataset.getInt(2621457, 0);
                    int n2 = this.dataset.getInt(2621456, 0);
                    int n3 = this.dataset.getInt(2621696, 0);
                    int n4 = this.dataset.getInt(0x280002, 0);
                    int n5 = this.dataset.getInt(0x280008, 1);
                    int n6 = n * n2 * (n3 / 8) * n4;
                    int n7 = 0;
                    byte[] byArray2 = new byte[n6];
                    int n8 = 0;
                    while (n8 < n5) {
                        System.arraycopy(byArray, n7, byArray2, 0, n6);
                        this.readPixelData(byArray2);
                        n7 += n6;
                        ++n8;
                    }
                }
            }
            this.listener.dicomDataFinished(this.instanceUID, IDicomDataListener.Status.Success, null);
        }
        catch (Exception exception) {
            this.listener.dicomDataError(this.instanceUID, "Dataset problem", exception);
            this.listener.dicomDataFinished(this.instanceUID, IDicomDataListener.Status.Failed, null);
        }
    }

    private void readOffsetTable(byte[] byArray, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (!bl) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        int n = byteBuffer.limit() / 4;
        this.offsetTable = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.offsetTable[n2] = byteBuffer.getInt(n2 * 4);
            ++n2;
        }
        this.dataCollector = new ByteArrayOutputStream();
    }

    private void readPixelData(byte[] byArray) throws Exception {
        if (this.offsetTable != null) {
            if (this.frame + 1 < this.offsetTable.length && this.currentOffset == this.offsetTable[this.frame + 1]) {
                if (this.dataCollector != null) {
                    this.listener.pixelDataAvailable(this.instanceUID, new EncodedPixelDataInfo(this.dataCollector.toByteArray(), this.dataset), this.frame);
                    ++this.frame;
                }
                this.dataCollector = new ByteArrayOutputStream();
            }
            this.dataCollector.write(byArray);
            this.currentOffset += byArray.length + 8;
        } else {
            this.listener.pixelDataAvailable(this.instanceUID, new EncodedPixelDataInfo(byArray, this.dataset), this.frame);
            ++this.frame;
        }
    }
}

