/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.data;

import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.WaitDicomDataListenerAdapter;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.data.shared.util.Waitable;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractWaitDicom
implements Waitable {
    protected static final ALogger LOGGER = ALogger.getLogger(WaitDicomDataListenerAdapter.class);
    protected final List<Waitable> waitables = new ArrayList<Waitable>();

    public synchronized IDicomDataListener addListener(IDicomDataListener iDicomDataListener) {
        AbstractDicomWaiter abstractDicomWaiter = this.createWaitable(iDicomDataListener);
        this.waitables.add(abstractDicomWaiter);
        return abstractDicomWaiter;
    }

    protected abstract AbstractDicomWaiter createWaitable(IDicomDataListener var1);

    @Override
    public synchronized void waitUntilFinished() {
        for (Waitable waitable : this.waitables) {
            waitable.waitUntilFinished();
        }
    }

    @Override
    public synchronized void waitUntilFinished(int n) {
        for (Waitable waitable : this.waitables) {
            waitable.waitUntilFinished(n);
        }
    }

    protected static abstract class AbstractDicomWaiter
    implements IDicomDataListener,
    Waitable {
        protected boolean finished;
        protected final IDicomDataListener listener;

        public AbstractDicomWaiter(IDicomDataListener iDicomDataListener) {
            this.listener = iDicomDataListener;
            this.finished = false;
        }

        @Override
        public synchronized void dicomDataError(String string, String string2, Throwable throwable) {
            this.listener.dicomDataError(string, string2, throwable);
            this.finished = true;
            this.notifyAll();
        }

        @Override
        public void pixelDataAvailable(String string, IPixelDataInfo iPixelDataInfo, int n) {
            this.listener.pixelDataAvailable(string, iPixelDataInfo, n);
        }

        @Override
        public synchronized void waitUntilFinished() {
            if (this.finished) {
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn("Waiting for DICOM data interrupted.", (Throwable)interruptedException);
            }
        }

        @Override
        public synchronized void waitUntilFinished(int n) {
            if (this.finished) {
                return;
            }
            try {
                this.wait(n);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn("Waiting for DICOM data interrupted.", (Throwable)interruptedException);
            }
        }
    }
}

