/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared;

public class BitReader {
    private byte[] data;
    private int buf;
    private int bits;
    private int pos;

    public BitReader(byte[] byArray) {
        this(byArray, 0);
    }

    public BitReader(byte[] byArray, int n) {
        this.data = byArray;
        if (n > 0) {
            this.pos = n >> 3;
            int n2 = n & 7;
            int n3 = 0;
            while (n3 < n2) {
                this.getBit();
                ++n3;
            }
        }
    }

    public final int getBit() {
        if (this.bits == 0) {
            this.buf = this.data[this.pos++];
            this.bits = 8;
        }
        int n = this.buf & 1;
        this.buf >>= 1;
        --this.bits;
        return n;
    }

    public final byte[] getBits(int n) {
        byte by;
        int n2 = n + 7 >> 3;
        byte[] byArray = new byte[n2];
        int n3 = (1 << this.bits) - 1;
        int n4 = 8 - this.bits;
        int n5 = 0;
        while (n > 8) {
            by = this.data[this.pos++];
            byArray[n5] = (byte)(this.buf & n3 | by << this.bits);
            this.buf = by >> n4;
            ++n5;
            n -= 8;
        }
        if (n > 0) {
            if (n <= this.bits) {
                byArray[n5] = (byte)this.buf;
                this.buf >>= n;
                this.bits -= n;
            } else {
                by = this.data[this.pos++];
                byArray[n5] = (byte)((this.buf & n3 | by << this.bits) & (1 << n) - 1);
                this.buf = by >> n - this.bits;
                this.bits += 8 - n;
            }
        }
        return byArray;
    }
}

