/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import org.apache.log4j.spi.LoggingEvent;

public class CyclicBuffer {
    LoggingEvent[] ea;
    int first;
    int last;
    int numElems;
    int maxSize;

    public CyclicBuffer(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("The maxSize argument (" + n + ") is not a positive integer.");
        }
        this.maxSize = n;
        this.ea = new LoggingEvent[n];
        this.first = 0;
        this.last = 0;
        this.numElems = 0;
    }

    public void add(LoggingEvent loggingEvent) {
        this.ea[this.last] = loggingEvent;
        if (++this.last == this.maxSize) {
            this.last = 0;
        }
        if (this.numElems < this.maxSize) {
            ++this.numElems;
        } else if (++this.first == this.maxSize) {
            this.first = 0;
        }
    }

    public LoggingEvent get(int n) {
        if (n < 0 || n >= this.numElems) {
            return null;
        }
        return this.ea[(this.first + n) % this.maxSize];
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public LoggingEvent get() {
        LoggingEvent loggingEvent = null;
        if (this.numElems > 0) {
            --this.numElems;
            loggingEvent = this.ea[this.first];
            this.ea[this.first] = null;
            if (++this.first == this.maxSize) {
                this.first = 0;
            }
        }
        return loggingEvent;
    }

    public int length() {
        return this.numElems;
    }

    public void resize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative array size [" + n + "] not allowed.");
        }
        if (n == this.numElems) {
            return;
        }
        LoggingEvent[] loggingEventArray = new LoggingEvent[n];
        int n2 = n < this.numElems ? n : this.numElems;
        for (int i = 0; i < n2; ++i) {
            loggingEventArray[i] = this.ea[this.first];
            this.ea[this.first] = null;
            if (++this.first != this.numElems) continue;
            this.first = 0;
        }
        this.ea = loggingEventArray;
        this.first = 0;
        this.numElems = n2;
        this.maxSize = n;
        this.last = n2 == n ? 0 : n2;
    }
}

