/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.osgi.logging;

import java.io.PrintStream;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class SystemOutRedirector
extends PrintStream {
    private static final boolean USE_STACKTRACE_ON_SYSOUT = true;
    private Logger delegate;
    private Priority priority;
    private StringBuffer buffer = new StringBuffer();

    public SystemOutRedirector(String string, Priority priority) {
        super(System.out);
        this.delegate = Logger.getLogger(string);
        this.priority = priority;
    }

    @Override
    public void flush() {
        this.flushBuffer();
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public void print(boolean bl) {
        this.appendToBuffer(Boolean.toString(bl));
    }

    @Override
    public void print(char c) {
        this.appendToBuffer(c);
    }

    @Override
    public void print(char[] cArray) {
        this.appendToBuffer(cArray);
    }

    @Override
    public void print(double d) {
        this.appendToBuffer(Double.toString(d));
    }

    @Override
    public void print(float f) {
        this.appendToBuffer(Float.toString(f));
    }

    @Override
    public void print(int n) {
        this.write(n);
    }

    @Override
    public void print(long l) {
        this.appendToBuffer(Long.toString(l));
    }

    @Override
    public void print(Object object) {
        this.appendToBuffer("" + object);
    }

    @Override
    public void print(String string) {
        this.appendToBuffer(string);
    }

    @Override
    public void println() {
        this.flushBuffer();
    }

    @Override
    public void println(boolean bl) {
        this.printLoggerLine(Boolean.toString(bl));
    }

    @Override
    public void println(char c) {
        this.printLoggerLine(new String(Character.toChars(c)));
    }

    @Override
    public void println(char[] cArray) {
        this.printLoggerLine(new String(cArray));
    }

    @Override
    public void println(double d) {
        this.printLoggerLine(Double.toString(d));
    }

    @Override
    public void println(float f) {
        this.printLoggerLine(Float.toString(f));
    }

    @Override
    public void println(int n) {
        this.printLoggerLine(Integer.toString(n));
    }

    @Override
    public void println(long l) {
        this.printLoggerLine(Long.toString(l));
    }

    @Override
    public void println(Object object) {
        this.printLoggerLine("" + object);
    }

    @Override
    public void println(String string) {
        String string2 = "";
        string2 = string2 + string;
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray != null) {
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                if (stackTraceElementArray[i].getFileName() == null || stackTraceElementArray[i].getFileName().equalsIgnoreCase("SystemOutRedirector.java") || stackTraceElementArray[i].getFileName().equalsIgnoreCase("Thread.java")) continue;
                string2 = string2 + " (" + stackTraceElementArray[i].getFileName() + ":" + stackTraceElementArray[i].getLineNumber() + ")";
                break;
            }
        }
        this.printLoggerLine(string2);
        string2 = null;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.appendToBuffer(new String(byArray, n, n2));
    }

    @Override
    public void write(int n) {
        this.appendToBuffer(Character.toChars(n));
    }

    private synchronized void printLoggerLine(String string) {
        if (this.buffer.length() > 0) {
            this.appendToBuffer(string);
            this.flushBuffer();
        } else {
            this.delegate.log(this.priority, string);
        }
    }

    private synchronized void appendToBuffer(char c) {
        if (c == '\r' || c == '\n') {
            this.flushBuffer();
        } else {
            this.buffer.append(c);
        }
    }

    private void appendToBuffer(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.appendToBuffer(string.charAt(i));
        }
    }

    private void appendToBuffer(char[] cArray) {
        for (char c : cArray) {
            this.appendToBuffer(c);
        }
    }

    private void flushBuffer() {
        if (this.buffer.length() > 0) {
            String string = this.buffer.toString();
            this.buffer.setLength(0);
            this.printLoggerLine(string);
        }
    }
}

