/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.tracker;

import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.util.tracker.AbstractTracked;
import org.osgi.util.tracker.BundleTrackerCustomizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleTracker<T>
implements BundleTrackerCustomizer<T> {
    static final boolean DEBUG = false;
    protected final BundleContext context;
    final BundleTrackerCustomizer<T> customizer;
    private volatile Tracked tracked;
    final int mask;

    private Tracked tracked() {
        return this.tracked;
    }

    public BundleTracker(BundleContext bundleContext, int n, BundleTrackerCustomizer<T> bundleTrackerCustomizer) {
        this.context = bundleContext;
        this.mask = n;
        this.customizer = bundleTrackerCustomizer == null ? this : bundleTrackerCustomizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Tracked tracked;
        BundleTracker bundleTracker = this;
        synchronized (bundleTracker) {
            if (this.tracked != null) {
                return;
            }
            Tracked tracked2 = tracked = new Tracked();
            synchronized (tracked2) {
                this.context.addBundleListener(tracked);
                Bundle[] bundleArray = this.context.getBundles();
                if (bundleArray != null) {
                    int n = bundleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int n3 = bundleArray[n2].getState();
                        if ((n3 & this.mask) == 0) {
                            bundleArray[n2] = null;
                        }
                        ++n2;
                    }
                    tracked.setInitial(bundleArray);
                }
            }
            this.tracked = tracked;
        }
        tracked.trackInitial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Bundle[] bundleArray;
        Tracked tracked;
        BundleTracker bundleTracker = this;
        synchronized (bundleTracker) {
            tracked = this.tracked;
            if (tracked == null) {
                return;
            }
            tracked.close();
            bundleArray = this.getBundles();
            this.tracked = null;
            try {
                this.context.removeBundleListener(tracked);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        if (bundleArray != null) {
            int n = 0;
            while (n < bundleArray.length) {
                tracked.untrack(bundleArray[n], null);
                ++n;
            }
        }
    }

    @Override
    public T addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        Bundle bundle2 = bundle;
        return (T)bundle2;
    }

    @Override
    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, T t) {
    }

    @Override
    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, T t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getBundles() {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int n;
            block5: {
                n = tracked.size();
                if (n != 0) break block5;
                return null;
            }
            return tracked.copyKeys(new Bundle[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getObject(Bundle bundle) {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.getCustomizedObject(bundle);
        }
    }

    public void remove(Bundle bundle) {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return;
        }
        tracked.untrack(bundle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return 0;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackingCount() {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return -1;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.getTrackingCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Bundle, T> getTracked() {
        HashMap hashMap = new HashMap();
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return hashMap;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.copyEntries(hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return true;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.isEmpty();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Tracked
    extends AbstractTracked<Bundle, T, BundleEvent>
    implements SynchronousBundleListener {
        Tracked() {
        }

        @Override
        public void bundleChanged(BundleEvent bundleEvent) {
            if (this.closed) {
                return;
            }
            Bundle bundle = bundleEvent.getBundle();
            int n = bundle.getState();
            if ((n & BundleTracker.this.mask) != 0) {
                this.track(bundle, bundleEvent);
            } else {
                this.untrack(bundle, bundleEvent);
            }
        }

        @Override
        T customizerAdding(Bundle bundle, BundleEvent bundleEvent) {
            return BundleTracker.this.customizer.addingBundle(bundle, bundleEvent);
        }

        @Override
        void customizerModified(Bundle bundle, BundleEvent bundleEvent, T t) {
            BundleTracker.this.customizer.modifiedBundle(bundle, bundleEvent, t);
        }

        @Override
        void customizerRemoved(Bundle bundle, BundleEvent bundleEvent, T t) {
            BundleTracker.this.customizer.removedBundle(bundle, bundleEvent, t);
        }
    }
}

