/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;
    private static final String SEPARATOR = ".";
    private transient String versionString;
    public static final Version emptyVersion = new Version(0, 0, 0);

    public Version(int n, int n2, int n3) {
        this(n, n2, n3, null);
    }

    public Version(int n, int n2, int n3, String string) {
        if (string == null) {
            string = "";
        }
        this.major = n;
        this.minor = n2;
        this.micro = n3;
        this.qualifier = string;
        this.versionString = null;
        this.validate();
    }

    public Version(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = "";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR, true);
            n = Integer.parseInt(stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    n3 = Integer.parseInt(stringTokenizer.nextToken());
                    if (stringTokenizer.hasMoreTokens()) {
                        stringTokenizer.nextToken();
                        string2 = stringTokenizer.nextToken("");
                        if (stringTokenizer.hasMoreTokens()) {
                            throw new IllegalArgumentException(new StringBuffer("invalid format: ").append(string).toString());
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(new StringBuffer("invalid format: ").append(string).toString());
            illegalArgumentException.initCause(noSuchElementException);
            throw illegalArgumentException;
        }
        this.major = n;
        this.minor = n2;
        this.micro = n3;
        this.qualifier = string2;
        this.versionString = null;
        this.validate();
    }

    private void validate() {
        if (this.major < 0) {
            throw new IllegalArgumentException("negative major");
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException("negative minor");
        }
        if (this.micro < 0) {
            throw new IllegalArgumentException("negative micro");
        }
        char[] cArray = this.qualifier.toCharArray();
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            char c = cArray[n];
            if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '_' || c == '-')) {
                throw new IllegalArgumentException(new StringBuffer("invalid qualifier: ").append(this.qualifier).toString());
            }
            ++n;
        }
    }

    public static Version parseVersion(String string) {
        if (string == null) {
            return emptyVersion;
        }
        if ((string = string.trim()).length() == 0) {
            return emptyVersion;
        }
        return new Version(string);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String toString() {
        if (this.versionString != null) {
            return this.versionString;
        }
        int n = this.qualifier.length();
        StringBuffer stringBuffer = new StringBuffer(20 + n);
        stringBuffer.append(this.major);
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.minor);
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(this.micro);
        if (n > 0) {
            stringBuffer.append(SEPARATOR);
            stringBuffer.append(this.qualifier);
        }
        this.versionString = stringBuffer.toString();
        return this.versionString;
    }

    public int hashCode() {
        return (this.major << 24) + (this.minor << 16) + (this.micro << 8) + this.qualifier.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version version = (Version)object;
        return this.major == version.major && this.minor == version.minor && this.micro == version.micro && this.qualifier.equals(version.qualifier);
    }

    @Override
    public int compareTo(Version version) {
        if (version == this) {
            return 0;
        }
        int n = this.major - version.major;
        if (n != 0) {
            return n;
        }
        n = this.minor - version.minor;
        if (n != 0) {
            return n;
        }
        n = this.micro - version.micro;
        if (n != 0) {
            return n;
        }
        return this.qualifier.compareTo(version.qualifier);
    }
}

