/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.Filter;
import org.osgi.framework.ServicePermission;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServicePermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = 662615640374640621L;
    private transient Map<String, ServicePermission> permissions = new HashMap<String, ServicePermission>();
    private boolean all_allowed = false;
    private Map<String, ServicePermission> filterPermissions;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Hashtable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[0] = new ObjectStreamField("permissions", clazz);
        objectStreamFieldArray[1] = new ObjectStreamField("all_allowed", Boolean.TYPE);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.util.HashMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        objectStreamFieldArray[2] = new ObjectStreamField("filterPermissions", clazz2);
        serialPersistentFields = objectStreamFieldArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            throw new IllegalArgumentException(new StringBuffer("invalid permission: ").append(permission).toString());
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        ServicePermission servicePermission = (ServicePermission)permission;
        if (servicePermission.service != null) {
            throw new IllegalArgumentException(new StringBuffer("cannot add to collection: ").append(servicePermission).toString());
        }
        String string = servicePermission.getName();
        Filter filter = servicePermission.filter;
        ServicePermissionCollection servicePermissionCollection = this;
        synchronized (servicePermissionCollection) {
            ServicePermission servicePermission2;
            Map<String, ServicePermission> map;
            if (filter != null) {
                map = this.filterPermissions;
                if (map == null) {
                    this.filterPermissions = map = new HashMap<String, ServicePermission>();
                }
            } else {
                map = this.permissions;
            }
            if ((servicePermission2 = map.get(string)) != null) {
                int n = servicePermission2.action_mask;
                int n2 = servicePermission.action_mask;
                if (n != n2) {
                    map.put(string, new ServicePermission(string, n | n2));
                }
            } else {
                map.put(string, servicePermission);
            }
            if (!this.all_allowed && string.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean implies(Permission permission) {
        Collection<ServicePermission> collection;
        if (!(permission instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)permission;
        if (servicePermission.filter != null) {
            return false;
        }
        int n = 0;
        ServicePermissionCollection servicePermissionCollection = this;
        synchronized (servicePermissionCollection) {
            Map<String, ServicePermission> map;
            Object object;
            int n2 = servicePermission.action_mask;
            if (this.all_allowed && (object = this.permissions.get("*")) != null && ((n |= object.action_mask) & n2) == n2) {
                return true;
            }
            object = servicePermission.objectClass;
            if (object == null) {
                if (((n |= this.effective(servicePermission.getName(), n2, n)) & n2) == n2) {
                    return true;
                }
            } else {
                int n3 = 0;
                int n4 = ((String[])object).length;
                while (n3 < n4) {
                    if ((this.effective(object[n3], n2, n) & n2) == n2) {
                        return true;
                    }
                    ++n3;
                }
            }
            if ((map = this.filterPermissions) == null) {
                return false;
            }
            collection = map.values();
        }
        for (ServicePermission servicePermission2 : collection) {
            if (!servicePermission2.implies0(servicePermission, n)) continue;
            return true;
        }
        return false;
    }

    private int effective(String string, int n, int n2) {
        int n3;
        Map<String, ServicePermission> map = this.permissions;
        ServicePermission servicePermission = map.get(string);
        if (servicePermission != null && ((n2 |= servicePermission.action_mask) & n) == n) {
            return n2;
        }
        int n4 = string.length() - 1;
        while ((n3 = string.lastIndexOf(".", n4)) != -1) {
            servicePermission = map.get(string = new StringBuffer(String.valueOf(string.substring(0, n3 + 1))).append("*").toString());
            if (servicePermission != null && ((n2 |= servicePermission.action_mask) & n) == n) {
                return n2;
            }
            n4 = n3 - 1;
        }
        return n2;
    }

    @Override
    public synchronized Enumeration<Permission> elements() {
        ArrayList<ServicePermission> arrayList = new ArrayList<ServicePermission>(this.permissions.values());
        Map<String, ServicePermission> map = this.filterPermissions;
        if (map != null) {
            arrayList.addAll(map.values());
        }
        return Collections.enumeration(arrayList);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable<String, ServicePermission> hashtable = new Hashtable<String, ServicePermission>(this.permissions);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("permissions", hashtable);
        putField.put("all_allowed", this.all_allowed);
        putField.put("filterPermissions", this.filterPermissions);
        objectOutputStream.writeFields();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        HashMap hashMap;
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Hashtable hashtable = (Hashtable)getField.get("permissions", null);
        this.permissions = new HashMap<String, ServicePermission>(hashtable);
        this.all_allowed = getField.get("all_allowed", false);
        this.filterPermissions = hashMap = (HashMap)getField.get("filterPermissions", null);
    }
}

