/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.service.security;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import org.eclipse.osgi.internal.signedcontent.TrustEngineListener;

public abstract class TrustEngine {
    public abstract Certificate findTrustAnchor(Certificate[] var1) throws IOException;

    public String addTrustAnchor(Certificate certificate, String string) throws IOException, GeneralSecurityException {
        String string2 = this.doAddTrustAnchor(certificate, string);
        TrustEngineListener trustEngineListener = TrustEngineListener.getInstance();
        if (trustEngineListener != null) {
            trustEngineListener.addedTrustAnchor(certificate);
        }
        return string2;
    }

    protected abstract String doAddTrustAnchor(Certificate var1, String var2) throws IOException, GeneralSecurityException;

    public final void removeTrustAnchor(Certificate certificate) throws IOException, GeneralSecurityException {
        this.doRemoveTrustAnchor(certificate);
        TrustEngineListener trustEngineListener = TrustEngineListener.getInstance();
        if (trustEngineListener != null) {
            trustEngineListener.removedTrustAnchor(certificate);
        }
    }

    protected abstract void doRemoveTrustAnchor(Certificate var1) throws IOException, GeneralSecurityException;

    public void removeTrustAnchor(String string) throws IOException, GeneralSecurityException {
        TrustEngineListener trustEngineListener;
        Certificate certificate = this.getTrustAnchor(string);
        this.doRemoveTrustAnchor(string);
        if (certificate != null && (trustEngineListener = TrustEngineListener.getInstance()) != null) {
            trustEngineListener.removedTrustAnchor(certificate);
        }
    }

    protected abstract void doRemoveTrustAnchor(String var1) throws IOException, GeneralSecurityException;

    public abstract Certificate getTrustAnchor(String var1) throws IOException, GeneralSecurityException;

    public abstract String[] getAliases() throws IOException, GeneralSecurityException;

    public abstract boolean isReadOnly();

    public abstract String getName();
}

