/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDescriptionImpl
extends BaseDescriptionImpl
implements GenericDescription {
    private Dictionary<String, Object> attributes;
    private volatile BundleDescription supplier;
    private volatile String type = "generic";
    private Map<String, String> directives;
    private GenericDescription fragmentDeclaration;

    public GenericDescriptionImpl() {
    }

    public GenericDescriptionImpl(BundleDescription bundleDescription, GenericDescription genericDescription) {
        Object object;
        Map<String, String> map;
        this.setType(genericDescription.getType());
        Dictionary<String, Object> dictionary = genericDescription.getAttributes();
        if (dictionary != null) {
            map = new Hashtable<String, String>();
            object = dictionary.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                ((Hashtable)map).put(string, (String)dictionary.get(string));
            }
            this.setAttributes((Dictionary<String, Object>)((Object)map));
        }
        map = genericDescription.getDeclaredDirectives();
        object = new HashMap<String, String>(map);
        this.setDirectives((Map<String, String>)object);
        this.setSupplier(bundleDescription);
        this.fragmentDeclaration = genericDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dictionary<String, Object> getAttributes() {
        Object object = this.monitor;
        synchronized (object) {
            return this.attributes;
        }
    }

    @Override
    public BundleDescription getSupplier() {
        return this.supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttributes(Dictionary<String, Object> dictionary) {
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = dictionary;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDirectives(Map<String, String> map) {
        Object object = this.monitor;
        synchronized (object) {
            this.directives = map;
        }
    }

    void setSupplier(BundleDescription bundleDescription) {
        this.supplier = bundleDescription;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Provide-Capability").append(": ").append(this.getType());
        Map<String, Object> map = this.getDeclaredAttributes();
        stringBuffer.append(GenericDescriptionImpl.toString(map, false));
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        Object object = this.monitor;
        synchronized (object) {
            Object object2 = this.attributes != null ? this.attributes.get(this.getType()) : null;
            return object2 instanceof String ? (String)object2 : null;
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    void setType(String string) {
        this.type = string == null || string.equals("generic") ? "generic" : string;
    }

    @Override
    public Version getVersion() {
        Object object = this.attributes != null ? this.attributes.get("version") : null;
        return object instanceof Version ? (Version)object : super.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getDeclaredDirectives() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.directives == null) {
                return Collections.EMPTY_MAP;
            }
            return Collections.unmodifiableMap(this.directives);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getDeclaredAttributes() {
        Object object = this.monitor;
        synchronized (object) {
            HashMap hashMap = new HashMap(5);
            if (this.attributes != null) {
                Enumeration<String> enumeration = this.attributes.keys();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    List list = this.attributes.get(string);
                    if (list instanceof List) {
                        list = Collections.unmodifiableList(list);
                    }
                    hashMap.put(string, list);
                }
            }
            return Collections.unmodifiableMap(hashMap);
        }
    }

    @Override
    String getInternalNameSpace() {
        return this.getType();
    }

    @Override
    public BaseDescription getFragmentDeclaration() {
        return this.fragmentDeclaration;
    }

    void setFragmentDeclaration(GenericDescription genericDescription) {
        this.fragmentDeclaration = genericDescription;
    }
}

