/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.loader.BundleLoaderProxy;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeDescriptionImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateReader;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateWire;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BundleDescriptionImpl
extends BaseDescriptionImpl
implements BundleDescription,
KeyedElement {
    static final String[] EMPTY_STRING = new String[0];
    static final ImportPackageSpecification[] EMPTY_IMPORTS = new ImportPackageSpecification[0];
    static final BundleSpecification[] EMPTY_BUNDLESPECS = new BundleSpecification[0];
    static final ExportPackageDescription[] EMPTY_EXPORTS = new ExportPackageDescription[0];
    static final BundleDescription[] EMPTY_BUNDLEDESCS = new BundleDescription[0];
    static final GenericSpecification[] EMPTY_GENERICSPECS = new GenericSpecification[0];
    static final GenericDescription[] EMPTY_GENERICDESCS = new GenericDescription[0];
    static final RuntimePermission GET_CLASSLOADER_PERM = new RuntimePermission("getClassLoader");
    static final int RESOLVED = 1;
    static final int SINGLETON = 2;
    static final int REMOVAL_PENDING = 4;
    static final int FULLY_LOADED = 8;
    static final int LAZY_LOADED = 16;
    static final int HAS_DYNAMICIMPORT = 32;
    static final int ATTACH_FRAGMENTS = 64;
    static final int DYNAMIC_FRAGMENTS = 128;
    private volatile int stateBits = 200;
    private volatile long bundleId = -1L;
    volatile HostSpecification host;
    private volatile StateImpl containingState;
    private volatile Object userObject;
    private volatile int lazyDataOffset = -1;
    private volatile int lazyDataSize = -1;
    private List<BundleDescription> dependencies;
    private List<BundleDescription> dependents;
    private String[] mandatory;
    private Map<String, Object> attributes;
    private volatile LazyData lazyData;
    private volatile int equinox_ee = -1;
    private DescriptionWiring bundleWiring;

    @Override
    public long getBundleId() {
        return this.bundleId;
    }

    @Override
    public String getSymbolicName() {
        return this.getName();
    }

    @Override
    public BundleDescription getSupplier() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLocation() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            return lazyData.location;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPlatformFilter() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            return lazyData.platformFilter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getExecutionEnvironments() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (lazyData.executionEnvironments == null) {
                return EMPTY_STRING;
            }
            return lazyData.executionEnvironments;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportPackageSpecification[] getImportPackages() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (lazyData.importPackages == null) {
                return EMPTY_IMPORTS;
            }
            return lazyData.importPackages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportPackageSpecification[] getAddedDynamicImportPackages() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (lazyData.addedDynamicImports == null) {
                return EMPTY_IMPORTS;
            }
            return lazyData.addedDynamicImports.toArray(new ImportPackageSpecification[lazyData.addedDynamicImports.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleSpecification[] getRequiredBundles() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (lazyData.requiredBundles == null) {
                return EMPTY_BUNDLESPECS;
            }
            return lazyData.requiredBundles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericSpecification[] getGenericRequires() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (lazyData.genericRequires == null) {
                return EMPTY_GENERICSPECS;
            }
            return lazyData.genericRequires;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericDescription[] getGenericCapabilities() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (lazyData.genericCapabilities == null) {
                return EMPTY_GENERICDESCS;
            }
            return lazyData.genericCapabilities;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NativeCodeSpecification getNativeCodeSpecification() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            return lazyData.nativeCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportPackageDescription[] getExportPackages() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            return lazyData.exportPackages == null ? EMPTY_EXPORTS : lazyData.exportPackages;
        }
    }

    @Override
    public boolean isResolved() {
        return (this.stateBits & 1) != 0;
    }

    @Override
    public State getContainingState() {
        return this.containingState;
    }

    @Override
    public BundleDescription[] getFragments() {
        if (this.host != null) {
            return EMPTY_BUNDLEDESCS;
        }
        StateImpl stateImpl = (StateImpl)this.getContainingState();
        if (stateImpl == null) {
            throw new IllegalStateException("BundleDescription does not belong to a state.");
        }
        return stateImpl.getFragments(this);
    }

    @Override
    public HostSpecification getHost() {
        return this.host;
    }

    @Override
    public boolean isSingleton() {
        return (this.stateBits & 2) != 0;
    }

    @Override
    public boolean isRemovalPending() {
        return (this.stateBits & 4) != 0;
    }

    @Override
    public boolean hasDynamicImports() {
        return (this.stateBits & 0x20) != 0;
    }

    @Override
    public boolean attachFragments() {
        return (this.stateBits & 0x40) != 0;
    }

    @Override
    public boolean dynamicFragments() {
        return (this.stateBits & 0x80) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportPackageDescription[] getSelectedExports() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (lazyData.selectedExports == null) {
                return EMPTY_EXPORTS;
            }
            return lazyData.selectedExports;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericDescription[] getSelectedGenericCapabilities() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (lazyData.selectedCapabilities == null) {
                return EMPTY_GENERICDESCS;
            }
            return lazyData.selectedCapabilities;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportPackageDescription[] getSubstitutedExports() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (lazyData.substitutedExports == null) {
                return EMPTY_EXPORTS;
            }
            return lazyData.substitutedExports;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleDescription[] getResolvedRequires() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (lazyData.resolvedRequires == null) {
                return EMPTY_BUNDLEDESCS;
            }
            return lazyData.resolvedRequires;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportPackageDescription[] getResolvedImports() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (lazyData.resolvedImports == null) {
                return EMPTY_EXPORTS;
            }
            return lazyData.resolvedImports;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericDescription[] getResolvedGenericRequires() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (lazyData.resolvedCapabilities == null) {
                return EMPTY_GENERICDESCS;
            }
            return lazyData.resolvedCapabilities;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<StateWire>> getWires() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (lazyData.stateWires == null) {
                lazyData.stateWires = new HashMap<String, List<StateWire>>(0);
            }
            return lazyData.stateWires;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, List<StateWire>> getWiresInternal() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            return lazyData.stateWires;
        }
    }

    protected void setBundleId(long l) {
        this.bundleId = l;
    }

    protected void setSymbolicName(String string) {
        this.setName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLocation(String string) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.location = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPlatformFilter(String string) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.platformFilter = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExecutionEnvironments(String[] stringArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.executionEnvironments = stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExportPackages(ExportPackageDescription[] exportPackageDescriptionArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.exportPackages = exportPackageDescriptionArray;
            if (exportPackageDescriptionArray != null) {
                int n = 0;
                while (n < exportPackageDescriptionArray.length) {
                    ((ExportPackageDescriptionImpl)exportPackageDescriptionArray[n]).setExporter(this);
                    ++n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setImportPackages(ImportPackageSpecification[] importPackageSpecificationArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.importPackages = importPackageSpecificationArray;
            if (importPackageSpecificationArray != null) {
                int n = 0;
                while (n < importPackageSpecificationArray.length) {
                    ((ImportPackageSpecificationImpl)importPackageSpecificationArray[n]).setBundle(this);
                    if ("dynamic".equals(importPackageSpecificationArray[n].getDirective("resolution"))) {
                        this.stateBits |= 0x20;
                    }
                    ++n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRequiredBundles(BundleSpecification[] bundleSpecificationArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.requiredBundles = bundleSpecificationArray;
            if (bundleSpecificationArray != null) {
                int n = 0;
                while (n < bundleSpecificationArray.length) {
                    ((VersionConstraintImpl)((Object)bundleSpecificationArray[n])).setBundle(this);
                    ++n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGenericCapabilities(GenericDescription[] genericDescriptionArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.genericCapabilities = genericDescriptionArray;
            if (genericDescriptionArray != null) {
                int n = 0;
                while (n < genericDescriptionArray.length) {
                    ((GenericDescriptionImpl)genericDescriptionArray[n]).setSupplier(this);
                    ++n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGenericRequires(GenericSpecification[] genericSpecificationArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.genericRequires = genericSpecificationArray;
            if (genericSpecificationArray != null) {
                int n = 0;
                while (n < genericSpecificationArray.length) {
                    ((VersionConstraintImpl)((Object)genericSpecificationArray[n])).setBundle(this);
                    ++n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNativeCodeSpecification(NativeCodeSpecification nativeCodeSpecification) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.nativeCode = nativeCodeSpecification;
            if (nativeCodeSpecification != null) {
                ((NativeCodeSpecificationImpl)nativeCodeSpecification).setBundle(this);
                NativeCodeDescription[] nativeCodeDescriptionArray = nativeCodeSpecification.getPossibleSuppliers();
                if (nativeCodeDescriptionArray != null) {
                    int n = 0;
                    while (n < nativeCodeDescriptionArray.length) {
                        ((NativeCodeDescriptionImpl)nativeCodeDescriptionArray[n]).setSupplier(this);
                        ++n;
                    }
                }
            }
        }
    }

    protected int getStateBits() {
        return this.stateBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStateBit(int n, boolean bl) {
        Object object = this.monitor;
        synchronized (object) {
            if (bl) {
                this.stateBits |= n;
            } else {
                this.stateBits &= ~n;
                if (n == 1) {
                    if (this.bundleWiring != null) {
                        this.bundleWiring.invalidate();
                    }
                    this.bundleWiring = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setContainingState(State state) {
        Object object = this.monitor;
        synchronized (object) {
            this.containingState = (StateImpl)state;
            this.stateBits = this.containingState != null && this.containingState.getReader() != null ? (this.containingState.getReader().isLazyLoaded() ? (this.stateBits |= 0x10) : (this.stateBits &= 0xFFFFFFEF)) : (this.stateBits &= 0xFFFFFFEF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setHost(HostSpecification hostSpecification) {
        Object object = this.monitor;
        synchronized (object) {
            this.host = hostSpecification;
            if (hostSpecification != null) {
                ((VersionConstraintImpl)((Object)hostSpecification)).setBundle(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLazyLoaded(boolean bl) {
        this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            this.stateBits = bl ? (this.stateBits |= 0x10) : (this.stateBits &= 0xFFFFFFEF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSelectedExports(ExportPackageDescription[] exportPackageDescriptionArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.selectedExports = exportPackageDescriptionArray;
            if (exportPackageDescriptionArray != null) {
                int n = 0;
                while (n < exportPackageDescriptionArray.length) {
                    ((ExportPackageDescriptionImpl)exportPackageDescriptionArray[n]).setExporter(this);
                    ++n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSelectedCapabilities(GenericDescription[] genericDescriptionArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.selectedCapabilities = genericDescriptionArray;
            if (genericDescriptionArray != null) {
                GenericDescription[] genericDescriptionArray2 = genericDescriptionArray;
                int n = genericDescriptionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GenericDescription genericDescription = genericDescriptionArray2[n2];
                    ((GenericDescriptionImpl)genericDescription).setSupplier(this);
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSubstitutedExports(ExportPackageDescription[] exportPackageDescriptionArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.substitutedExports = exportPackageDescriptionArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setResolvedImports(ExportPackageDescription[] exportPackageDescriptionArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.resolvedImports = exportPackageDescriptionArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setResolvedRequires(BundleDescription[] bundleDescriptionArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.resolvedRequires = bundleDescriptionArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setResolvedCapabilities(GenericDescription[] genericDescriptionArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.resolvedCapabilities = genericDescriptionArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStateWires(Map<String, List<StateWire>> map) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.stateWires = map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAddedDynamicImportPackages() {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.addedDynamicImports = null;
        }
    }

    @Override
    public String toString() {
        if (this.getSymbolicName() == null) {
            return new StringBuffer("[").append(this.getBundleId()).append("]").toString();
        }
        return new StringBuffer(String.valueOf(this.getSymbolicName())).append("_").append(this.getVersion()).toString();
    }

    @Override
    public Object getKey() {
        return new Long(this.bundleId);
    }

    @Override
    public boolean compare(KeyedElement keyedElement) {
        if (!(keyedElement instanceof BundleDescriptionImpl)) {
            return false;
        }
        BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)keyedElement;
        return this.bundleId == bundleDescriptionImpl.bundleId;
    }

    @Override
    public int getKeyHashCode() {
        return (int)(this.bundleId ^ this.bundleId >>> 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDependencies() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.dependencies == null) {
                return;
            }
            Iterator<BundleDescription> iterator = this.dependencies.iterator();
            while (iterator.hasNext()) {
                ((BundleDescriptionImpl)iterator.next()).removeDependent(this);
            }
            this.dependencies = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDependencies(BaseDescription[] baseDescriptionArray, boolean bl) {
        Object object = this.monitor;
        synchronized (object) {
            if (baseDescriptionArray == null) {
                return;
            }
            if (!bl && this.dependencies == null) {
                this.dependencies = new ArrayList<BundleDescription>(baseDescriptionArray.length);
            }
            int n = 0;
            while (n < baseDescriptionArray.length) {
                this.addDependency((BaseDescriptionImpl)baseDescriptionArray[n], bl);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDependency(BaseDescriptionImpl baseDescriptionImpl, boolean bl) {
        Object object = this.monitor;
        synchronized (object) {
            BundleDescriptionImpl bundleDescriptionImpl = (BundleDescriptionImpl)baseDescriptionImpl.getSupplier();
            if (bundleDescriptionImpl == this) {
                return;
            }
            if (this.dependencies == null) {
                this.dependencies = new ArrayList<BundleDescription>(10);
            }
            if (!bl || !this.dependencies.contains(bundleDescriptionImpl)) {
                bundleDescriptionImpl.addDependent(this);
                this.dependencies.add(bundleDescriptionImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<BundleDescription> getBundleDependencies() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.dependencies == null) {
                return new ArrayList<BundleDescription>(0);
            }
            ArrayList<BundleDescription> arrayList = new ArrayList<BundleDescription>(this.dependencies.size());
            for (BundleDescription bundleDescription : this.dependencies) {
                if (bundleDescription == this || bundleDescription.getHost() != null) continue;
                arrayList.add(bundleDescription);
            }
            return arrayList;
        }
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object object) {
        this.userObject = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDependent(BundleDescription bundleDescription) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.dependents == null) {
                this.dependents = new ArrayList<BundleDescription>(10);
            }
            this.dependents.add(bundleDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDependent(BundleDescription bundleDescription) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.dependents == null) {
                return;
            }
            this.dependents.remove(bundleDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleDescription[] getDependents() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.dependents == null) {
                return EMPTY_BUNDLEDESCS;
            }
            return this.dependents.toArray(new BundleDescription[this.dependents.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasDependents() {
        Object object = this.monitor;
        synchronized (object) {
            return this.dependents == null ? false : this.dependents.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFullyLoaded(boolean bl) {
        Object object = this.monitor;
        synchronized (object) {
            this.stateBits = bl ? (this.stateBits |= 8) : (this.stateBits &= 0xFFFFFFF7);
        }
    }

    boolean isFullyLoaded() {
        return (this.stateBits & 8) != 0;
    }

    void setLazyDataOffset(int n) {
        this.lazyDataOffset = n;
    }

    int getLazyDataOffset() {
        return this.lazyDataOffset;
    }

    void setLazyDataSize(int n) {
        this.lazyDataSize = n;
    }

    int getLazyDataSize() {
        return this.lazyDataSize;
    }

    private LazyData loadLazyData() {
        StateReader stateReader;
        if ((this.stateBits & 0x10) == 0) {
            return this.lazyData;
        }
        StateImpl stateImpl = (StateImpl)this.getContainingState();
        StateReader stateReader2 = stateReader = stateImpl == null ? null : stateImpl.getReader();
        if (stateReader == null) {
            throw new IllegalStateException("No valid reader for the bundle description");
        }
        Object object = stateImpl.monitor;
        synchronized (object) {
            if (this.isFullyLoaded()) {
                stateReader.setAccessedFlag(true);
                return this.lazyData;
            }
            try {
                stateReader.fullyLoad(this);
                return this.lazyData;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage(), iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDynamicResolvedImport(ExportPackageDescriptionImpl exportPackageDescriptionImpl) {
        Object object = this.monitor;
        synchronized (object) {
            this.addDependency(exportPackageDescriptionImpl, true);
            this.checkLazyData();
            if (this.lazyData.resolvedImports == null) {
                this.lazyData.resolvedImports = new ExportPackageDescription[]{exportPackageDescriptionImpl};
                return;
            }
            ExportPackageDescription[] exportPackageDescriptionArray = new ExportPackageDescription[this.lazyData.resolvedImports.length + 1];
            System.arraycopy(this.lazyData.resolvedImports, 0, exportPackageDescriptionArray, 0, this.lazyData.resolvedImports.length);
            exportPackageDescriptionArray[exportPackageDescriptionArray.length - 1] = exportPackageDescriptionImpl;
            this.lazyData.resolvedImports = exportPackageDescriptionArray;
        }
        this.setLazyLoaded(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDynamicImportPackages(ImportPackageSpecification[] importPackageSpecificationArray) {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            ImportPackageSpecification importPackageSpecification;
            if (lazyData.addedDynamicImports == null) {
                lazyData.addedDynamicImports = new ArrayList<ImportPackageSpecification>();
            }
            ImportPackageSpecification[] importPackageSpecificationArray2 = importPackageSpecificationArray;
            int n = importPackageSpecificationArray.length;
            int n2 = 0;
            while (n2 < n) {
                importPackageSpecification = importPackageSpecificationArray2[n2];
                if (!"dynamic".equals(importPackageSpecification.getDirective("resolution"))) {
                    throw new IllegalArgumentException("Import must be a dynamic import.");
                }
                ++n2;
            }
            importPackageSpecificationArray2 = importPackageSpecificationArray;
            n = importPackageSpecificationArray.length;
            n2 = 0;
            while (n2 < n) {
                block9: {
                    importPackageSpecification = importPackageSpecificationArray2[n2];
                    for (ImportPackageSpecification importPackageSpecification2 : lazyData.addedDynamicImports) {
                        if (!this.equalImports(importPackageSpecification, importPackageSpecification2)) {
                            continue;
                        }
                        break block9;
                    }
                    ((ImportPackageSpecificationImpl)importPackageSpecification).setBundle(this);
                    lazyData.addedDynamicImports.add(importPackageSpecification);
                }
                ++n2;
            }
        }
        this.setLazyLoaded(false);
    }

    private boolean equalImports(ImportPackageSpecification importPackageSpecification, ImportPackageSpecification importPackageSpecification2) {
        if (!this.isEqual(importPackageSpecification.getName(), importPackageSpecification2.getName())) {
            return false;
        }
        if (!this.isEqual(importPackageSpecification.getVersionRange(), importPackageSpecification2.getVersionRange())) {
            return false;
        }
        if (!this.isEqual(importPackageSpecification.getBundleSymbolicName(), importPackageSpecification2.getBundleSymbolicName())) {
            return false;
        }
        if (!this.isEqual(importPackageSpecification.getBundleVersionRange(), importPackageSpecification2.getBundleVersionRange())) {
            return false;
        }
        return this.isEqual(importPackageSpecification.getAttributes(), importPackageSpecification2.getAttributes());
    }

    private boolean isEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unload() {
        StateReader stateReader;
        StateImpl stateImpl = (StateImpl)this.getContainingState();
        StateReader stateReader2 = stateReader = stateImpl == null ? null : stateImpl.getReader();
        if (stateReader == null) {
            throw new IllegalStateException("BundleDescription does not belong to a reader.");
        }
        Object object = stateImpl.monitor;
        synchronized (object) {
            if ((this.stateBits & 0x10) == 0) {
                return;
            }
            if (!this.isFullyLoaded()) {
                return;
            }
            Object object2 = this.monitor;
            synchronized (object2) {
                this.setFullyLoaded(false);
                this.lazyData = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDynamicStamps(Map<String, Long> map) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.dynamicStamps = map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDynamicStamp(String string, Long l) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            if (this.lazyData.dynamicStamps == null) {
                if (l == null) {
                    return;
                }
                this.lazyData.dynamicStamps = new HashMap<String, Long>();
            }
            if (l == null) {
                this.lazyData.dynamicStamps.remove(string);
            } else {
                this.lazyData.dynamicStamps.put(string, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getDynamicStamp(String string) {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            Long l = lazyData.dynamicStamps == null ? null : lazyData.dynamicStamps.get(string);
            return l == null ? 0L : l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Long> getDynamicStamps() {
        LazyData lazyData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            return lazyData.dynamicStamps;
        }
    }

    public void setEquinoxEE(int n) {
        this.equinox_ee = n;
    }

    public int getEquinoxEE() {
        return this.equinox_ee;
    }

    private void checkLazyData() {
        if (this.lazyData == null) {
            this.lazyData = new LazyData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getAttributes() {
        Object object = this.monitor;
        synchronized (object) {
            return this.attributes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttributes(Map<String, ?> map) {
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getDirective(String string) {
        Object object = this.monitor;
        synchronized (object) {
            block8: {
                block10: {
                    block9: {
                        if ("mandatory".equals(string)) {
                            return this.mandatory;
                        }
                        if ("singleton".equals(string)) {
                            return this.isSingleton() ? Boolean.TRUE : Boolean.FALSE;
                        }
                        if (!"fragment-attachment".equals(string)) break block8;
                        if (this.attachFragments()) break block9;
                        return "never";
                    }
                    if (!this.dynamicFragments()) break block10;
                    return "always";
                }
                return "resolve-time";
            }
        }
        return null;
    }

    void setDirective(String string, Object object) {
        if ("mandatory".equals(string)) {
            this.mandatory = (String[])object;
        }
    }

    @Override
    public Map<String, String> getDeclaredDirectives() {
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        if (!this.attachFragments()) {
            hashMap.put("fragment-attachment", "never");
        } else if (this.dynamicFragments()) {
            hashMap.put("fragment-attachment", "always");
        } else {
            hashMap.put("fragment-attachment", "resolve-time");
        }
        if (this.isSingleton()) {
            hashMap.put("singleton", Boolean.TRUE.toString());
        }
        if ((stringArray = (String[])this.getDirective("mandatory")) != null) {
            hashMap.put("mandatory", ExportPackageDescriptionImpl.toString(stringArray));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getDeclaredAttributes() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
        Object object = this.monitor;
        synchronized (object) {
            if (this.attributes != null) {
                hashMap.putAll(this.attributes);
            }
        }
        hashMap.put("osgi.wiring.bundle", this.getName());
        hashMap.put("bundle-version", this.getVersion());
        return Collections.unmodifiableMap(hashMap);
    }

    @Override
    public List<BundleRequirement> getDeclaredRequirements(String string) {
        VersionConstraint versionConstraint;
        int n;
        int n2;
        VersionConstraint[] versionConstraintArray;
        VersionConstraint[] versionConstraintArray2;
        ArrayList<BundleRequirement> arrayList = new ArrayList<BundleRequirement>();
        if (string == null || "osgi.wiring.bundle".equals(string)) {
            versionConstraintArray2 = this.getRequiredBundles();
            versionConstraintArray = versionConstraintArray2;
            n2 = versionConstraintArray2.length;
            n = 0;
            while (n < n2) {
                versionConstraint = versionConstraintArray[n];
                arrayList.add(versionConstraint.getRequirement());
                ++n;
            }
        }
        if (this.host != null && (string == null || "osgi.wiring.host".equals(string))) {
            arrayList.add(this.host.getRequirement());
        }
        if (string == null || "osgi.wiring.package".equals(string)) {
            versionConstraintArray2 = this.getImportPackages();
            versionConstraintArray = versionConstraintArray2;
            n2 = versionConstraintArray2.length;
            n = 0;
            while (n < n2) {
                versionConstraint = versionConstraintArray[n];
                arrayList.add(versionConstraint.getRequirement());
                ++n;
            }
        }
        versionConstraintArray2 = this.getGenericRequires();
        versionConstraintArray = versionConstraintArray2;
        n2 = versionConstraintArray2.length;
        n = 0;
        while (n < n2) {
            versionConstraint = versionConstraintArray[n];
            if (string == null || string.equals(versionConstraint.getType())) {
                arrayList.add(versionConstraint.getRequirement());
            }
            ++n;
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public List<BundleCapability> getDeclaredCapabilities(String string) {
        BaseDescription baseDescription;
        int n;
        int n2;
        BaseDescription[] baseDescriptionArray;
        BaseDescription[] baseDescriptionArray2;
        ArrayList<BundleCapability> arrayList = new ArrayList<BundleCapability>();
        if (this.host == null && this.getSymbolicName() != null) {
            if (string == null || "osgi.wiring.bundle".equals(string)) {
                arrayList.add(this.getCapability());
            }
            if (this.attachFragments() && (string == null || "osgi.wiring.host".equals(string))) {
                arrayList.add(this.getCapability("osgi.wiring.host"));
            }
        }
        if (string == null || "osgi.wiring.package".equals(string)) {
            baseDescriptionArray2 = this.getExportPackages();
            baseDescriptionArray = baseDescriptionArray2;
            n2 = baseDescriptionArray2.length;
            n = 0;
            while (n < n2) {
                baseDescription = baseDescriptionArray[n];
                arrayList.add(baseDescription.getCapability());
                ++n;
            }
        }
        baseDescriptionArray2 = this.getGenericCapabilities();
        baseDescriptionArray = baseDescriptionArray2;
        n2 = baseDescriptionArray2.length;
        n = 0;
        while (n < n2) {
            baseDescription = baseDescriptionArray[n];
            if (string == null || string.equals(baseDescription.getType())) {
                arrayList.add(baseDescription.getCapability());
            }
            ++n;
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public int getTypes() {
        return this.getHost() != null ? 1 : 0;
    }

    @Override
    public Bundle getBundle() {
        Object object = this.getUserObject();
        if (object instanceof BundleReference) {
            return ((BundleReference)object).getBundle();
        }
        return null;
    }

    @Override
    String getInternalNameSpace() {
        return "osgi.wiring.bundle";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleWiring getWiring() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.bundleWiring != null || !this.isResolved()) {
                return this.bundleWiring;
            }
            this.bundleWiring = new DescriptionWiring();
            return this.bundleWiring;
        }
    }

    static class BundleWireImpl
    implements BundleWire {
        private final BundleCapability capability;
        private final BundleWiring provider;
        private final BundleRequirement requirement;
        private final BundleWiring requirer;

        public BundleWireImpl(StateWire stateWire) {
            VersionConstraint versionConstraint = stateWire.getDeclaredRequirement();
            this.capability = versionConstraint instanceof HostSpecification ? ((BaseDescriptionImpl)stateWire.getDeclaredCapability()).getCapability("osgi.wiring.host") : stateWire.getDeclaredCapability().getCapability();
            this.provider = stateWire.getCapabilityHost().getWiring();
            this.requirement = versionConstraint.getRequirement();
            this.requirer = stateWire.getRequirementHost().getWiring();
        }

        public BundleCapability getCapability() {
            return this.capability;
        }

        public BundleRequirement getRequirement() {
            return this.requirement;
        }

        public BundleWiring getProviderWiring() {
            return this.provider;
        }

        public BundleWiring getRequirerWiring() {
            return this.requirer;
        }

        public int hashCode() {
            int n = 31 + this.capability.hashCode();
            n = n * 31 + this.requirement.hashCode();
            n = n * 31 + this.provider.hashCode();
            n = n * 31 + this.requirer.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof BundleWireImpl)) {
                return false;
            }
            BundleWireImpl bundleWireImpl = (BundleWireImpl)object;
            return this.capability.equals(bundleWireImpl.getCapability()) && this.requirement.equals(bundleWireImpl.getRequirement()) && this.provider.equals(bundleWireImpl.getProviderWiring()) && this.requirer.equals(bundleWireImpl.getRequirerWiring());
        }

        public String toString() {
            return this.getRequirement() + " -> " + this.getCapability();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DescriptionWiring
    implements BundleWiring {
        private volatile boolean valid = true;

        DescriptionWiring() {
        }

        @Override
        public Bundle getBundle() {
            return BundleDescriptionImpl.this.getBundle();
        }

        @Override
        public boolean isInUse() {
            return this.valid && (this.isCurrent() || BundleDescriptionImpl.this.hasDependents());
        }

        void invalidate() {
            this.valid = false;
        }

        @Override
        public boolean isCurrent() {
            return this.valid && !BundleDescriptionImpl.this.isRemovalPending();
        }

        @Override
        public List<BundleCapability> getCapabilities(String string) {
            BaseDescription baseDescription;
            int n;
            int n2;
            BaseDescription[] baseDescriptionArray;
            BaseDescription[] baseDescriptionArray2;
            if (!this.isInUse()) {
                return null;
            }
            ArrayList<BundleCapability> arrayList = Collections.EMPTY_LIST;
            if (BundleDescriptionImpl.this.host != null) {
                return arrayList;
            }
            arrayList = new ArrayList<BundleCapability>();
            if (BundleDescriptionImpl.this.getSymbolicName() != null) {
                if (string == null || "osgi.wiring.bundle".equals(string)) {
                    arrayList.add(BundleDescriptionImpl.this.getCapability());
                }
                if (BundleDescriptionImpl.this.attachFragments() && (string == null || "osgi.wiring.host".equals(string))) {
                    arrayList.add(BundleDescriptionImpl.this.getCapability("osgi.wiring.host"));
                }
            }
            if (string == null || "osgi.wiring.package".equals(string)) {
                baseDescriptionArray2 = BundleDescriptionImpl.this.getSelectedExports();
                baseDescriptionArray = baseDescriptionArray2;
                n2 = baseDescriptionArray2.length;
                n = 0;
                while (n < n2) {
                    baseDescription = baseDescriptionArray[n];
                    arrayList.add(baseDescription.getCapability());
                    ++n;
                }
            }
            baseDescriptionArray2 = BundleDescriptionImpl.this.getSelectedGenericCapabilities();
            baseDescriptionArray = baseDescriptionArray2;
            n2 = baseDescriptionArray2.length;
            n = 0;
            while (n < n2) {
                baseDescription = baseDescriptionArray[n];
                if (string == null || string.equals(baseDescription.getType())) {
                    arrayList.add(baseDescription.getCapability());
                }
                ++n;
            }
            return arrayList;
        }

        @Override
        public List<BundleRequirement> getRequirements(String string) {
            List<BundleWire> list = this.getRequiredWires(string);
            if (list == null) {
                return null;
            }
            ArrayList<BundleRequirement> arrayList = new ArrayList<BundleRequirement>(list.size());
            for (BundleWire importPackageSpecificationArray : list) {
                if (arrayList.contains(importPackageSpecificationArray.getRequirement())) continue;
                arrayList.add(importPackageSpecificationArray.getRequirement());
            }
            if ((string == null || "osgi.wiring.package".equals(string)) && BundleDescriptionImpl.this.hasDynamicImports()) {
                ImportPackageSpecification[] importPackageSpecificationArray;
                ImportPackageSpecification[] importPackageSpecificationArray2 = importPackageSpecificationArray = BundleDescriptionImpl.this.getImportPackages();
                int n = importPackageSpecificationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BundleRequirement bundleRequirement;
                    ImportPackageSpecification importPackageSpecification = importPackageSpecificationArray2[n2];
                    if ("dynamic".equals(importPackageSpecification.getDirective("resolution")) && !arrayList.contains(bundleRequirement = importPackageSpecification.getRequirement())) {
                        arrayList.add(bundleRequirement);
                    }
                    ++n2;
                }
            }
            return arrayList;
        }

        @Override
        public List<BundleWire> getProvidedWires(String string) {
            List<BundleWire> list;
            Object object;
            if (!this.isInUse()) {
                return null;
            }
            BundleDescription[] bundleDescriptionArray = BundleDescriptionImpl.this.getDependents();
            ArrayList<BundleWire> arrayList = new ArrayList<BundleWire>();
            BundleDescription[] bundleDescriptionArray2 = bundleDescriptionArray;
            int n = bundleDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = bundleDescriptionArray2[n2];
                list = object.getWiring().getRequiredWires(string);
                if (list != null) {
                    for (BundleWire bundleWire : list) {
                        if (bundleWire.getProviderWiring() != this) continue;
                        arrayList.add(bundleWire);
                    }
                }
                ++n2;
            }
            object = new ArrayList(arrayList.size());
            List<BundleCapability> list2 = this.getCapabilities(string);
            for (BundleCapability bundleCapability : list2) {
                list = arrayList.iterator();
                while (list.hasNext()) {
                    BundleWire bundleWire;
                    bundleWire = (BundleWire)list.next();
                    if (!bundleWire.getCapability().equals(bundleCapability)) continue;
                    list.remove();
                    object.add(bundleWire);
                }
            }
            return object;
        }

        @Override
        public List<BundleWire> getRequiredWires(String string) {
            if (!this.isInUse()) {
                return null;
            }
            ArrayList<BundleWire> arrayList = Collections.EMPTY_LIST;
            Map<String, List<StateWire>> map = BundleDescriptionImpl.this.getWires();
            if (string == null) {
                arrayList = new ArrayList<BundleWire>();
                for (List<StateWire> list : map.values()) {
                    for (StateWire stateWire : list) {
                        arrayList.add(new BundleWireImpl(stateWire));
                    }
                }
                return arrayList;
            }
            List<StateWire> list = map.get(string);
            if (list == null) {
                return arrayList;
            }
            arrayList = new ArrayList(list.size());
            for (StateWire stateWire : list) {
                arrayList.add(new BundleWireImpl(stateWire));
            }
            return arrayList;
        }

        @Override
        public BundleRevision getRevision() {
            return BundleDescriptionImpl.this;
        }

        @Override
        public ClassLoader getClassLoader() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(GET_CLASSLOADER_PERM);
            }
            if (!this.isInUse()) {
                return null;
            }
            return (ClassLoader)((Object)this.getBundleClassLoader());
        }

        private BundleClassLoader getBundleClassLoader() {
            Object object = BundleDescriptionImpl.this.getUserObject();
            if (!(object instanceof BundleLoaderProxy)) {
                if (object instanceof BundleReference) {
                    object = ((BundleReference)object).getBundle();
                }
                if (object instanceof BundleHost) {
                    object = ((BundleHost)object).getLoaderProxy();
                }
            }
            if (object instanceof BundleLoaderProxy) {
                return ((BundleLoaderProxy)object).getBundleLoader().createClassLoader();
            }
            return null;
        }

        private boolean hasResourcePermission() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkPermission(new AdminPermission(this.getBundle(), "resource"));
                }
                catch (SecurityException securityException) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public List<URL> findEntries(String string, String string2, int n) {
            if (!this.hasResourcePermission() || !this.isInUse()) {
                return null;
            }
            List<URL> list = Collections.EMPTY_LIST;
            BundleClassLoader bundleClassLoader = this.getBundleClassLoader();
            if (bundleClassLoader != null) {
                list = bundleClassLoader.findEntries(string, string2, n);
            }
            return Collections.unmodifiableList(list);
        }

        @Override
        public Collection<String> listResources(String string, String string2, int n) {
            if (!this.hasResourcePermission() || !this.isInUse()) {
                return null;
            }
            Collection<Object> collection = Collections.EMPTY_LIST;
            BundleClassLoader bundleClassLoader = this.getBundleClassLoader();
            if (bundleClassLoader != null) {
                collection = bundleClassLoader.listResources(string, string2, n);
            }
            return Collections.unmodifiableCollection(collection);
        }

        public String toString() {
            return BundleDescriptionImpl.this.toString();
        }
    }

    final class LazyData {
        String location;
        String platformFilter;
        BundleSpecification[] requiredBundles;
        ExportPackageDescription[] exportPackages;
        ImportPackageSpecification[] importPackages;
        GenericDescription[] genericCapabilities;
        GenericSpecification[] genericRequires;
        NativeCodeSpecification nativeCode;
        ExportPackageDescription[] selectedExports;
        GenericDescription[] selectedCapabilities;
        BundleDescription[] resolvedRequires;
        ExportPackageDescription[] resolvedImports;
        GenericDescription[] resolvedCapabilities;
        ExportPackageDescription[] substitutedExports;
        String[] executionEnvironments;
        Map<String, Long> dynamicStamps;
        Map<String, List<StateWire>> stateWires;
        List<ImportPackageSpecification> addedDynamicImports;

        LazyData() {
        }
    }
}

