/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.List;
import org.eclipse.osgi.internal.module.MappedList;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.module.VersionSupplier;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionHashMap<V extends VersionSupplier>
extends MappedList<String, V>
implements Comparator<V> {
    private final ResolverImpl resolver;
    private final boolean preferSystemPackages;

    public VersionHashMap(ResolverImpl resolverImpl) {
        String string;
        this.resolver = resolverImpl;
        Dictionary[] dictionaryArray = resolverImpl.getState().getPlatformProperties();
        String string2 = string = dictionaryArray.length == 0 ? "true" : dictionaryArray[0].get("osgi.resolver.preferSystemPackages");
        if (string == null) {
            string = "true";
        }
        this.preferSystemPackages = Boolean.valueOf(string.toString());
    }

    @Override
    protected int insertionIndex(List<V> list, V v) {
        int n = list.size();
        if (this.compare((V)((VersionSupplier)list.get(list.size() - 1)), v) > 0 && (n = Collections.binarySearch(list, v, this)) < 0) {
            n = -n - 1;
        }
        return n;
    }

    public void put(V[] VArray) {
        int n = 0;
        while (n < VArray.length) {
            this.put(((VersionSupplier)VArray[n]).getName(), VArray[n]);
            ++n;
        }
    }

    public boolean contains(V v) {
        return this.contains(v, false) != null;
    }

    private V contains(V v, boolean bl) {
        List list = (List)this.internal.get(((VersionSupplier)v).getName());
        if (list == null) {
            return null;
        }
        int n = list.indexOf(v);
        if (n >= 0) {
            if (bl) {
                list.remove(n);
                if (list.size() == 0) {
                    this.internal.remove(((VersionSupplier)v).getName());
                }
            }
            return v;
        }
        return null;
    }

    public V remove(V v) {
        return this.contains(v, true);
    }

    public void remove(V[] VArray) {
        int n = 0;
        while (n < VArray.length) {
            this.remove(VArray[n]);
            ++n;
        }
    }

    void reorder() {
        for (List list : this.internal.values()) {
            if (list.size() <= 1) continue;
            Collections.sort(list, this);
        }
    }

    @Override
    public int compare(V v, V v2) {
        if (this.resolver.getSelectionPolicy() != null) {
            return this.resolver.getSelectionPolicy().compare(((VersionSupplier)v).getBaseDescription(), ((VersionSupplier)v2).getBaseDescription());
        }
        if (this.preferSystemPackages) {
            String string = this.resolver.getSystemBundle();
            if (string.equals(((VersionSupplier)v).getBundleDescription().getSymbolicName()) && !string.equals(((VersionSupplier)v2).getBundleDescription().getSymbolicName())) {
                return -1;
            }
            if (!string.equals(((VersionSupplier)v).getBundleDescription().getSymbolicName()) && string.equals(((VersionSupplier)v2).getBundleDescription().getSymbolicName())) {
                return 1;
            }
        }
        if (((VersionSupplier)v).getBundleDescription().isResolved() != ((VersionSupplier)v2).getBundleDescription().isResolved()) {
            return ((VersionSupplier)v).getBundleDescription().isResolved() ? -1 : 1;
        }
        int n = -((VersionSupplier)v).getVersion().compareTo(((VersionSupplier)v2).getVersion());
        if (n != 0) {
            return n;
        }
        return ((VersionSupplier)v).getBundleDescription().getBundleId() <= ((VersionSupplier)v2).getBundleDescription().getBundleId() ? -1 : 1;
    }
}

