/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.baseadaptor.ArrayMap;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.CompositeResolveHelper;
import org.eclipse.osgi.internal.module.CompositeResolveHelperRegistry;
import org.eclipse.osgi.internal.module.GenericCapability;
import org.eclipse.osgi.internal.module.GenericConstraint;
import org.eclipse.osgi.internal.module.GroupingChecker;
import org.eclipse.osgi.internal.module.MappedList;
import org.eclipse.osgi.internal.module.PermissionChecker;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverConstraint;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionHashMap;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.DisabledInfo;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateWire;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.wiring.BundleCapability;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverImpl
implements Resolver {
    private static final String RESOLVER = "org.eclipse.osgi/resolver";
    private static final String OPTION_DEBUG = "org.eclipse.osgi/resolver/debug";
    private static final String OPTION_WIRING = "org.eclipse.osgi/resolver/wiring";
    private static final String OPTION_IMPORTS = "org.eclipse.osgi/resolver/imports";
    private static final String OPTION_REQUIRES = "org.eclipse.osgi/resolver/requires";
    private static final String OPTION_GENERICS = "org.eclipse.osgi/resolver/generics";
    private static final String OPTION_USES = "org.eclipse.osgi/resolver/uses";
    private static final String OPTION_CYCLES = "org.eclipse.osgi/resolver/cycles";
    public static boolean DEBUG = false;
    public static boolean DEBUG_WIRING = false;
    public static boolean DEBUG_IMPORTS = false;
    public static boolean DEBUG_REQUIRES = false;
    public static boolean DEBUG_GENERICS = false;
    public static boolean DEBUG_USES = false;
    public static boolean DEBUG_CYCLES = false;
    private static int MAX_MULTIPLE_SUPPLIERS_MERGE = 10;
    private static int MAX_USES_TIME_BASE = 30000;
    private static int MAX_USES_TIME_LIMIT = 90000;
    static final SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    private String[][] CURRENT_EES;
    private ResolverHook hook;
    private State state;
    private final PermissionChecker permissionChecker;
    private MappedList<Long, BundleDescription> removalPending = new MappedList();
    private boolean initialized = false;
    private VersionHashMap<ResolverExport> resolverExports = null;
    private VersionHashMap<ResolverBundle> resolverBundles = null;
    private Map<String, VersionHashMap<GenericCapability>> resolverGenerics = null;
    private HashSet<ResolverBundle> unresolvedBundles = null;
    private HashMap<BundleDescription, ResolverBundle> bundleMapping = null;
    private GroupingChecker groupingChecker;
    private Comparator<BaseDescription> selectionPolicy;
    private boolean developmentMode = false;
    private boolean usesCalculationTimeout = false;
    private long usesTimeout = -1L;
    private volatile CompositeResolveHelperRegistry compositeHelpers;

    public ResolverImpl(boolean bl) {
        this.permissionChecker = new PermissionChecker(bl, this);
    }

    PermissionChecker getPermissionChecker() {
        return this.permissionChecker;
    }

    private void initialize() {
        this.resolverExports = new VersionHashMap(this);
        this.resolverBundles = new VersionHashMap(this);
        this.resolverGenerics = new HashMap<String, VersionHashMap<GenericCapability>>();
        this.unresolvedBundles = new HashSet();
        this.bundleMapping = new HashMap();
        BundleDescription[] bundleDescriptionArray = this.state.getBundles();
        this.groupingChecker = new GroupingChecker();
        ArrayList<ResolverBundle> arrayList = new ArrayList<ResolverBundle>();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            this.initResolverBundle(bundleDescriptionArray[n], arrayList, false);
            ++n;
        }
        List<BundleDescription> list = this.removalPending.getAllValues();
        for (BundleDescription bundleDescription : list) {
            this.initResolverBundle(bundleDescription, arrayList, true);
        }
        for (ResolverBundle resolverBundle : arrayList) {
            BundleDescription[] bundleDescriptionArray2 = ((HostSpecification)resolverBundle.getHost().getVersionConstraint()).getHosts();
            int n2 = 0;
            while (n2 < bundleDescriptionArray2.length) {
                ResolverBundle resolverBundle2 = this.bundleMapping.get(bundleDescriptionArray2[n2]);
                if (resolverBundle2 != null) {
                    resolverBundle2.attachFragment(resolverBundle, false);
                }
                ++n2;
            }
        }
        this.rewireBundles();
        this.setDebugOptions();
        this.initialized = true;
    }

    private void initResolverBundle(BundleDescription bundleDescription, ArrayList<ResolverBundle> arrayList, boolean bl) {
        ResolverBundle resolverBundle = new ResolverBundle(bundleDescription, this);
        this.bundleMapping.put(bundleDescription, resolverBundle);
        if (!bl || bundleDescription.isResolved()) {
            this.resolverExports.put(resolverBundle.getExportPackages());
            this.resolverBundles.put(resolverBundle.getName(), resolverBundle);
            this.addGenerics(resolverBundle.getGenericCapabilities());
        }
        if (bundleDescription.isResolved()) {
            resolverBundle.setState(2);
            if (bundleDescription.getHost() != null) {
                arrayList.add(resolverBundle);
            }
        } else if (!bl) {
            this.unresolvedBundles.add(resolverBundle);
        }
    }

    private void rewireBundles() {
        ArrayList<ResolverBundle> arrayList = new ArrayList<ResolverBundle>(this.bundleMapping.size());
        for (ResolverBundle resolverBundle : this.bundleMapping.values()) {
            if (!resolverBundle.getBundleDescription().isResolved() || resolverBundle.isFragment()) continue;
            this.rewireBundle(resolverBundle, arrayList);
        }
    }

    private void rewireBundle(ResolverBundle resolverBundle, List<ResolverBundle> list) {
        if (list.contains(resolverBundle)) {
            return;
        }
        list.add(resolverBundle);
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        int n = 0;
        while (n < bundleConstraintArray.length) {
            this.rewireRequire(bundleConstraintArray[n], list);
            ++n;
        }
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        int n2 = 0;
        while (n2 < resolverImportArray.length) {
            this.rewireImport(resolverImportArray[n2], list);
            ++n2;
        }
        GenericConstraint[] genericConstraintArray = resolverBundle.getGenericRequires();
        int n3 = 0;
        while (n3 < genericConstraintArray.length) {
            this.rewireGeneric(genericConstraintArray[n3], list);
            ++n3;
        }
    }

    private void rewireGeneric(GenericConstraint genericConstraint, List<ResolverBundle> list) {
        Object object2;
        if (genericConstraint.getSelectedSupplier() != null) {
            return;
        }
        GenericDescription[] genericDescriptionArray = ((GenericSpecification)genericConstraint.getVersionConstraint()).getSuppliers();
        if (genericDescriptionArray == null) {
            return;
        }
        VersionHashMap<GenericCapability> versionHashMap = this.resolverGenerics.get(genericConstraint.getNameSpace());
        if (versionHashMap == null) {
            System.err.println(new StringBuffer("Could not find matching capability for ").append(genericConstraint.getVersionConstraint()).toString());
            return;
        }
        String string = genericConstraint.getName();
        List list2 = string == null ? versionHashMap.get(string) : versionHashMap.getAllValues();
        for (Object object2 : list2) {
            GenericDescription[] genericDescriptionArray2 = genericDescriptionArray;
            int n = genericDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericDescription genericDescription = genericDescriptionArray2[n2];
                if (((VersionSupplier)object2).getBaseDescription() == genericDescription) {
                    genericConstraint.addPossibleSupplier((VersionSupplier)object2);
                }
                ++n2;
            }
        }
        object2 = genericConstraint.getPossibleSuppliers();
        if (object2 != null) {
            int n = 0;
            while (n < ((VersionSupplier[])object2).length) {
                this.rewireBundle(object2[n].getResolverBundle(), list);
                ++n;
            }
        }
    }

    private void rewireRequire(BundleConstraint bundleConstraint, List<ResolverBundle> list) {
        if (bundleConstraint.getSelectedSupplier() != null) {
            return;
        }
        ResolverBundle resolverBundle = this.bundleMapping.get(bundleConstraint.getVersionConstraint().getSupplier());
        bundleConstraint.addPossibleSupplier(resolverBundle);
        if (resolverBundle == null && !bundleConstraint.isOptional()) {
            System.err.println(new StringBuffer("Could not find matching bundle for ").append(bundleConstraint.getVersionConstraint()).toString());
        }
        if (resolverBundle != null) {
            this.rewireBundle(resolverBundle, list);
        }
    }

    private void rewireImport(ResolverImport resolverImport, List<ResolverBundle> list) {
        if (resolverImport.isDynamic() || resolverImport.getSelectedSupplier() != null) {
            return;
        }
        ResolverExport resolverExport = null;
        ExportPackageDescription exportPackageDescription = (ExportPackageDescription)resolverImport.getVersionConstraint().getSupplier();
        ResolverBundle resolverBundle = exportPackageDescription == null ? null : this.bundleMapping.get(exportPackageDescription.getExporter());
        List list2 = this.resolverExports.get(resolverImport.getName());
        for (ResolverExport resolverExport2 : list2) {
            if (resolverExport2.getExporter() != resolverBundle || exportPackageDescription != resolverExport2.getExportPackageDescription()) continue;
            resolverExport = resolverExport2;
            break;
        }
        resolverImport.addPossibleSupplier(resolverExport);
        if (resolverImport.getSelectedSupplier() == null && !resolverImport.isOptional()) {
            System.err.println(new StringBuffer("Could not find matching export for ").append(resolverImport.getVersionConstraint()).toString());
        }
        if (resolverImport.getSelectedSupplier() != null) {
            this.rewireBundle(((ResolverExport)resolverImport.getSelectedSupplier()).getExporter(), list);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isResolvable(ResolverBundle resolverBundle, Dictionary<Object, Object>[] dictionaryArray, Collection<ResolverBundle> collection) {
        String string;
        int n;
        int n2;
        boolean bl;
        BundleDescription bundleDescription = resolverBundle.getBundleDescription();
        if (collection.contains(resolverBundle)) {
            this.state.addResolverError(bundleDescription, 262144, "Resolver hook disabled bundle.", null);
            return false;
        }
        DisabledInfo[] disabledInfoArray = this.state.getDisabledInfos(bundleDescription);
        if (disabledInfoArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < disabledInfoArray.length) {
                if (n3 > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append('\"').append(disabledInfoArray[n3].getPolicyName()).append(':').append(disabledInfoArray[n3].getMessage()).append('\"');
                ++n3;
            }
            this.state.addResolverError(bundleDescription, 262144, stringBuffer.toString(), null);
            return false;
        }
        String[] stringArray = bundleDescription.getExecutionEnvironments();
        boolean bl2 = bl = stringArray.length == 0;
        if (!bl) {
            int n4 = 0;
            while (n4 < stringArray.length && !bl) {
                n2 = 0;
                while (n2 < this.CURRENT_EES.length && !bl) {
                    int n5 = 0;
                    while (n5 < this.CURRENT_EES[n2].length && !bl) {
                        if (this.CURRENT_EES[n2][n5].equals(stringArray[n4])) {
                            ((BundleDescriptionImpl)bundleDescription).setEquinoxEE(n2);
                            bl = true;
                        }
                        ++n5;
                    }
                    ++n2;
                }
                ++n4;
            }
        }
        if (!bl) {
            StringBuffer stringBuffer = new StringBuffer("Bundle-RequiredExecutionEnvironment".length() + 20);
            stringBuffer.append("Bundle-RequiredExecutionEnvironment").append(": ");
            n2 = 0;
            while (n2 < stringArray.length) {
                if (n2 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(stringArray[n2]);
                ++n2;
            }
            this.state.addResolverError(bundleDescription, 16384, stringBuffer.toString(), null);
            return false;
        }
        NativeCodeSpecification nativeCodeSpecification = bundleDescription.getNativeCodeSpecification();
        if (nativeCodeSpecification != null) {
            NativeCodeDescription[] nativeCodeDescriptionArray = nativeCodeSpecification.getPossibleSuppliers();
            NativeCodeDescription nativeCodeDescription = null;
            n = 0;
            while (n < nativeCodeDescriptionArray.length) {
                if (nativeCodeSpecification.isSatisfiedBy(nativeCodeDescriptionArray[n]) && (nativeCodeDescription == null || nativeCodeDescription.compareTo(nativeCodeDescriptionArray[n]) < 0)) {
                    nativeCodeDescription = nativeCodeDescriptionArray[n];
                }
                ++n;
            }
            if (nativeCodeDescription == null) {
                if (!nativeCodeSpecification.isOptional()) {
                    this.state.addResolverError(bundleDescription, 65536, nativeCodeSpecification.toString(), nativeCodeSpecification);
                    return false;
                }
            } else if (nativeCodeDescription.hasInvalidNativePaths()) {
                this.state.addResolverError(bundleDescription, 131072, nativeCodeDescription.toString(), nativeCodeSpecification);
                return false;
            }
            this.state.resolveConstraint(nativeCodeSpecification, nativeCodeDescription);
        }
        if ((string = bundleDescription.getPlatformFilter()) == null) {
            return true;
        }
        if (dictionaryArray == null) {
            return false;
        }
        try {
            FilterImpl filterImpl = FilterImpl.newInstance(string);
            n = 0;
            while (n < dictionaryArray.length) {
                Dictionary<Object, Object> dictionary = dictionaryArray[n];
                if (filterImpl.matchCase(dictionary)) {
                    return true;
                }
                ++n;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.state.addResolverError(bundleDescription, 8192, string, null);
        return false;
    }

    private void attachFragment(ResolverBundle resolverBundle, Collection<String> collection) {
        if (collection.contains(resolverBundle.getName())) {
            return;
        }
        collection.add(resolverBundle.getName());
        List list = this.resolverBundles.get(resolverBundle.getName());
        for (ResolverBundle resolverBundle2 : list) {
            if (resolverBundle2.isResolved()) continue;
            this.attachFragment0(resolverBundle2);
        }
    }

    private void attachFragment0(ResolverBundle resolverBundle) {
        if (!resolverBundle.isFragment() || !resolverBundle.isResolvable()) {
            return;
        }
        boolean bl = false;
        BundleConstraint bundleConstraint = resolverBundle.getHost();
        List list = this.resolverBundles.get(bundleConstraint.getVersionConstraint().getName());
        ArrayList arrayList = new ArrayList(list);
        ArrayList<BundleCapability> arrayList2 = new ArrayList<BundleCapability>(list.size());
        Object object2 = arrayList.iterator();
        while (object2.hasNext()) {
            ResolverBundle resolverBundle2 = (ResolverBundle)object2.next();
            if (!(resolverBundle2.isResolvable() && resolverBundle2.getBundleDescription().attachFragments() && bundleConstraint.isSatisfiedBy(resolverBundle2))) {
                object2.remove();
                continue;
            }
            List<BundleCapability> list2 = resolverBundle2.getBundleDescription().getDeclaredCapabilities("osgi.wiring.host");
            arrayList2.add(list2.get(0));
        }
        if (this.hook != null) {
            this.hook.filterMatches(bundleConstraint.getRequirement(), ResolverImpl.asCapabilities(new ArrayMap(arrayList2, arrayList)));
        }
        for (Object object2 : arrayList) {
            bl = true;
            ((ResolverBundle)object2).attachFragment(resolverBundle, true);
        }
        if (!bl) {
            this.state.addResolverError(resolverBundle.getBundleDescription(), 4, resolverBundle.getHost().getVersionConstraint().toString(), resolverBundle.getHost().getVersionConstraint());
        }
    }

    @Override
    public synchronized void resolve(BundleDescription[] bundleDescriptionArray, Dictionary<Object, Object>[] dictionaryArray) {
        if (DEBUG) {
            ResolverImpl.log("*** BEGIN RESOLUTION ***");
        }
        if (this.state == null) {
            throw new IllegalStateException("RESOLVER_NO_STATE");
        }
        if (!this.initialized) {
            this.initialize();
        }
        this.hook = this.state instanceof StateImpl ? ((StateImpl)this.state).getResolverHook() : null;
        try {
            Object object;
            ResolverBundle[] resolverBundleArray;
            this.developmentMode = dictionaryArray.length == 0 ? false : "development".equals(dictionaryArray[0].get("osgi.resolverMode"));
            try {
                Object object2 = dictionaryArray.length == 0 ? null : dictionaryArray[0].get("osgi.usesTimeout");
                this.usesTimeout = object2 == null ? -1L : Long.parseLong(object2.toString());
            }
            catch (NumberFormatException numberFormatException) {
                this.usesTimeout = -1L;
            }
            bundleDescriptionArray = this.addDevConstraints(bundleDescriptionArray);
            if (bundleDescriptionArray != null) {
                int n = 0;
                while (n < bundleDescriptionArray.length) {
                    resolverBundleArray = this.bundleMapping.get(bundleDescriptionArray[n]);
                    if (resolverBundleArray != null) {
                        this.unresolveBundle((ResolverBundle)resolverBundleArray, false);
                    }
                    ++n;
                }
            }
            this.resolverExports.reorder();
            this.resolverBundles.reorder();
            this.reorderGenerics();
            this.getCurrentEEs(dictionaryArray);
            boolean bl = dictionaryArray.length == 0 ? false : "true".equals(dictionaryArray[0].get("osgi.resolveOptional"));
            resolverBundleArray = null;
            if (bl) {
                object = this.state.getResolvedBundles();
                resolverBundleArray = new ResolverBundle[((BundleDescription[])object).length];
                int n = 0;
                while (n < ((BundleDescription[])object).length) {
                    resolverBundleArray[n] = this.bundleMapping.get(object[n]);
                    ++n;
                }
            }
            object = Collections.EMPTY_LIST;
            if (this.hook != null) {
                ArrayList<ResolverBundle> arrayList = new ArrayList<ResolverBundle>(this.unresolvedBundles);
                ArrayList<BundleDescription> arrayList2 = new ArrayList<BundleDescription>(arrayList.size());
                for (ResolverBundle object32 : arrayList) {
                    arrayList2.add(object32.getBundleDescription());
                }
                ArrayMap arrayMap = new ArrayMap(arrayList2, arrayList);
                int n = arrayList.size();
                this.hook.filterResolvable(arrayMap);
                if (arrayMap.size() < n) {
                    object = new ArrayList<ResolverBundle>(this.unresolvedBundles);
                    object.removeAll(arrayList);
                }
            }
            ResolverBundle[] resolverBundleArray2 = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
            this.usesCalculationTimeout = false;
            this.resolveBundles(resolverBundleArray2, dictionaryArray, (Collection<ResolverBundle>)object);
            this.resolverExports.reorder();
            this.resolverBundles.reorder();
            this.reorderGenerics();
            if (bl) {
                this.resolveOptionalConstraints(resolverBundleArray);
            }
            if (DEBUG) {
                ResolverImpl.log("*** END RESOLUTION ***");
            }
        }
        finally {
            this.hook = null;
        }
    }

    private BundleDescription[] addDevConstraints(BundleDescription[] bundleDescriptionArray) {
        if (!this.developmentMode) {
            return bundleDescriptionArray;
        }
        HashSet<BundleDescription> hashSet = new HashSet<BundleDescription>();
        ResolverBundle[] resolverBundleArray = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
        int n = 0;
        while (n < resolverBundleArray.length) {
            this.addUnresolvedWithDependents(resolverBundleArray[n], hashSet);
            this.addHostsFromFragmentConstraints(resolverBundleArray[n], hashSet);
            ++n;
        }
        if (hashSet.size() == 0) {
            return bundleDescriptionArray;
        }
        if (bundleDescriptionArray != null) {
            n = 0;
            while (n < bundleDescriptionArray.length) {
                hashSet.add(bundleDescriptionArray[n]);
                ++n;
            }
        }
        return hashSet.toArray(new BundleDescription[hashSet.size()]);
    }

    private void addUnresolvedWithDependents(ResolverBundle resolverBundle, Set<BundleDescription> set) {
        BundleDescription[] bundleDescriptionArray = resolverBundle.getBundleDescription().getDependents();
        if (bundleDescriptionArray.length > 0) {
            set.add(resolverBundle.getBundleDescription());
        }
    }

    private void addHostsFromFragmentConstraints(ResolverBundle resolverBundle, Set<BundleDescription> set) {
        if (!resolverBundle.isFragment()) {
            return;
        }
        ImportPackageSpecification[] importPackageSpecificationArray = resolverBundle.getBundleDescription().getImportPackages();
        BundleSpecification[] bundleSpecificationArray = resolverBundle.getBundleDescription().getRequiredBundles();
        if (importPackageSpecificationArray.length == 0 && bundleSpecificationArray.length == 0) {
            return;
        }
        BundleConstraint bundleConstraint = resolverBundle.getHost();
        List list = this.resolverBundles.get(bundleConstraint.getVersionConstraint().getName());
        for (ResolverBundle resolverBundle2 : list) {
            if (!bundleConstraint.isSatisfiedBy(resolverBundle2) || !resolverBundle2.isResolved()) continue;
            set.add(resolverBundle2.getBundleDescription());
        }
    }

    private void resolveOptionalConstraints(ResolverBundle[] resolverBundleArray) {
        int n = 0;
        while (n < resolverBundleArray.length) {
            if (resolverBundleArray[n] != null) {
                this.resolveOptionalConstraints(resolverBundleArray[n]);
            }
            ++n;
        }
    }

    private void resolveOptionalConstraints(ResolverBundle resolverBundle) {
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        ArrayList<ResolverBundle> arrayList = new ArrayList<ResolverBundle>();
        boolean bl = false;
        int n = 0;
        while (n < bundleConstraintArray.length) {
            if (bundleConstraintArray[n].isOptional() && bundleConstraintArray[n].getSelectedSupplier() == null) {
                arrayList.clear();
                this.resolveRequire(bundleConstraintArray[n], arrayList);
                if (bundleConstraintArray[n].getSelectedSupplier() != null) {
                    bl = true;
                }
            }
            ++n;
        }
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        int n2 = 0;
        while (n2 < resolverImportArray.length) {
            if (resolverImportArray[n2].isOptional() && resolverImportArray[n2].getSelectedSupplier() == null) {
                arrayList.clear();
                this.resolveImport(resolverImportArray[n2], arrayList);
                if (resolverImportArray[n2].getSelectedSupplier() != null) {
                    bl = true;
                }
            }
            ++n2;
        }
        if (bl) {
            this.state.resolveBundle(resolverBundle.getBundleDescription(), false, null, null, null, null, null, null, null, null);
            this.stateResolveConstraints(resolverBundle);
            this.stateResolveBundle(resolverBundle);
        }
    }

    private void getCurrentEEs(Dictionary<Object, Object>[] dictionaryArray) {
        this.CURRENT_EES = new String[dictionaryArray.length][];
        int n = 0;
        while (n < dictionaryArray.length) {
            String string = (String)dictionaryArray[n].get("org.osgi.framework.executionenvironment");
            this.CURRENT_EES[n] = ManifestElement.getArrayFromList(string, ",");
            ++n;
        }
    }

    private void resolveBundles(ResolverBundle[] resolverBundleArray, Dictionary<Object, Object>[] dictionaryArray, Collection<ResolverBundle> collection) {
        ResolverBundle[] resolverBundleArray2 = resolverBundleArray;
        int n = resolverBundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResolverBundle resolverBundle = resolverBundleArray2[n2];
            this.state.removeResolverErrors(resolverBundle.getBundleDescription());
            resolverBundle.setResolvable(this.isResolvable(resolverBundle, dictionaryArray, collection) || this.developmentMode);
            ++n2;
        }
        this.selectSingletons(resolverBundleArray);
        this.resolveBundles0(resolverBundleArray, dictionaryArray);
        if (DEBUG_WIRING) {
            this.printWirings();
        }
        this.stateResolveBundles(resolverBundleArray);
    }

    private void selectSingletons(ResolverBundle[] resolverBundleArray) {
        if (this.developmentMode) {
            return;
        }
        HashMap hashMap = new HashMap(resolverBundleArray.length);
        ResolverBundle[] resolverBundleArray2 = resolverBundleArray;
        int n = resolverBundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            ArrayList<ResolverBundle> arrayList;
            ResolverBundle resolverBundle = resolverBundleArray2[n2];
            if (resolverBundle.getBundleDescription().isSingleton() && resolverBundle.isResolvable() && (arrayList = (ArrayList<ResolverBundle>)hashMap.get(string = resolverBundle.getName())) == null) {
                arrayList = new ArrayList<ResolverBundle>(1);
                hashMap.put(string, arrayList);
                List<ResolverBundle> list = this.resolverBundles.get(string);
                if (list.size() < 2) {
                    arrayList.add(resolverBundle);
                } else {
                    for (ResolverBundle resolverBundle2 : list) {
                        if (!resolverBundle2.getBundleDescription().isSingleton() || !resolverBundle2.getBundleDescription().isResolved()) continue;
                        arrayList.add(resolverBundle2);
                    }
                    Map<ResolverBundle, Collection<ResolverBundle>> object2 = this.getCollisionMap(list);
                    for (ResolverBundle resolverBundle3 : list) {
                        Collection<ResolverBundle> collection;
                        if (arrayList.contains(resolverBundle3) || (collection = object2.get(resolverBundle3)) == null || !resolverBundle3.isResolvable()) continue;
                        ArrayList<ResolverBundle> arrayList2 = new ArrayList<ResolverBundle>();
                        for (ResolverBundle resolverBundle4 : collection) {
                            if (arrayList.contains(resolverBundle4)) {
                                resolverBundle3.setResolvable(false);
                                this.state.addResolverError(resolverBundle3.getBundleDescription(), 8, resolverBundle4.getBundleDescription().toString(), null);
                                break;
                            }
                            if (arrayList2.contains(resolverBundle4)) continue;
                            arrayList2.add(resolverBundle4);
                        }
                        for (Map.Entry entry : object2.entrySet()) {
                            if (entry.getKey() == resolverBundle3 || !((Collection)entry.getValue()).contains(resolverBundle3)) continue;
                            if (arrayList.contains(entry.getKey())) {
                                resolverBundle3.setResolvable(false);
                                this.state.addResolverError(resolverBundle3.getBundleDescription(), 8, ((ResolverBundle)entry.getKey()).getBundleDescription().toString(), null);
                                break;
                            }
                            if (arrayList2.contains(entry.getKey())) continue;
                            arrayList2.add((ResolverBundle)entry.getKey());
                        }
                        if (!resolverBundle3.isResolvable()) continue;
                        arrayList2.add(resolverBundle3);
                        arrayList.add(this.pickOneToResolve(arrayList2));
                    }
                }
            }
            ++n2;
        }
    }

    private ResolverBundle pickOneToResolve(Collection<ResolverBundle> collection) {
        ResolverBundle resolverBundle = null;
        for (ResolverBundle resolverBundle2 : collection) {
            boolean bl;
            if (resolverBundle == null) {
                resolverBundle = resolverBundle2;
            }
            boolean bl2 = this.selectionPolicy != null ? this.selectionPolicy.compare(resolverBundle.getBundleDescription(), resolverBundle2.getBundleDescription()) > 0 : (bl = resolverBundle.getVersion().compareTo(resolverBundle2.getVersion()) < 0);
            if (!bl) continue;
            resolverBundle = resolverBundle2;
        }
        for (ResolverBundle resolverBundle2 : collection) {
            if (resolverBundle2 == resolverBundle) continue;
            resolverBundle2.setResolvable(false);
            this.state.addResolverError(resolverBundle2.getBundleDescription(), 8, resolverBundle.getBundleDescription().toString(), null);
        }
        return resolverBundle;
    }

    private Map<ResolverBundle, Collection<ResolverBundle>> getCollisionMap(List<ResolverBundle> list) {
        HashMap<ResolverBundle, Collection<ResolverBundle>> hashMap = new HashMap<ResolverBundle, Collection<ResolverBundle>>();
        for (ResolverBundle resolverBundle : list) {
            if (!resolverBundle.getBundleDescription().isSingleton() || !resolverBundle.isResolvable()) continue;
            ArrayList<ResolverBundle> arrayList = new ArrayList<ResolverBundle>(list.size() - 1);
            ArrayList<BundleCapability> arrayList2 = new ArrayList<BundleCapability>(list.size() - 1);
            for (ResolverBundle resolverBundle2 : list) {
                if (resolverBundle2 == resolverBundle || !resolverBundle2.getBundleDescription().isSingleton() || !resolverBundle2.isResolvable()) continue;
                arrayList.add(resolverBundle2);
                arrayList2.add(resolverBundle2.getCapability());
            }
            if (this.hook != null) {
                this.hook.filterSingletonCollisions(resolverBundle.getCapability(), ResolverImpl.asCapabilities(new ArrayMap(arrayList2, arrayList)));
            }
            hashMap.put(resolverBundle, arrayList);
        }
        return hashMap;
    }

    private void resolveBundles0(ResolverBundle[] resolverBundleArray, Dictionary<Object, Object>[] dictionaryArray) {
        if (this.developmentMode) {
            Arrays.sort(resolverBundleArray);
        }
        HashSet<String> hashSet = new HashSet<String>(resolverBundleArray.length);
        int n = 0;
        while (n < resolverBundleArray.length) {
            this.attachFragment(resolverBundleArray[n], hashSet);
            ++n;
        }
        ArrayList<ResolverBundle> arrayList = new ArrayList<ResolverBundle>(1);
        int n2 = 0;
        while (n2 < resolverBundleArray.length) {
            if (DEBUG) {
                ResolverImpl.log(new StringBuffer("** RESOLVING ").append(resolverBundleArray[n2]).append(" **").toString());
            }
            arrayList.clear();
            this.resolveBundle(resolverBundleArray[n2], arrayList);
            this.checkCycle(arrayList);
            ++n2;
        }
        if (this.unresolvedBundles.size() > 0) {
            ResolverBundle[] resolverBundleArray2 = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
            int n3 = 0;
            while (n3 < resolverBundleArray2.length) {
                this.resolveFragment(resolverBundleArray2[n3]);
                ++n3;
            }
        }
        this.checkUsesConstraints(resolverBundleArray, dictionaryArray);
        this.checkComposites(resolverBundleArray, dictionaryArray);
    }

    private void checkComposites(ResolverBundle[] resolverBundleArray, Dictionary<Object, Object>[] dictionaryArray) {
        CompositeResolveHelperRegistry compositeResolveHelperRegistry = this.getCompositeHelpers();
        if (compositeResolveHelperRegistry == null) {
            return;
        }
        HashSet<ResolverBundle> hashSet = null;
        int n = 0;
        while (n < resolverBundleArray.length) {
            CompositeResolveHelper compositeResolveHelper = compositeResolveHelperRegistry.getCompositeResolveHelper(resolverBundleArray[n].getBundleDescription());
            if (compositeResolveHelper != null && resolverBundleArray[n].isResolved() && !compositeResolveHelper.giveExports(ResolverImpl.getExportsWiredTo(resolverBundleArray[n], null))) {
                this.state.addResolverError(resolverBundleArray[n].getBundleDescription(), 262144, null, null);
                resolverBundleArray[n].setResolvable(false);
                this.setBundleUnresolved(resolverBundleArray[n], false, false);
                if (hashSet == null) {
                    hashSet = new HashSet<ResolverBundle>(1);
                }
                hashSet.add(resolverBundleArray[n]);
            }
            ++n;
        }
        this.reResolveBundles(hashSet, resolverBundleArray, dictionaryArray);
    }

    private void checkUsesConstraints(ResolverBundle[] resolverBundleArray, Dictionary<Object, Object>[] dictionaryArray) {
        List<ResolverConstraint> list = this.findBestCombination(resolverBundleArray, dictionaryArray);
        if (list == null) {
            return;
        }
        HashSet<ResolverBundle> hashSet = null;
        for (ResolverConstraint resolverConstraint : list) {
            ResolverBundle resolverBundle;
            if (resolverConstraint.isOptional()) {
                resolverConstraint.clearPossibleSuppliers();
                continue;
            }
            if (hashSet == null) {
                hashSet = new HashSet<ResolverBundle>(list.size());
            }
            if ((resolverBundle = resolverConstraint.isFromFragment() ? this.bundleMapping.get(resolverConstraint.getVersionConstraint().getBundle()) : resolverConstraint.getBundle()) == null) continue;
            if (DEBUG_USES) {
                System.out.println(new StringBuffer("Found conflicting constraint: ").append(resolverConstraint).append(" in bundle ").append(resolverBundle).toString());
            }
            hashSet.add(resolverBundle);
            int n = resolverConstraint instanceof ResolverImport ? 32 : 64;
            this.state.addResolverError(resolverBundle.getBundleDescription(), n, resolverConstraint.getVersionConstraint().toString(), resolverConstraint.getVersionConstraint());
            resolverBundle.setResolvable(false);
            this.setBundleUnresolved(resolverBundle, false, false);
        }
        this.reResolveBundles(hashSet, resolverBundleArray, dictionaryArray);
    }

    private void reResolveBundles(Set<ResolverBundle> set, ResolverBundle[] resolverBundleArray, Dictionary<Object, Object>[] dictionaryArray) {
        if (set == null || set.size() == 0) {
            return;
        }
        ArrayList<ResolverBundle> arrayList = new ArrayList<ResolverBundle>();
        int n = 0;
        while (n < resolverBundleArray.length) {
            if (!set.contains(resolverBundleArray[n])) {
                this.setBundleUnresolved(resolverBundleArray[n], false, false);
                arrayList.add(resolverBundleArray[n]);
            }
            ++n;
        }
        this.resolveBundles0(arrayList.toArray(new ResolverBundle[arrayList.size()]), dictionaryArray);
    }

    private List<ResolverConstraint> findBestCombination(ResolverBundle[] resolverBundleArray, Dictionary<Object, Object>[] dictionaryArray) {
        Object object;
        Object object2 = object = dictionaryArray.length == 0 ? null : dictionaryArray[0].get("osgi.resolver.usesMode");
        if (object == null) {
            object = secureAction.getProperty("osgi.resolver.usesMode");
        }
        if ("ignore".equals(object) || this.developmentMode) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        List<ResolverConstraint> list = this.getConflicts(resolverBundleArray, hashSet, hashSet2);
        if (list == null || "tryFirst".equals(object) || this.usesCalculationTimeout) {
            this.groupingChecker.clear();
            return list;
        }
        ResolverConstraint[][] resolverConstraintArray = this.getMultipleSuppliers(resolverBundleArray, hashSet, hashSet2);
        List<ResolverConstraint> list2 = null;
        int[] nArray = new int[resolverConstraintArray.length];
        list2 = this.findBestCombination(resolverBundleArray, resolverConstraintArray, nArray, list);
        if (DEBUG_USES) {
            System.out.print("Best combination found: ");
            this.printCombination(nArray);
        }
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < resolverConstraintArray[n].length) {
                resolverConstraintArray[n][n2].setSelectedSupplier(nArray[n]);
                ++n2;
            }
            ++n;
        }
        this.groupingChecker.clear();
        return list2;
    }

    private int[] getCombination(ResolverConstraint[][] resolverConstraintArray, int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = resolverConstraintArray[n][0].getSelectedSupplierIndex();
            ++n;
        }
        return nArray;
    }

    private List<ResolverConstraint> findBestCombination(ResolverBundle[] resolverBundleArray, ResolverConstraint[][] resolverConstraintArray, int[] nArray, List<ResolverConstraint> list) {
        long l = System.currentTimeMillis();
        long l2 = this.usesTimeout < 0L ? (long)Math.min(MAX_USES_TIME_BASE + resolverBundleArray.length * 30, MAX_USES_TIME_LIMIT) : (this.usesTimeout == 0L ? Long.MAX_VALUE : this.usesTimeout);
        int n = this.getConflictCount(list);
        ResolverBundle[] resolverBundleArray2 = this.getConflictedBundles(list);
        while (n != 0 && this.getNextCombination(resolverConstraintArray)) {
            List<ResolverConstraint> list2;
            int n2;
            if (System.currentTimeMillis() - l > l2) {
                if (DEBUG_USES) {
                    System.out.println("Uses constraint check has timedout.  Using the best solution found so far.");
                }
                this.usesCalculationTimeout = true;
                break;
            }
            if (DEBUG_USES) {
                this.printCombination(this.getCombination(resolverConstraintArray, new int[resolverConstraintArray.length]));
            }
            if ((n2 = this.getConflictCount(list2 = this.getConflicts(resolverBundleArray2, null, null))) >= n) {
                if (!DEBUG_USES) continue;
                System.out.println(new StringBuffer("Combination is not better that current best: ").append(n2).append(">=").append(n).toString());
                continue;
            }
            list2 = this.getConflicts(resolverBundleArray, null, null);
            n2 = this.getConflictCount(list2);
            if (n2 < n) {
                n = n2;
                list = list2;
                this.getCombination(resolverConstraintArray, nArray);
                resolverBundleArray2 = this.getConflictedBundles(list);
                if (!DEBUG_USES) continue;
                System.out.println(new StringBuffer("Combination selected as current best: number of conflicts: ").append(n).toString());
                continue;
            }
            if (!DEBUG_USES) continue;
            System.out.println(new StringBuffer("Combination is not better that current best: ").append(n2).append(">=").append(n).toString());
        }
        return list;
    }

    private void printCombination(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n = 0;
        while (n < nArray.length) {
            stringBuffer.append(nArray[n]);
            if (n < nArray.length - 1) {
                stringBuffer.append(',');
            }
            ++n;
        }
        stringBuffer.append(']');
        System.out.println(stringBuffer.toString());
    }

    private ResolverBundle[] getConflictedBundles(List<ResolverConstraint> list) {
        if (list == null) {
            return new ResolverBundle[0];
        }
        ArrayList<ResolverBundle> arrayList = new ArrayList<ResolverBundle>(list.size());
        for (ResolverConstraint resolverConstraint : list) {
            if (arrayList.contains(resolverConstraint.getBundle())) continue;
            arrayList.add(resolverConstraint.getBundle());
        }
        return arrayList.toArray(new ResolverBundle[arrayList.size()]);
    }

    private boolean getNextCombination(ResolverConstraint[][] resolverConstraintArray) {
        int n = 0;
        while (n < resolverConstraintArray.length) {
            int n2;
            if (resolverConstraintArray[n][0].selectNextSupplier()) {
                n2 = 1;
                while (n2 < resolverConstraintArray[n].length) {
                    resolverConstraintArray[n][n2].selectNextSupplier();
                    ++n2;
                }
                return true;
            }
            n2 = 0;
            while (n2 < resolverConstraintArray[n].length) {
                resolverConstraintArray[n][n2].setSelectedSupplier(0);
                ++n2;
            }
            ++n;
        }
        return false;
    }

    private int getConflictCount(List<ResolverConstraint> list) {
        if (list == null || list.size() == 0) {
            return 0;
        }
        int n = 0;
        for (ResolverConstraint resolverConstraint : list) {
            if (resolverConstraint.isOptional()) continue;
            ++n;
        }
        return n;
    }

    private List<ResolverConstraint> getConflicts(ResolverBundle[] resolverBundleArray, Set<String> set, Set<String> set2) {
        this.groupingChecker.clear();
        List<ResolverConstraint> list = null;
        int n = 0;
        while (n < resolverBundleArray.length) {
            list = this.addConflicts(resolverBundleArray[n], set, set2, list);
            ++n;
        }
        return list;
    }

    private List<ResolverConstraint> addConflicts(ResolverBundle resolverBundle, Set<String> set, Set<String> set2, List<ResolverConstraint> list) {
        GenericConstraint[] genericConstraintArray;
        Object object;
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        int n = 0;
        while (n < bundleConstraintArray.length) {
            ResolverBundle resolverBundle2 = (ResolverBundle)bundleConstraintArray[n].getSelectedSupplier();
            Object object2 = object = resolverBundle2 == null ? null : this.groupingChecker.isConsistent(resolverBundle, resolverBundle2);
            if (object != null) {
                this.addConflictNames((GroupingChecker.PackageRoots[][])object, set, set2);
                if (list == null) {
                    list = new ArrayList<ResolverConstraint>(1);
                }
                list.add(bundleConstraintArray[n]);
            }
            ++n;
        }
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        int n2 = 0;
        while (n2 < resolverImportArray.length) {
            GroupingChecker.PackageRoots[][] packageRootsArray;
            object = (ResolverExport)resolverImportArray[n2].getSelectedSupplier();
            GroupingChecker.PackageRoots[][] packageRootsArray2 = packageRootsArray = object == null ? null : this.groupingChecker.isConsistent(resolverBundle, (ResolverExport)object);
            if (packageRootsArray != null) {
                this.addConflictNames(packageRootsArray, set, set2);
                if (list == null) {
                    list = new ArrayList<ResolverConstraint>(1);
                }
                list.add(resolverImportArray[n2]);
            }
            ++n2;
        }
        GenericConstraint[] genericConstraintArray2 = genericConstraintArray = resolverBundle.getGenericRequires();
        int n3 = genericConstraintArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object = genericConstraintArray2[n4];
            VersionSupplier[] versionSupplierArray = ((GenericConstraint)object).getMatchingCapabilities();
            if (versionSupplierArray != null) {
                VersionSupplier[] versionSupplierArray2 = versionSupplierArray;
                int n5 = versionSupplierArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    VersionSupplier versionSupplier = versionSupplierArray2[n6];
                    GroupingChecker.PackageRoots[][] packageRootsArray = this.groupingChecker.isConsistent(resolverBundle, (GenericCapability)versionSupplier);
                    if (packageRootsArray != null) {
                        this.addConflictNames(packageRootsArray, set, set2);
                        if (list == null) {
                            list = new ArrayList<ResolverConstraint>(1);
                        }
                        list.add((ResolverConstraint)object);
                    }
                    ++n6;
                }
            }
            ++n4;
        }
        return list;
    }

    private void addConflictNames(GroupingChecker.PackageRoots[][] packageRootsArray, Set<String> set, Set<String> set2) {
        if (set == null || set2 == null) {
            return;
        }
        int n = 0;
        while (n < packageRootsArray.length) {
            ResolverExport[] resolverExportArray;
            set.add(packageRootsArray[n][0].getName());
            set.add(packageRootsArray[n][1].getName());
            ResolverExport[] resolverExportArray2 = packageRootsArray[n][0].getRoots();
            if (resolverExportArray2 != null) {
                int n2 = 0;
                while (n2 < resolverExportArray2.length) {
                    ResolverBundle resolverBundle = resolverExportArray2[n2].getExporter();
                    if (resolverBundle != null && resolverBundle.getName() != null) {
                        set2.add(resolverBundle.getName());
                    }
                    ++n2;
                }
            }
            if ((resolverExportArray = packageRootsArray[n][1].getRoots()) != null) {
                int n3 = 0;
                while (n3 < resolverExportArray.length) {
                    ResolverBundle resolverBundle = resolverExportArray[n3].getExporter();
                    if (resolverBundle != null && resolverBundle.getName() != null) {
                        set2.add(resolverBundle.getName());
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     */
    private ResolverConstraint[][] getMultipleSuppliers(ResolverBundle[] resolverBundleArray, Set<String> set, Set<String> set2) {
        ArrayList<ResolverConstraint[]> arrayList;
        block20: {
            ArrayList<GenericConstraint> arrayList2;
            ArrayList<Object> arrayList3;
            ArrayList<ResolverImport> arrayList4;
            block19: {
                void hashMap;
                arrayList4 = new ArrayList<ResolverImport>(1);
                arrayList3 = new ArrayList<Object>(1);
                arrayList2 = new ArrayList<GenericConstraint>(1);
                Object object422 = resolverBundleArray;
                int n = resolverBundleArray.length;
                boolean n2 = false;
                while (hashMap < n) {
                    Object object;
                    Object object2;
                    Object object3;
                    BundleConstraint[] bundleConstraintArray;
                    arrayList = object422[hashMap];
                    BundleConstraint[] bundleConstraintArray2 = bundleConstraintArray = ((ResolverBundle)((Object)arrayList)).getRequires();
                    int n3 = bundleConstraintArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        object3 = bundleConstraintArray2[n4];
                        if (((ResolverConstraint)object3).getNumPossibleSuppliers() > 1) {
                            arrayList3.add(object3);
                        }
                        ++n4;
                    }
                    object3 = ((ResolverBundle)((Object)arrayList)).getImportPackages();
                    ResolverImport[] resolverImportArray = object3;
                    int n5 = ((ResolverImport[])object3).length;
                    n3 = 0;
                    while (n3 < n5) {
                        ResolverImport resolverImport = resolverImportArray[n3];
                        if (resolverImport.getNumPossibleSuppliers() > 1) {
                            object2 = (Integer)((ResolverExport)resolverImport.getSelectedSupplier()).getExportPackageDescription().getDirective("x-equinox-ee");
                            if ((Integer)object2 < 0) {
                                arrayList4.add(resolverImport);
                            } else {
                                VersionSupplier[] versionSupplierArray = resolverImport.getPossibleSuppliers();
                                int n6 = 1;
                                while (n6 < versionSupplierArray.length) {
                                    Integer n7 = (Integer)((ResolverExport)versionSupplierArray[n6]).getExportPackageDescription().getDirective("x-equinox-ee");
                                    if (n7 < 0 && ((ResolverExport)versionSupplierArray[n6]).getExporter().getRequire(this.getSystemBundle()) == null && ((ResolverExport)versionSupplierArray[n6]).getExporter().getRequire("system.bundle") == null) {
                                        arrayList4.add(resolverImport);
                                        break;
                                    }
                                    ++n6;
                                }
                            }
                        }
                        ++n3;
                    }
                    object2 = object = ((ResolverBundle)((Object)arrayList)).getGenericRequires();
                    int n8 = ((GenericConstraint[])object).length;
                    n5 = 0;
                    while (n5 < n8) {
                        GenericConstraint genericConstraint = object2[n5];
                        if (genericConstraint.getNumPossibleSuppliers() > 1 && genericConstraint.supplierHasUses()) {
                            arrayList2.add(genericConstraint);
                        }
                        ++n5;
                    }
                    ++hashMap;
                }
                arrayList = new ArrayList();
                if (arrayList4.size() + arrayList3.size() + arrayList2.size() <= MAX_MULTIPLE_SUPPLIERS_MERGE) break block19;
                HashMap<String, List<List<ResolverConstraint>>> resolverConstraint = new HashMap<String, List<List<ResolverConstraint>>>();
                for (ResolverImport resolverImport : arrayList4) {
                    this.addMutipleSupplierConstraint(resolverConstraint, resolverImport, resolverImport.getName());
                }
                HashMap<String, List<List<ResolverConstraint>>> hashMap2 = new HashMap<String, List<List<ResolverConstraint>>>();
                for (Object object422 : arrayList3) {
                    this.addMutipleSupplierConstraint(hashMap2, (ResolverConstraint)object422, ((ResolverConstraint)object422).getName());
                }
                object422 = new HashMap();
                for (GenericConstraint genericConstraint : arrayList2) {
                    this.addMutipleSupplierConstraint((Map<String, List<List<ResolverConstraint>>>)object422, genericConstraint, genericConstraint.getNameSpace());
                }
                this.addMergedSuppliers((List<ResolverConstraint[]>)arrayList, resolverConstraint);
                this.addMergedSuppliers((List<ResolverConstraint[]>)arrayList, hashMap2);
                this.addMergedSuppliers((List<ResolverConstraint[]>)arrayList, (Map<String, List<List<ResolverConstraint>>>)object422);
                if (arrayList.size() <= MAX_MULTIPLE_SUPPLIERS_MERGE || set == null || set2 == null) break block20;
                ArrayList<ResolverConstraint[]> arrayList5 = arrayList;
                arrayList = new ArrayList<ResolverConstraint[]>();
                for (Object object3 : arrayList5) {
                    Object object;
                    Object object4 = object = ((Object)object3).length > 0 ? object3[0] : null;
                    if (object instanceof ResolverImport) {
                        if (!set.contains(((ResolverConstraint)object).getName())) continue;
                        arrayList.add((ResolverConstraint[])object3);
                        continue;
                    }
                    if (!(object instanceof BundleConstraint) || !set2.contains(((ResolverConstraint)object).getName())) continue;
                    arrayList.add((ResolverConstraint[])object3);
                }
                break block20;
            }
            for (ResolverConstraint resolverConstraint : arrayList4) {
                arrayList.add(new ResolverConstraint[]{resolverConstraint});
            }
            for (ResolverConstraint resolverConstraint : arrayList3) {
                arrayList.add(new ResolverConstraint[]{resolverConstraint});
            }
            for (ResolverConstraint resolverConstraint : arrayList2) {
                arrayList.add(new ResolverConstraint[]{resolverConstraint});
            }
        }
        return (ResolverConstraint[][])arrayList.toArray((T[])new ResolverConstraint[arrayList.size()][]);
    }

    String getSystemBundle() {
        String string;
        Dictionary[] dictionaryArray = this.state.getPlatformProperties();
        String string2 = string = dictionaryArray.length == 0 ? null : (String)dictionaryArray[0].get("osgi.system.bundle");
        if (string == null) {
            string = Constants.getInternalSymbolicName();
        }
        return string;
    }

    private void addMergedSuppliers(List<ResolverConstraint[]> list, Map<String, List<List<ResolverConstraint>>> map) {
        for (List<List<ResolverConstraint>> list2 : map.values()) {
            for (List<ResolverConstraint> list3 : list2) {
                list.add(list3.toArray(new ResolverConstraint[list3.size()]));
            }
        }
    }

    private void addMutipleSupplierConstraint(Map<String, List<List<ResolverConstraint>>> map, ResolverConstraint resolverConstraint, String string) {
        List<ResolverConstraint> list3;
        List<List<ResolverConstraint>> list2 = map.get(string);
        if (list2 == null) {
            list2 = new ArrayList<List<ResolverConstraint>>(0);
            ArrayList<ResolverConstraint> arrayList = new ArrayList<ResolverConstraint>(1);
            arrayList.add(resolverConstraint);
            list2.add(arrayList);
            map.put(string, list2);
            return;
        }
        for (List<ResolverConstraint> list3 : list2) {
            VersionSupplier[] versionSupplierArray;
            ResolverConstraint resolverConstraint2 = list3.get(0);
            VersionSupplier[] versionSupplierArray2 = resolverConstraint.getPossibleSuppliers();
            if (versionSupplierArray2.length != (versionSupplierArray = resolverConstraint2.getPossibleSuppliers()).length) continue;
            int n = 0;
            while (n < versionSupplierArray2.length) {
                if (versionSupplierArray2[n] != versionSupplierArray[n]) {
                    // empty if block
                }
                ++n;
            }
            list3.add(resolverConstraint);
            return;
        }
        list3 = new ArrayList<ResolverConstraint>(1);
        list3.add(resolverConstraint);
        list2.add(list3);
    }

    /*
     * Unable to fully structure code
     */
    private void checkCycle(List<ResolverBundle> var1_1) {
        var2_2 = var1_1.size();
        if (var2_2 == 0) {
            return;
        }
        var3_3 = var1_1.iterator();
        while (var3_3.hasNext()) {
            block12: {
                var4_7 = var3_3.next();
                if (!var4_7.isResolvable()) {
                    var3_3.remove();
                    continue;
                }
                var5_9 = var4_7.getImportPackages();
                var6_10 = 0;
                break block12;
                while ((var7_11 = (ResolverExport)var5_9[var6_10].getSelectedSupplier()).getSubstitute() != null) {
                    var5_9[var6_10].selectNextSupplier();
lbl16:
                    // 2 sources

                    ** while (var5_9[var6_10].getSelectedSupplier() == null)
lbl17:
                    // 1 sources

                }
lbl18:
                // 2 sources

                if (!var5_9[var6_10].isDynamic() && !var5_9[var6_10].isOptional() && var5_9[var6_10].getSelectedSupplier() == null) {
                    var4_7.setResolvable(false);
                    this.state.addResolverError(var5_9[var6_10].getVersionConstraint().getBundle(), 1, var5_9[var6_10].getVersionConstraint().toString(), var5_9[var6_10].getVersionConstraint());
                    var3_3.remove();
                    continue;
                }
                ++var6_10;
            }
            if (var6_10 < var5_9.length) ** GOTO lbl16
        }
        if (var1_1.size() != var2_2) {
            var3_4 = 0;
            while (var3_4 < var1_1.size()) {
                var4_7 = var1_1.get(var3_4);
                var4_7.clearWires();
                ++var3_4;
            }
            var3_5 = new ArrayList<ResolverBundle>(var1_1.size());
            var4_8 = 0;
            while (var4_8 < var1_1.size()) {
                this.resolveBundle(var1_1.get(var4_8), var3_5);
                ++var4_8;
            }
            this.checkCycle(var3_5);
        } else {
            var3_6 = 0;
            while (var3_6 < var1_1.size()) {
                if (ResolverImpl.DEBUG || ResolverImpl.DEBUG_CYCLES) {
                    ResolverImpl.log(new StringBuffer("Pushing ").append(var1_1.get(var3_6)).append(" to RESOLVED").toString());
                }
                this.setBundleResolved(var1_1.get(var3_6));
                ++var3_6;
            }
        }
    }

    static Collection<BundleCapability> asCapabilities(Collection<? extends BundleCapability> collection) {
        return collection;
    }

    private void resolveFragment(ResolverBundle resolverBundle) {
        if (!resolverBundle.isFragment()) {
            return;
        }
        if (!(resolverBundle.getHost().getNumPossibleSuppliers() <= 0 || this.developmentMode && this.state.getResolverErrors(resolverBundle.getBundleDescription()).length != 0)) {
            this.setBundleResolved(resolverBundle);
        }
    }

    private boolean resolveBundle(ResolverBundle resolverBundle, List<ResolverBundle> list) {
        int n;
        ResolverConstraint[] resolverConstraintArray;
        if (resolverBundle.isFragment()) {
            return false;
        }
        if (!resolverBundle.isResolvable()) {
            if (DEBUG) {
                ResolverImpl.log(new StringBuffer("  - ").append(resolverBundle).append(" is unresolvable").toString());
            }
            return false;
        }
        switch (resolverBundle.getState()) {
            case 2: {
                if (DEBUG) {
                    ResolverImpl.log(new StringBuffer("  - ").append(resolverBundle).append(" already resolved").toString());
                }
                return true;
            }
            case 0: {
                resolverBundle.clearWires();
                this.setBundleResolving(resolverBundle);
                break;
            }
            case 1: {
                if (!list.contains(resolverBundle)) break;
                return true;
            }
        }
        boolean bl = false;
        if (!bl) {
            resolverConstraintArray = resolverBundle.getGenericRequires();
            n = 0;
            while (n < resolverConstraintArray.length) {
                if (!this.resolveGenericReq((GenericConstraint)resolverConstraintArray[n], list)) {
                    if (DEBUG || DEBUG_GENERICS) {
                        ResolverImpl.log(new StringBuffer("** GENERICS ").append(resolverConstraintArray[n].getVersionConstraint().getName()).append("[").append(resolverConstraintArray[n].getBundleDescription()).append("] failed to resolve").toString());
                    }
                    this.state.addResolverError(resolverConstraintArray[n].getVersionConstraint().getBundle(), 32768, resolverConstraintArray[n].getVersionConstraint().toString(), resolverConstraintArray[n].getVersionConstraint());
                    if (resolverConstraintArray[n].isFromFragment()) {
                        if (!this.developmentMode) {
                            resolverBundle.detachFragment(this.bundleMapping.get(resolverConstraintArray[n].getVersionConstraint().getBundle()), null);
                        }
                    } else if (!this.developmentMode) {
                        bl = true;
                        break;
                    }
                }
                ++n;
            }
        }
        if (!bl) {
            resolverConstraintArray = resolverBundle.getRequires();
            n = 0;
            while (n < resolverConstraintArray.length) {
                if (!this.resolveRequire((BundleConstraint)resolverConstraintArray[n], list)) {
                    if (DEBUG || DEBUG_REQUIRES) {
                        ResolverImpl.log(new StringBuffer("** REQUIRE ").append(resolverConstraintArray[n].getVersionConstraint().getName()).append("[").append(resolverConstraintArray[n].getBundleDescription()).append("] failed to resolve").toString());
                    }
                    this.state.addResolverError(resolverConstraintArray[n].getVersionConstraint().getBundle(), 2, resolverConstraintArray[n].getVersionConstraint().toString(), resolverConstraintArray[n].getVersionConstraint());
                    if (resolverConstraintArray[n].isFromFragment()) {
                        if (!this.developmentMode) {
                            resolverBundle.detachFragment(this.bundleMapping.get(resolverConstraintArray[n].getVersionConstraint().getBundle()), resolverConstraintArray[n]);
                        }
                    } else if (!this.developmentMode) {
                        bl = true;
                        break;
                    }
                }
                ++n;
            }
        }
        if (!bl) {
            resolverConstraintArray = resolverBundle.getImportPackages();
            n = 0;
            while (n < resolverConstraintArray.length) {
                if (!((ResolverImport)resolverConstraintArray[n]).isDynamic() && !this.resolveImport((ResolverImport)resolverConstraintArray[n], list)) {
                    if (DEBUG || DEBUG_IMPORTS) {
                        ResolverImpl.log(new StringBuffer("** IMPORT ").append(((ResolverImport)resolverConstraintArray[n]).getName()).append("[").append(resolverConstraintArray[n].getBundleDescription()).append("] failed to resolve").toString());
                    }
                    this.state.addResolverError(resolverConstraintArray[n].getVersionConstraint().getBundle(), 1, resolverConstraintArray[n].getVersionConstraint().toString(), resolverConstraintArray[n].getVersionConstraint());
                    if (resolverConstraintArray[n].isFromFragment()) {
                        if (!this.developmentMode) {
                            resolverBundle.detachFragment(this.bundleMapping.get(resolverConstraintArray[n].getVersionConstraint().getBundle()), resolverConstraintArray[n]);
                        }
                    } else if (!this.developmentMode) {
                        bl = true;
                        break;
                    }
                }
                ++n;
            }
        }
        this.checkFragmentConstraints(resolverBundle);
        if (this.developmentMode && !bl && this.state.getResolverErrors(resolverBundle.getBundleDescription()).length > 0) {
            bl = true;
        }
        if (bl) {
            this.setBundleUnresolved(resolverBundle, false, this.developmentMode);
            if (DEBUG) {
                ResolverImpl.log(new StringBuffer().append(resolverBundle).append(" NOT RESOLVED").toString());
            }
        } else if (!list.contains(resolverBundle)) {
            this.setBundleResolved(resolverBundle);
            if (DEBUG) {
                ResolverImpl.log(new StringBuffer().append(resolverBundle).append(" RESOLVED").toString());
            }
        }
        if (resolverBundle.getState() == 0) {
            resolverBundle.setResolvable(false);
        }
        return resolverBundle.getState() != 0;
    }

    private void checkFragmentConstraints(ResolverBundle resolverBundle) {
        ResolverBundle[] resolverBundleArray = resolverBundle.getFragments();
        int n = 0;
        while (n < resolverBundleArray.length) {
            BundleDescription bundleDescription = resolverBundleArray[n].getBundleDescription();
            if (resolverBundle.constraintsConflict(bundleDescription, bundleDescription.getImportPackages(), bundleDescription.getRequiredBundles(), bundleDescription.getGenericRequires()) && !this.developmentMode) {
                resolverBundle.detachFragment(resolverBundleArray[n], null);
            }
            ++n;
        }
    }

    private boolean resolveGenericReq(GenericConstraint genericConstraint, List<ResolverBundle> list) {
        VersionSupplier versionSupplier;
        if (DEBUG_GENERICS) {
            ResolverImpl.log(new StringBuffer("Trying to resolve: ").append(genericConstraint.getBundle()).append(", ").append(genericConstraint.getVersionConstraint()).toString());
        }
        if ((versionSupplier = genericConstraint.getSelectedSupplier()) != null) {
            if (!list.contains(genericConstraint.getBundle())) {
                list.add(genericConstraint.getBundle());
                if (DEBUG_CYCLES) {
                    ResolverImpl.log(new StringBuffer("generic cycle: ").append(genericConstraint.getBundle()).append(" -> ").append(genericConstraint.getSelectedSupplier()).toString());
                }
            }
            if (DEBUG_GENERICS) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        VersionHashMap<GenericCapability> versionHashMap = this.resolverGenerics.get(genericConstraint.getNameSpace());
        String string = genericConstraint.getName();
        List list2 = versionHashMap == null ? Collections.EMPTY_LIST : (string == null || "*".equals(string) ? versionHashMap.getAllValues() : versionHashMap.get(string));
        ArrayList arrayList = new ArrayList(list2);
        ArrayList<BundleCapability> arrayList2 = new ArrayList<BundleCapability>(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            GenericCapability genericCapability = (GenericCapability)iterator.next();
            if (!genericConstraint.isSatisfiedBy(genericCapability)) {
                iterator.remove();
                continue;
            }
            arrayList2.add(genericCapability.getCapability());
        }
        if (this.hook != null) {
            this.hook.filterMatches(genericConstraint.getRequirement(), ResolverImpl.asCapabilities(new ArrayMap(arrayList2, arrayList)));
        }
        boolean bl = false;
        for (GenericCapability genericCapability : arrayList) {
            if (DEBUG_GENERICS) {
                ResolverImpl.log(new StringBuffer("CHECKING GENERICS: ").append(genericCapability.getBaseDescription()).toString());
            }
            genericConstraint.addPossibleSupplier(genericCapability);
            if (genericConstraint.getBundle() == genericCapability.getResolverBundle()) {
                bl = true;
                continue;
            }
            ResolverBundle resolverBundle = genericCapability.getResolverBundle();
            if (resolverBundle.getState() == 2 || this.resolveBundle(resolverBundle, list) || this.developmentMode) {
                if (resolverBundle.getState() == 1 && !list.contains(resolverBundle)) {
                    list.add(resolverBundle);
                }
            } else {
                genericConstraint.removePossibleSupplier(genericCapability);
                continue;
            }
            if (DEBUG_GENERICS) {
                ResolverImpl.log(new StringBuffer("Found match: ").append(genericCapability.getBaseDescription()).append(". Wiring").toString());
            }
            bl = true;
        }
        return bl ? true : genericConstraint.isOptional();
    }

    private boolean resolveRequire(BundleConstraint bundleConstraint, List<ResolverBundle> list) {
        if (DEBUG_REQUIRES) {
            ResolverImpl.log(new StringBuffer("Trying to resolve: ").append(bundleConstraint.getBundle()).append(", ").append(bundleConstraint.getVersionConstraint()).toString());
        }
        if (bundleConstraint.getSelectedSupplier() != null) {
            if (!list.contains(bundleConstraint.getBundle())) {
                list.add(bundleConstraint.getBundle());
                if (DEBUG_CYCLES) {
                    ResolverImpl.log(new StringBuffer("require-bundle cycle: ").append(bundleConstraint.getBundle()).append(" -> ").append(bundleConstraint.getSelectedSupplier()).toString());
                }
            }
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        List list2 = this.resolverBundles.get(bundleConstraint.getVersionConstraint().getName());
        ArrayList arrayList = new ArrayList(list2);
        ArrayList<BundleCapability> arrayList2 = new ArrayList<BundleCapability>(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ResolverBundle resolverBundle = (ResolverBundle)iterator.next();
            if (!bundleConstraint.isSatisfiedBy(resolverBundle)) {
                iterator.remove();
                continue;
            }
            arrayList2.add(resolverBundle.getCapability());
        }
        if (this.hook != null) {
            this.hook.filterMatches(bundleConstraint.getRequirement(), ResolverImpl.asCapabilities(new ArrayMap(arrayList2, arrayList)));
        }
        boolean bl = false;
        for (ResolverBundle resolverBundle : arrayList) {
            if (DEBUG_REQUIRES) {
                ResolverImpl.log(new StringBuffer("CHECKING: ").append(resolverBundle.getBundleDescription()).toString());
            }
            bundleConstraint.addPossibleSupplier(resolverBundle);
            if (bundleConstraint.getBundle() != resolverBundle && resolverBundle.getState() != 2 && !this.resolveBundle(resolverBundle, list) && !this.developmentMode) {
                bundleConstraint.removePossibleSupplier(resolverBundle);
                continue;
            }
            if (bundleConstraint.getBundle() != resolverBundle && resolverBundle.getState() == 1 && !list.contains(bundleConstraint.getBundle())) {
                list.add(bundleConstraint.getBundle());
                if (DEBUG_CYCLES) {
                    ResolverImpl.log(new StringBuffer("require-bundle cycle: ").append(bundleConstraint.getBundle()).append(" -> ").append(bundleConstraint.getSelectedSupplier()).toString());
                }
            }
            if (DEBUG_REQUIRES) {
                ResolverImpl.log(new StringBuffer("Found match: ").append(resolverBundle.getBundleDescription()).append(". Wiring").toString());
            }
            bl = true;
        }
        return bl || bundleConstraint.isOptional();
    }

    private boolean resolveImport(ResolverImport resolverImport, List<ResolverBundle> list) {
        if (DEBUG_IMPORTS) {
            ResolverImpl.log(new StringBuffer("Trying to resolve: ").append(resolverImport.getBundle()).append(", ").append(resolverImport.getName()).toString());
        }
        if (resolverImport.getSelectedSupplier() != null) {
            if (!list.contains(resolverImport.getBundle())) {
                list.add(resolverImport.getBundle());
                if (DEBUG_CYCLES) {
                    ResolverImpl.log(new StringBuffer("import-package cycle: ").append(resolverImport.getBundle()).append(" -> ").append(resolverImport.getSelectedSupplier()).append(" from ").append(resolverImport.getSelectedSupplier().getBundleDescription()).toString());
                }
            }
            if (DEBUG_IMPORTS) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        boolean bl = false;
        ResolverExport[] resolverExportArray = resolverImport.getBundle().getExports(resolverImport.getName());
        List list2 = this.resolverExports.get(resolverImport.getName());
        ArrayList arrayList = new ArrayList(list2);
        ArrayList<BundleCapability> arrayList2 = new ArrayList<BundleCapability>(arrayList.size());
        Object object2 = arrayList.iterator();
        while (object2.hasNext()) {
            ResolverExport resolverExport = (ResolverExport)object2.next();
            if (!resolverImport.isSatisfiedBy(resolverExport)) {
                object2.remove();
                continue;
            }
            arrayList2.add(resolverExport.getCapability());
        }
        if (this.hook != null) {
            this.hook.filterMatches(resolverImport.getRequirement(), ResolverImpl.asCapabilities(new ArrayMap(arrayList2, arrayList)));
        }
        for (Object object2 : arrayList) {
            if (DEBUG_IMPORTS) {
                ResolverImpl.log(new StringBuffer("CHECKING: ").append(((ResolverExport)object2).getExporter().getBundleDescription()).append(", ").append(((VersionSupplier)object2).getName()).toString());
            }
            int n = ((ResolverExport)object2).getExporter().getState();
            if (resolverImport.isDynamic() && n != 2) continue;
            if (resolverImport.getSelectedSupplier() != null && ((ResolverExport)resolverImport.getSelectedSupplier()).getExporter() == resolverImport.getBundle()) break;
            resolverImport.addPossibleSupplier((VersionSupplier)object2);
            if (resolverImport.getBundle() != ((ResolverExport)object2).getExporter()) {
                int n2 = 0;
                while (n2 < resolverExportArray.length) {
                    if (resolverExportArray[n2].getSubstitute() == null) {
                        resolverExportArray[n2].setSubstitute((VersionSupplier)object2);
                    }
                    ++n2;
                }
                if (n != 2 && !this.resolveBundle(((ResolverExport)object2).getExporter(), list) && !this.developmentMode || ((VersionSupplier)object2).getSubstitute() != null) {
                    resolverImport.removePossibleSupplier((VersionSupplier)object2);
                    if (resolverImport.getSelectedSupplier() != null) continue;
                    n2 = 0;
                    while (n2 < resolverExportArray.length) {
                        if (resolverExportArray[n2].getSubstitute() == object2) {
                            resolverExportArray[n2].setSubstitute(null);
                        }
                        ++n2;
                    }
                    continue;
                }
            } else if (((VersionSupplier)object2).getSubstitute() != null) continue;
            if (resolverImport.getBundle() != ((ResolverExport)object2).getExporter() && ((ResolverExport)object2).getExporter().getState() == 1 && !list.contains(resolverImport.getBundle())) {
                list.add(resolverImport.getBundle());
                if (DEBUG_CYCLES) {
                    ResolverImpl.log(new StringBuffer("import-package cycle: ").append(resolverImport.getBundle()).append(" -> ").append(resolverImport.getSelectedSupplier()).append(" from ").append(resolverImport.getSelectedSupplier().getBundleDescription()).toString());
                }
            }
            if (DEBUG_IMPORTS) {
                ResolverImpl.log(new StringBuffer("Found match: ").append(((ResolverExport)object2).getExporter()).append(". Wiring ").append(resolverImport.getBundle()).append(":").append(resolverImport.getName()).toString());
            }
            bl = true;
        }
        if (bl) {
            return true;
        }
        if (resolverImport.isOptional()) {
            return true;
        }
        return resolverExportArray.length > 0 && resolverExportArray[0].getSubstitute() == null;
    }

    private void setBundleUnresolved(ResolverBundle resolverBundle, boolean bl, boolean bl2) {
        if (resolverBundle.getState() == 0 && !this.developmentMode) {
            return;
        }
        if (bl || !bl2) {
            this.resolverExports.remove((ResolverExport)resolverBundle.getExportPackages());
            this.removeGenerics(resolverBundle.getGenericCapabilities());
            resolverBundle.detachAllFragments();
            resolverBundle.initialize(false);
            if (!bl) {
                this.resolverExports.put(resolverBundle.getExportPackages());
                this.addGenerics(resolverBundle.getGenericCapabilities());
            }
        }
        if (!(bl || this.developmentMode && this.unresolvedBundles.contains(resolverBundle))) {
            this.unresolvedBundles.add(resolverBundle);
        }
        resolverBundle.setState(0);
    }

    private void setBundleResolved(ResolverBundle resolverBundle) {
        if (resolverBundle.getState() == 2) {
            return;
        }
        this.unresolvedBundles.remove(resolverBundle);
        resolverBundle.setState(2);
    }

    private void setBundleResolving(ResolverBundle resolverBundle) {
        if (resolverBundle.getState() == 1) {
            return;
        }
        this.unresolvedBundles.remove(resolverBundle);
        resolverBundle.setState(1);
    }

    private void stateResolveBundles(ResolverBundle[] resolverBundleArray) {
        int n = 0;
        while (n < resolverBundleArray.length) {
            if (!resolverBundleArray[n].getBundleDescription().isResolved()) {
                this.stateResolveBundle(resolverBundleArray[n]);
            }
            ++n;
        }
    }

    private void stateResolveConstraints(ResolverBundle resolverBundle) {
        VersionSupplier[] versionSupplierArray;
        Object object;
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        int n = 0;
        while (n < resolverImportArray.length) {
            ResolverExport resolverExport = (ResolverExport)resolverImportArray[n].getSelectedSupplier();
            object = resolverExport == null ? null : resolverExport.getExportPackageDescription();
            this.state.resolveConstraint(resolverImportArray[n].getVersionConstraint(), (BaseDescription)object);
            ++n;
        }
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        int n2 = 0;
        while (n2 < bundleConstraintArray.length) {
            object = (ResolverBundle)bundleConstraintArray[n2].getSelectedSupplier();
            versionSupplierArray = object == null ? null : ((ResolverBundle)object).getBundleDescription();
            this.state.resolveConstraint(bundleConstraintArray[n2].getVersionConstraint(), (BaseDescription)versionSupplierArray);
            ++n2;
        }
        GenericConstraint[] genericConstraintArray = resolverBundle.getGenericRequires();
        int n3 = 0;
        while (n3 < genericConstraintArray.length) {
            versionSupplierArray = genericConstraintArray[n3].getMatchingCapabilities();
            if (versionSupplierArray == null) {
                this.state.resolveConstraint(genericConstraintArray[n3].getVersionConstraint(), null);
            } else {
                int n4 = 0;
                while (n4 < versionSupplierArray.length) {
                    this.state.resolveConstraint(genericConstraintArray[n3].getVersionConstraint(), versionSupplierArray[n4].getBaseDescription());
                    ++n4;
                }
            }
            ++n3;
        }
    }

    private void stateResolveFragConstraints(ResolverBundle resolverBundle) {
        Object object;
        ResolverExport resolverExport;
        ResolverBundle resolverBundle2 = (ResolverBundle)resolverBundle.getHost().getSelectedSupplier();
        ImportPackageSpecification[] importPackageSpecificationArray = resolverBundle.getBundleDescription().getImportPackages();
        int n = 0;
        while (n < importPackageSpecificationArray.length) {
            ResolverImport resolverImport = resolverBundle2 == null ? null : resolverBundle2.getImport(importPackageSpecificationArray[n].getName());
            resolverExport = (ResolverExport)(resolverImport == null ? null : resolverImport.getSelectedSupplier());
            object = resolverExport == null ? null : resolverExport.getExportPackageDescription();
            this.state.resolveConstraint(importPackageSpecificationArray[n], (BaseDescription)object);
            ++n;
        }
        BundleSpecification[] bundleSpecificationArray = resolverBundle.getBundleDescription().getRequiredBundles();
        int n2 = 0;
        while (n2 < bundleSpecificationArray.length) {
            resolverExport = resolverBundle2 == null ? null : resolverBundle2.getRequire(bundleSpecificationArray[n2].getName());
            object = (ResolverBundle)(resolverExport == null ? null : ((ResolverConstraint)((Object)resolverExport)).getSelectedSupplier());
            BundleDescription bundleDescription = object == null ? null : ((ResolverBundle)object).getBundleDescription();
            this.state.resolveConstraint(bundleSpecificationArray[n2], bundleDescription);
            ++n2;
        }
    }

    private void stateResolveBundle(ResolverBundle resolverBundle) {
        VersionSupplier[] versionSupplierArray;
        Object object;
        VersionSupplier[] versionSupplierArray2;
        GenericDescription[] genericDescriptionArray;
        Object object2;
        GenericCapability[] genericCapabilityArray;
        if (!resolverBundle.isResolved() && !this.developmentMode) {
            return;
        }
        if (resolverBundle.isFragment()) {
            this.stateResolveFragConstraints(resolverBundle);
        } else {
            this.stateResolveConstraints(resolverBundle);
        }
        HashMap<String, List<StateWire>> hashMap = new HashMap<String, List<StateWire>>();
        ResolverExport[] resolverExportArray = resolverBundle.getSelectedExports();
        ArrayList<ExportPackageDescription> arrayList = new ArrayList<ExportPackageDescription>(resolverExportArray.length);
        int n = 0;
        while (n < resolverExportArray.length) {
            if (this.permissionChecker.checkPackagePermission(resolverExportArray[n].getExportPackageDescription())) {
                arrayList.add(resolverExportArray[n].getExportPackageDescription());
            }
            ++n;
        }
        ExportPackageDescription[] exportPackageDescriptionArray = arrayList.toArray(new ExportPackageDescription[arrayList.size()]);
        ResolverExport[] resolverExportArray2 = resolverBundle.getSubstitutedExports();
        ArrayList<ExportPackageDescription> arrayList2 = new ArrayList<ExportPackageDescription>(resolverExportArray2.length);
        int n2 = 0;
        while (n2 < resolverExportArray2.length) {
            arrayList2.add(resolverExportArray2[n2].getExportPackageDescription());
            ++n2;
        }
        ExportPackageDescription[] exportPackageDescriptionArray2 = arrayList2.toArray(new ExportPackageDescription[arrayList2.size()]);
        ExportPackageDescription[] exportPackageDescriptionArray3 = ResolverImpl.getExportsWiredTo(resolverBundle, hashMap);
        BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
        ArrayList<GenericCapability[]> arrayList3 = new ArrayList<GenericCapability[]>(bundleConstraintArray.length);
        ArrayList<Object> arrayList4 = new ArrayList<Object>(bundleConstraintArray.length);
        int n3 = 0;
        while (n3 < bundleConstraintArray.length) {
            if (bundleConstraintArray[n3].getSelectedSupplier() != null) {
                genericCapabilityArray = (GenericCapability[])bundleConstraintArray[n3].getSelectedSupplier().getBaseDescription();
                arrayList3.add(genericCapabilityArray);
                object2 = ResolverImpl.newStateWire(resolverBundle.getBundleDescription(), bundleConstraintArray[n3].getVersionConstraint(), (BundleDescription)genericCapabilityArray, (BaseDescription)genericCapabilityArray);
                arrayList4.add(object2);
            }
            ++n3;
        }
        BundleDescription[] bundleDescriptionArray = arrayList3.toArray(new BundleDescription[arrayList3.size()]);
        if (!arrayList4.isEmpty()) {
            hashMap.put("osgi.wiring.bundle", arrayList4);
        }
        genericCapabilityArray = resolverBundle.getGenericCapabilities();
        object2 = new ArrayList(genericCapabilityArray.length);
        Object object3 = genericCapabilityArray;
        int n4 = genericCapabilityArray.length;
        int n5 = 0;
        while (n5 < n4) {
            genericDescriptionArray = object3[n5];
            if (this.permissionChecker.checkCapabilityPermission(genericDescriptionArray.getGenericDescription())) {
                object2.add(genericDescriptionArray.getGenericDescription());
            }
            ++n5;
        }
        genericDescriptionArray = object2.toArray(new GenericDescription[object2.size()]);
        GenericConstraint[] genericConstraintArray = resolverBundle.getGenericRequires();
        ArrayList<GenericDescription> arrayList5 = new ArrayList<GenericDescription>(genericConstraintArray.length);
        Object object4 = genericConstraintArray;
        int n6 = genericConstraintArray.length;
        int n7 = 0;
        while (n7 < n6) {
            object3 = object4[n7];
            VersionSupplier[] versionSupplierArray3 = ((GenericConstraint)object3).getMatchingCapabilities();
            if (versionSupplierArray3 != null) {
                versionSupplierArray2 = versionSupplierArray3;
                int n8 = versionSupplierArray3.length;
                int n9 = 0;
                while (n9 < n8) {
                    object = versionSupplierArray2[n9];
                    GenericDescription genericDescription = ((GenericCapability)object).getGenericDescription();
                    arrayList5.add(genericDescription);
                    StateWire stateWire = ResolverImpl.newStateWire(resolverBundle.getBundleDescription(), ((ResolverConstraint)object3).getVersionConstraint(), genericDescription.getSupplier(), genericDescription);
                    ArrayList<StateWire> arrayList6 = (ArrayList<StateWire>)hashMap.get(((GenericConstraint)object3).getNameSpace());
                    if (arrayList6 == null) {
                        arrayList6 = new ArrayList<StateWire>();
                        hashMap.put(((GenericConstraint)object3).getNameSpace(), arrayList6);
                    }
                    arrayList6.add(stateWire);
                    ++n9;
                }
            }
            ++n7;
        }
        object3 = arrayList5.toArray(new GenericDescription[arrayList5.size()]);
        BundleDescription[] bundleDescriptionArray2 = null;
        if (resolverBundle.isFragment() && (versionSupplierArray = resolverBundle.getHost().getPossibleSuppliers()) != null && versionSupplierArray.length > 0) {
            bundleDescriptionArray2 = new BundleDescription[versionSupplierArray.length];
            object4 = new ArrayList(versionSupplierArray.length);
            hashMap.put("osgi.wiring.host", (List<StateWire>)object4);
            int n10 = 0;
            while (n10 < versionSupplierArray.length) {
                bundleDescriptionArray2[n10] = versionSupplierArray[n10].getBundleDescription();
                object = ResolverImpl.newStateWire(resolverBundle.getBundleDescription(), resolverBundle.getHost().getVersionConstraint(), bundleDescriptionArray2[n10], bundleDescriptionArray2[n10]);
                object4.add(object);
                if (bundleDescriptionArray2[n10].isResolved()) {
                    ExportPackageDescription[] exportPackageDescriptionArray4 = null;
                    GenericDescription[] genericDescriptionArray2 = null;
                    if (resolverBundle.isNewFragmentExports()) {
                        versionSupplierArray2 = ((ResolverBundle)versionSupplierArray[n10]).getSelectedExports();
                        exportPackageDescriptionArray4 = new ExportPackageDescription[versionSupplierArray2.length];
                        int n11 = 0;
                        while (n11 < versionSupplierArray2.length) {
                            exportPackageDescriptionArray4[n11] = ((ResolverExport)versionSupplierArray2[n11]).getExportPackageDescription();
                            ++n11;
                        }
                    }
                    if (resolverBundle.isNewFragmentCapabilities()) {
                        versionSupplierArray2 = ((ResolverBundle)versionSupplierArray[n10]).getGenericCapabilities();
                        genericDescriptionArray2 = new GenericDescription[versionSupplierArray2.length];
                        int n12 = 0;
                        while (n12 < versionSupplierArray2.length) {
                            genericDescriptionArray2[n12] = ((GenericCapability)versionSupplierArray2[n12]).getGenericDescription();
                            ++n12;
                        }
                    }
                    if (genericDescriptionArray2 != null || exportPackageDescriptionArray4 != null) {
                        if (genericDescriptionArray2 == null) {
                            genericDescriptionArray2 = bundleDescriptionArray2[n10].getSelectedGenericCapabilities();
                        }
                        if (exportPackageDescriptionArray4 == null) {
                            exportPackageDescriptionArray4 = bundleDescriptionArray2[n10].getSelectedExports();
                        }
                        this.state.resolveBundle(bundleDescriptionArray2[n10], true, null, exportPackageDescriptionArray4, bundleDescriptionArray2[n10].getSubstitutedExports(), genericDescriptionArray2, bundleDescriptionArray2[n10].getResolvedRequires(), bundleDescriptionArray2[n10].getResolvedImports(), bundleDescriptionArray2[n10].getResolvedGenericRequires(), ((BundleDescriptionImpl)bundleDescriptionArray2[n10]).getWires());
                    }
                }
                ++n10;
            }
        }
        this.state.resolveBundle(resolverBundle.getBundleDescription(), resolverBundle.isResolved(), bundleDescriptionArray2, exportPackageDescriptionArray, exportPackageDescriptionArray2, genericDescriptionArray, bundleDescriptionArray, exportPackageDescriptionArray3, (GenericDescription[])object3, hashMap);
    }

    private static ExportPackageDescription[] getExportsWiredTo(ResolverBundle resolverBundle, Map<String, List<StateWire>> map) {
        ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
        ArrayList<ExportPackageDescription> arrayList = new ArrayList<ExportPackageDescription>(resolverImportArray.length);
        ArrayList<StateWire> arrayList2 = new ArrayList<StateWire>(resolverImportArray.length);
        int n = 0;
        while (n < resolverImportArray.length) {
            if (resolverImportArray[n].getSelectedSupplier() != null) {
                ExportPackageDescription exportPackageDescription = (ExportPackageDescription)resolverImportArray[n].getSelectedSupplier().getBaseDescription();
                arrayList.add(exportPackageDescription);
                StateWire stateWire = ResolverImpl.newStateWire(resolverBundle.getBundleDescription(), resolverImportArray[n].getVersionConstraint(), exportPackageDescription.getExporter(), exportPackageDescription);
                arrayList2.add(stateWire);
            }
            ++n;
        }
        if (map != null && !arrayList2.isEmpty()) {
            map.put("osgi.wiring.package", arrayList2);
        }
        return arrayList.toArray(new ExportPackageDescription[arrayList.size()]);
    }

    private static StateWire newStateWire(BundleDescription bundleDescription, VersionConstraint versionConstraint, BundleDescription bundleDescription2, BaseDescription baseDescription) {
        BaseDescription baseDescription2 = ((BaseDescriptionImpl)baseDescription).getFragmentDeclaration();
        baseDescription = baseDescription2 != null ? baseDescription2 : baseDescription;
        return new StateWire(bundleDescription, versionConstraint, bundleDescription2, baseDescription);
    }

    @Override
    public synchronized ExportPackageDescription resolveDynamicImport(BundleDescription bundleDescription, String string) {
        if (this.state == null) {
            throw new IllegalStateException("RESOLVER_NO_STATE");
        }
        if (!this.initialized) {
            this.initialize();
        }
        this.hook = this.state instanceof StateImpl ? ((StateImpl)this.state).getResolverHook() : null;
        try {
            ImportPackageSpecification[] importPackageSpecificationArray;
            Object object;
            ResolverBundle resolverBundle = this.bundleMapping.get(bundleDescription);
            if (resolverBundle.getExport(string) != null) {
                return null;
            }
            ResolverImport[] resolverImportArray = resolverBundle.getImportPackages();
            int n = 0;
            while (n < resolverImportArray.length) {
                if (resolverImportArray[n].isDynamic() && (object = this.resolveDynamicImport(resolverImportArray[n], string)) != null) {
                    ExportPackageDescription exportPackageDescription = object;
                    return exportPackageDescription;
                }
                ++n;
            }
            ImportPackageSpecification[] importPackageSpecificationArray2 = importPackageSpecificationArray = bundleDescription.getAddedDynamicImportPackages();
            int n2 = importPackageSpecificationArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object = importPackageSpecificationArray2[n3];
                ResolverImport resolverImport = new ResolverImport(resolverBundle, (ImportPackageSpecification)object);
                ExportPackageDescription exportPackageDescription = this.resolveDynamicImport(resolverImport, string);
                if (exportPackageDescription != null) {
                    ExportPackageDescription exportPackageDescription2 = exportPackageDescription;
                    return exportPackageDescription2;
                }
                ++n3;
            }
            if (DEBUG || DEBUG_IMPORTS) {
                ResolverImpl.log(new StringBuffer("Failed to resolve dynamic import: ").append(string).toString());
            }
            return null;
        }
        finally {
            this.hook = null;
        }
    }

    private void addStateWire(BundleDescription bundleDescription, VersionConstraint versionConstraint, BundleDescription bundleDescription2, ExportPackageDescription exportPackageDescription) {
        Map<String, List<StateWire>> map = ((BundleDescriptionImpl)bundleDescription).getWires();
        List<StateWire> list = map.get("osgi.wiring.package");
        if (list == null) {
            list = new ArrayList<StateWire>();
            map.put("osgi.wiring.package", list);
        }
        list.add(ResolverImpl.newStateWire(bundleDescription, versionConstraint, bundleDescription2, exportPackageDescription));
    }

    private ExportPackageDescription resolveDynamicImport(ResolverImport resolverImport, String string) {
        String string2 = resolverImport.getName();
        if (string2.equals("*") || string2.endsWith(".*") && string.startsWith(string2.substring(0, string2.length() - 1))) {
            resolverImport.setName(string);
        }
        try {
            if (!string.equals(resolverImport.getName())) {
                return null;
            }
            if (this.resolveImport(resolverImport, new ArrayList<ResolverBundle>())) {
                this.groupingChecker.populateRoots(resolverImport.getBundle());
                while (resolverImport.getSelectedSupplier() != null) {
                    if (this.groupingChecker.isDynamicConsistent(resolverImport.getBundle(), (ResolverExport)resolverImport.getSelectedSupplier()) != null) {
                        resolverImport.selectNextSupplier();
                        continue;
                    }
                    if (DEBUG_IMPORTS) {
                        ResolverImpl.log(new StringBuffer("Resolved dynamic import: ").append(resolverImport.getBundle()).append(":").append(resolverImport.getName()).append(" -> ").append(((ResolverExport)resolverImport.getSelectedSupplier()).getExporter()).append(":").append(string).toString());
                    }
                    ResolverExport resolverExport = (ResolverExport)resolverImport.getSelectedSupplier();
                    this.groupingChecker.populateRoots(resolverImport.getBundle(), resolverExport);
                    ExportPackageDescription exportPackageDescription = resolverExport.getExportPackageDescription();
                    if (exportPackageDescription != null) {
                        this.addStateWire(resolverImport.getBundleDescription(), resolverImport.getVersionConstraint(), exportPackageDescription.getExporter(), exportPackageDescription);
                    }
                    ExportPackageDescription exportPackageDescription2 = exportPackageDescription;
                    return exportPackageDescription2;
                }
                resolverImport.clearPossibleSuppliers();
            }
        }
        finally {
            if (string2.endsWith("*")) {
                resolverImport.clearPossibleSuppliers();
            }
            resolverImport.setName(null);
        }
        return null;
    }

    @Override
    public void bundleAdded(BundleDescription bundleDescription) {
        if (!this.initialized) {
            return;
        }
        if (this.bundleMapping.get(bundleDescription) != null) {
            return;
        }
        ResolverBundle resolverBundle = new ResolverBundle(bundleDescription, this);
        this.bundleMapping.put(bundleDescription, resolverBundle);
        this.unresolvedBundles.add(resolverBundle);
        this.resolverExports.put(resolverBundle.getExportPackages());
        this.resolverBundles.put(resolverBundle.getName(), resolverBundle);
        this.addGenerics(resolverBundle.getGenericCapabilities());
    }

    @Override
    public void bundleRemoved(BundleDescription bundleDescription, boolean bl) {
        ResolverBundle resolverBundle;
        ResolverBundle resolverBundle2 = resolverBundle = this.initialized ? this.bundleMapping.get(bundleDescription) : null;
        if (resolverBundle != null) {
            resolverBundle.setUninstalled();
        }
        this.internalBundleRemoved(bundleDescription, bl);
    }

    private void internalBundleRemoved(BundleDescription bundleDescription, boolean bl) {
        if (bl) {
            this.removalPending.put(new Long(bundleDescription.getBundleId()), bundleDescription);
        }
        if (!this.initialized) {
            return;
        }
        ResolverBundle resolverBundle = this.bundleMapping.get(bundleDescription);
        if (resolverBundle == null) {
            return;
        }
        if (!bl) {
            this.bundleMapping.remove(bundleDescription);
            this.groupingChecker.clear(resolverBundle);
        }
        if (!bl || !bundleDescription.isResolved()) {
            this.resolverExports.remove((ResolverExport)resolverBundle.getExportPackages());
            this.resolverBundles.remove(resolverBundle);
            this.removeGenerics(resolverBundle.getGenericCapabilities());
        }
        this.unresolvedBundles.remove(resolverBundle);
    }

    private void unresolveBundle(ResolverBundle resolverBundle, boolean bl) {
        Object object;
        if (resolverBundle == null) {
            return;
        }
        List<BundleDescription> list = this.removalPending.remove(new Long(resolverBundle.getBundleDescription().getBundleId()));
        BundleDescription[] bundleDescriptionArray = list.iterator();
        while (bundleDescriptionArray.hasNext()) {
            object = bundleDescriptionArray.next();
            ResolverBundle resolverBundle2 = this.bundleMapping.get(object);
            this.unresolveBundle(resolverBundle2, true);
            this.state.removeBundleComplete((BundleDescription)object);
            this.resolverExports.remove((ResolverExport)resolverBundle2.getExportPackages());
            this.resolverBundles.remove(resolverBundle2);
            this.removeGenerics(resolverBundle2.getGenericCapabilities());
            this.bundleMapping.remove(object);
            this.groupingChecker.clear(resolverBundle2);
            if (object != resolverBundle.getBundleDescription()) continue;
            bl = true;
        }
        if (!resolverBundle.getBundleDescription().isResolved() && !this.developmentMode) {
            return;
        }
        object = this.compositeHelpers;
        if (object != null && (bundleDescriptionArray = object.getCompositeResolveHelper(resolverBundle.getBundleDescription())) != null) {
            bundleDescriptionArray.giveExports(null);
        }
        this.setBundleUnresolved(resolverBundle, bl, false);
        bundleDescriptionArray = resolverBundle.getBundleDescription().getDependents();
        this.state.resolveBundle(resolverBundle.getBundleDescription(), false, null, null, null, null, null, null, null, null);
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            this.unresolveBundle(this.bundleMapping.get(bundleDescriptionArray[n]), false);
            ++n;
        }
    }

    @Override
    public void bundleUpdated(BundleDescription bundleDescription, BundleDescription bundleDescription2, boolean bl) {
        this.internalBundleRemoved(bundleDescription2, bl);
        this.bundleAdded(bundleDescription);
    }

    @Override
    public void flush() {
        this.resolverExports = null;
        this.resolverBundles = null;
        this.resolverGenerics = null;
        this.unresolvedBundles = null;
        this.bundleMapping = null;
        List<BundleDescription> list = this.removalPending.getAllValues();
        for (BundleDescription bundleDescription : list) {
            this.state.removeBundleComplete(bundleDescription);
        }
        this.removalPending.clear();
        this.initialized = false;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public void setState(State state) {
        if (this.state != null) {
            throw new IllegalStateException("Cannot change the State of a Resolver");
        }
        this.state = state;
        this.flush();
    }

    private void setDebugOptions() {
        FrameworkDebugOptions frameworkDebugOptions = FrameworkDebugOptions.getDefault();
        if (frameworkDebugOptions == null) {
            return;
        }
        DEBUG = frameworkDebugOptions.getBooleanOption(OPTION_DEBUG, false);
        DEBUG_WIRING = frameworkDebugOptions.getBooleanOption(OPTION_WIRING, false);
        DEBUG_IMPORTS = frameworkDebugOptions.getBooleanOption(OPTION_IMPORTS, false);
        DEBUG_REQUIRES = frameworkDebugOptions.getBooleanOption(OPTION_REQUIRES, false);
        DEBUG_GENERICS = frameworkDebugOptions.getBooleanOption(OPTION_GENERICS, false);
        DEBUG_USES = frameworkDebugOptions.getBooleanOption(OPTION_USES, false);
        DEBUG_CYCLES = frameworkDebugOptions.getBooleanOption(OPTION_CYCLES, false);
    }

    private void printWirings() {
        ResolverImpl.log("****** Result Wirings ******");
        List list = this.resolverBundles.getAllValues();
        for (ResolverBundle resolverBundle : list) {
            int n;
            Object[] objectArray;
            if (resolverBundle.getBundleDescription().isResolved()) continue;
            ResolverImpl.log(new StringBuffer("    * WIRING for ").append(resolverBundle).toString());
            BundleConstraint[] bundleConstraintArray = resolverBundle.getRequires();
            if (bundleConstraintArray.length == 0) {
                ResolverImpl.log("        (r) no requires");
            } else {
                int n2 = 0;
                while (n2 < bundleConstraintArray.length) {
                    if (bundleConstraintArray[n2].getSelectedSupplier() == null) {
                        ResolverImpl.log(new StringBuffer("        (r) ").append(resolverBundle.getBundleDescription()).append(" -> NULL!!!").toString());
                    } else {
                        ResolverImpl.log(new StringBuffer("        (r) ").append(resolverBundle.getBundleDescription()).append(" -> ").append(bundleConstraintArray[n2].getSelectedSupplier()).toString());
                    }
                    ++n2;
                }
            }
            BundleConstraint bundleConstraint = resolverBundle.getHost();
            if (bundleConstraint != null && (objectArray = bundleConstraint.getPossibleSuppliers()) != null) {
                n = 0;
                while (n < objectArray.length) {
                    ResolverImpl.log(new StringBuffer("        (h) ").append(resolverBundle.getBundleDescription()).append(" -> ").append(((VersionSupplier)objectArray[n]).getBundleDescription()).toString());
                    ++n;
                }
            }
            if ((objectArray = resolverBundle.getImportPackages()).length == 0) {
                ResolverImpl.log("        (w) no imports");
                continue;
            }
            n = 0;
            while (n < objectArray.length) {
                if (((ResolverImport)objectArray[n]).isDynamic() && ((ResolverConstraint)objectArray[n]).getSelectedSupplier() == null) {
                    ResolverImpl.log(new StringBuffer("        (w) ").append(((ResolverConstraint)objectArray[n]).getBundle()).append(":").append(((ResolverImport)objectArray[n]).getName()).append(" -> DYNAMIC").toString());
                } else if (((ResolverImport)objectArray[n]).isOptional() && ((ResolverConstraint)objectArray[n]).getSelectedSupplier() == null) {
                    ResolverImpl.log(new StringBuffer("        (w) ").append(((ResolverConstraint)objectArray[n]).getBundle()).append(":").append(((ResolverImport)objectArray[n]).getName()).append(" -> OPTIONAL (could not be wired)").toString());
                } else if (((ResolverConstraint)objectArray[n]).getSelectedSupplier() == null) {
                    ResolverImpl.log(new StringBuffer("        (w) ").append(((ResolverConstraint)objectArray[n]).getBundle()).append(":").append(((ResolverImport)objectArray[n]).getName()).append(" -> NULL!!!").toString());
                } else {
                    ResolverImpl.log(new StringBuffer("        (w) ").append(((ResolverConstraint)objectArray[n]).getBundle()).append(":").append(((ResolverImport)objectArray[n]).getName()).append(" -> ").append(((ResolverExport)((ResolverConstraint)objectArray[n]).getSelectedSupplier()).getExporter()).append(":").append(((ResolverConstraint)objectArray[n]).getSelectedSupplier().getName()).toString());
                }
                ++n;
            }
        }
    }

    static void log(String string) {
        Debug.println(string);
    }

    VersionHashMap<ResolverExport> getResolverExports() {
        return this.resolverExports;
    }

    @Override
    public void setSelectionPolicy(Comparator<BaseDescription> comparator) {
        this.selectionPolicy = comparator;
    }

    @Override
    public Comparator<BaseDescription> getSelectionPolicy() {
        return this.selectionPolicy;
    }

    public void setCompositeResolveHelperRegistry(CompositeResolveHelperRegistry compositeResolveHelperRegistry) {
        this.compositeHelpers = compositeResolveHelperRegistry;
    }

    CompositeResolveHelperRegistry getCompositeHelpers() {
        return this.compositeHelpers;
    }

    private void reorderGenerics() {
        for (VersionHashMap<GenericCapability> versionHashMap : this.resolverGenerics.values()) {
            versionHashMap.reorder();
        }
    }

    void removeGenerics(GenericCapability[] genericCapabilityArray) {
        GenericCapability[] genericCapabilityArray2 = genericCapabilityArray;
        int n = genericCapabilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericCapability genericCapability = genericCapabilityArray2[n2];
            VersionHashMap<GenericCapability> versionHashMap = this.resolverGenerics.get(genericCapability.getGenericDescription().getType());
            if (versionHashMap != null) {
                versionHashMap.remove(genericCapability);
            }
            ++n2;
        }
    }

    void addGenerics(GenericCapability[] genericCapabilityArray) {
        GenericCapability[] genericCapabilityArray2 = genericCapabilityArray;
        int n = genericCapabilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            GenericCapability genericCapability = genericCapabilityArray2[n2];
            String string = genericCapability.getGenericDescription().getType();
            VersionHashMap<GenericCapability> versionHashMap = this.resolverGenerics.get(string);
            if (versionHashMap == null) {
                versionHashMap = new VersionHashMap(this);
                this.resolverGenerics.put(string, versionHashMap);
            }
            versionHashMap.put(genericCapability.getName(), genericCapability);
            ++n2;
        }
    }
}

