/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.GenericCapability;
import org.eclipse.osgi.internal.module.GenericConstraint;
import org.eclipse.osgi.internal.module.ResolverConstraint;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericDescriptionImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionConstraint;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverBundle
extends VersionSupplier
implements Comparable<ResolverBundle> {
    public static final int UNRESOLVED = 0;
    public static final int RESOLVING = 1;
    public static final int RESOLVED = 2;
    private final Long bundleID;
    private BundleConstraint host;
    private ResolverImport[] imports;
    private ResolverExport[] exports;
    private BundleConstraint[] requires;
    private GenericCapability[] genericCapabilities;
    private GenericConstraint[] genericReqiures;
    private ArrayList<ResolverBundle> fragments;
    private HashMap<Long, List<ResolverExport>> fragmentExports;
    private HashMap<Long, List<ResolverImport>> fragmentImports;
    private HashMap<Long, List<BundleConstraint>> fragmentRequires;
    private HashMap<Long, List<GenericCapability>> fragmentGenericCapabilities;
    private HashMap<Long, List<GenericConstraint>> fragmentGenericRequires;
    private boolean resolvable = true;
    private int state = 0;
    private boolean uninstalled = false;
    private final ResolverImpl resolver;
    private boolean newFragmentExports;
    private boolean newFragmentCapabilities;

    ResolverBundle(BundleDescription bundleDescription, ResolverImpl resolverImpl) {
        super(bundleDescription);
        this.bundleID = new Long(bundleDescription.getBundleId());
        this.resolver = resolverImpl;
        this.initialize(bundleDescription.isResolved());
    }

    void initialize(boolean bl) {
        if (this.getBundleDescription().getHost() != null) {
            this.host = new BundleConstraint(this, this.getBundleDescription().getHost());
            this.exports = new ResolverExport[0];
            this.imports = new ResolverImport[0];
            this.requires = new BundleConstraint[0];
            this.genericReqiures = new GenericConstraint[0];
            this.genericCapabilities = new GenericCapability[0];
            return;
        }
        ImportPackageSpecification[] importPackageSpecificationArray = this.getBundleDescription().getImportPackages();
        ArrayList<ResolverImport> arrayList = new ArrayList<ResolverImport>(importPackageSpecificationArray.length);
        int n = importPackageSpecificationArray.length - 1;
        while (n >= 0) {
            if ("optional".equals(importPackageSpecificationArray[n].getDirective("resolution"))) {
                arrayList.add(new ResolverImport(this, importPackageSpecificationArray[n]));
            } else {
                arrayList.add(0, new ResolverImport(this, importPackageSpecificationArray[n]));
            }
            --n;
        }
        this.imports = arrayList.toArray(new ResolverImport[arrayList.size()]);
        ExportPackageDescription[] exportPackageDescriptionArray = bl ? this.getBundleDescription().getSelectedExports() : this.getBundleDescription().getExportPackages();
        this.exports = new ResolverExport[exportPackageDescriptionArray.length];
        int n2 = 0;
        while (n2 < exportPackageDescriptionArray.length) {
            this.exports[n2] = new ResolverExport(this, exportPackageDescriptionArray[n2]);
            ++n2;
        }
        BundleSpecification[] bundleSpecificationArray = this.getBundleDescription().getRequiredBundles();
        this.requires = new BundleConstraint[bundleSpecificationArray.length];
        int n3 = 0;
        while (n3 < this.requires.length) {
            this.requires[n3] = new BundleConstraint(this, bundleSpecificationArray[n3]);
            ++n3;
        }
        GenericSpecification[] genericSpecificationArray = this.getBundleDescription().getGenericRequires();
        this.genericReqiures = new GenericConstraint[genericSpecificationArray.length];
        int n4 = 0;
        while (n4 < this.genericReqiures.length) {
            this.genericReqiures[n4] = new GenericConstraint(this, genericSpecificationArray[n4]);
            ++n4;
        }
        GenericDescription[] genericDescriptionArray = bl ? this.getBundleDescription().getSelectedGenericCapabilities() : this.getBundleDescription().getGenericCapabilities();
        this.genericCapabilities = new GenericCapability[genericDescriptionArray.length];
        int n5 = 0;
        while (n5 < this.genericCapabilities.length) {
            this.genericCapabilities[n5] = new GenericCapability(this, genericDescriptionArray[n5]);
            ++n5;
        }
        this.fragments = null;
        this.fragmentExports = null;
        this.fragmentImports = null;
        this.fragmentRequires = null;
        this.fragmentGenericCapabilities = null;
        this.fragmentGenericRequires = null;
    }

    ResolverExport getExport(String string) {
        ResolverExport[] resolverExportArray = this.getExports(string);
        return resolverExportArray.length == 0 ? null : resolverExportArray[0];
    }

    ResolverExport[] getExports(String string) {
        ArrayList<ResolverExport> arrayList = new ArrayList<ResolverExport>(1);
        List list = this.resolver.getResolverExports().get(string);
        for (ResolverExport resolverExport : list) {
            if (resolverExport.getExporter() != this) continue;
            arrayList.add(resolverExport);
        }
        return arrayList.toArray(new ResolverExport[arrayList.size()]);
    }

    void clearWires() {
        ResolverImport[] resolverImportArray = this.getImportPackages();
        int n = 0;
        while (n < resolverImportArray.length) {
            resolverImportArray[n].clearPossibleSuppliers();
            ++n;
        }
        if (this.host != null) {
            this.host.clearPossibleSuppliers();
        }
        BundleConstraint[] bundleConstraintArray = this.getRequires();
        int n2 = 0;
        while (n2 < bundleConstraintArray.length) {
            bundleConstraintArray[n2].clearPossibleSuppliers();
            ++n2;
        }
        GenericConstraint[] genericConstraintArray = this.getGenericRequires();
        int n3 = 0;
        while (n3 < genericConstraintArray.length) {
            genericConstraintArray[n3].clearPossibleSuppliers();
            ++n3;
        }
        ResolverExport[] resolverExportArray = this.getExportPackages();
        int n4 = 0;
        while (n4 < resolverExportArray.length) {
            resolverExportArray[n4].setSubstitute(null);
            ++n4;
        }
    }

    boolean isResolved() {
        return this.getState() == 2;
    }

    boolean isFragment() {
        return this.host != null;
    }

    int getState() {
        return this.state;
    }

    void setState(int n) {
        this.state = n;
    }

    private <T> List<T> getAll(T[] TArray, Map<Long, List<T>> map) {
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length);
        T[] TArray2 = TArray;
        int n = TArray.length;
        int n2 = 0;
        while (n2 < n) {
            T object = TArray2[n2];
            arrayList.add(object);
            ++n2;
        }
        for (ResolverBundle resolverBundle : this.fragments) {
            List<T> list = map.get(resolverBundle.bundleID);
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    ResolverImport[] getImportPackages() {
        if (this.isFragment() || this.fragments == null || this.fragments.size() == 0) {
            return this.imports;
        }
        List<ResolverImport> list = this.getAll(this.imports, this.fragmentImports);
        return list.toArray(new ResolverImport[list.size()]);
    }

    ResolverExport[] getExportPackages() {
        if (this.isFragment() || this.fragments == null || this.fragments.size() == 0) {
            return this.exports;
        }
        List<ResolverExport> list = this.getAll(this.exports, this.fragmentExports);
        return list.toArray(new ResolverExport[list.size()]);
    }

    ResolverExport[] getSelectedExports() {
        return this.getExports(true);
    }

    ResolverExport[] getSubstitutedExports() {
        return this.getExports(false);
    }

    private ResolverExport[] getExports(boolean bl) {
        ResolverExport[] resolverExportArray = this.getExportPackages();
        int n = 0;
        int n2 = 0;
        while (n2 < resolverExportArray.length) {
            if (bl ? resolverExportArray[n2].getSubstitute() != null : resolverExportArray[n2].getSubstitute() == null) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return resolverExportArray;
        }
        ResolverExport[] resolverExportArray2 = new ResolverExport[resolverExportArray.length - n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < resolverExportArray.length) {
            if (!(bl ? resolverExportArray[n4].getSubstitute() != null : resolverExportArray[n4].getSubstitute() == null)) {
                resolverExportArray2[n3] = resolverExportArray[n4];
                ++n3;
            }
            ++n4;
        }
        return resolverExportArray2;
    }

    BundleConstraint getHost() {
        return this.host;
    }

    GenericCapability[] getGenericCapabilities() {
        if (this.isFragment() || this.fragments == null || this.fragments.size() == 0) {
            return this.genericCapabilities;
        }
        List<GenericCapability> list = this.getAll(this.genericCapabilities, this.fragmentGenericCapabilities);
        return list.toArray(new GenericCapability[list.size()]);
    }

    BundleConstraint[] getRequires() {
        if (this.isFragment() || this.fragments == null || this.fragments.size() == 0) {
            return this.requires;
        }
        List<BundleConstraint> list = this.getAll(this.requires, this.fragmentRequires);
        return list.toArray(new BundleConstraint[list.size()]);
    }

    GenericConstraint[] getGenericRequires() {
        if (this.isFragment() || this.fragments == null || this.fragments.size() == 0) {
            return this.genericReqiures;
        }
        List<GenericConstraint> list = this.getAll(this.genericReqiures, this.fragmentGenericRequires);
        return list.toArray(new GenericConstraint[list.size()]);
    }

    BundleConstraint getRequire(String string) {
        BundleConstraint[] bundleConstraintArray = this.getRequires();
        int n = 0;
        while (n < bundleConstraintArray.length) {
            if (bundleConstraintArray[n].getVersionConstraint().getName().equals(string)) {
                return bundleConstraintArray[n];
            }
            ++n;
        }
        return null;
    }

    @Override
    public BundleDescription getBundleDescription() {
        return (BundleDescription)this.getBaseDescription();
    }

    @Override
    public ResolverBundle getResolverBundle() {
        return this;
    }

    ResolverImport getImport(String string) {
        ResolverImport[] resolverImportArray = this.getImportPackages();
        int n = 0;
        while (n < resolverImportArray.length) {
            if (resolverImportArray[n].getName().equals(string)) {
                return resolverImportArray[n];
            }
            ++n;
        }
        return null;
    }

    @Override
    public String toString() {
        return new StringBuffer("[").append(this.getBundleDescription()).append("]").toString();
    }

    private void initFragments() {
        if (this.fragments == null) {
            this.fragments = new ArrayList(1);
        }
        if (this.fragmentExports == null) {
            this.fragmentExports = new HashMap(1);
        }
        if (this.fragmentImports == null) {
            this.fragmentImports = new HashMap(1);
        }
        if (this.fragmentRequires == null) {
            this.fragmentRequires = new HashMap(1);
        }
        if (this.fragmentGenericCapabilities == null) {
            this.fragmentGenericCapabilities = new HashMap(1);
        }
        if (this.fragmentGenericRequires == null) {
            this.fragmentGenericRequires = new HashMap(1);
        }
    }

    private boolean isImported(String string) {
        ResolverImport[] resolverImportArray = this.getImportPackages();
        int n = 0;
        while (n < resolverImportArray.length) {
            if (string.equals(resolverImportArray[n].getName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isRequired(String string) {
        return this.getRequire(string) != null;
    }

    /*
     * WARNING - void declaration
     */
    void attachFragment(ResolverBundle resolverBundle, boolean bl) {
        int n;
        ArrayList<Object> arrayList;
        Object object;
        if (this.isFragment()) {
            return;
        }
        if (!this.getBundleDescription().attachFragments() || this.isResolved() && !this.getBundleDescription().dynamicFragments()) {
            return;
        }
        if (resolverBundle.getHost().getNumPossibleSuppliers() > 0 && !((HostSpecification)resolverBundle.getHost().getVersionConstraint()).isMultiHost()) {
            return;
        }
        ImportPackageSpecification[] importPackageSpecificationArray = resolverBundle.getBundleDescription().getImportPackages();
        BundleSpecification[] bundleSpecificationArray = resolverBundle.getBundleDescription().getRequiredBundles();
        ExportPackageDescription[] exportPackageDescriptionArray = resolverBundle.getBundleDescription().getExportPackages();
        GenericDescription[] genericDescriptionArray = resolverBundle.getBundleDescription().getGenericCapabilities();
        GenericSpecification[] genericSpecificationArray = resolverBundle.getBundleDescription().getGenericRequires();
        if (bl && this.constraintsConflict(resolverBundle.getBundleDescription(), importPackageSpecificationArray, bundleSpecificationArray, genericSpecificationArray)) {
            return;
        }
        if (this.isResolved() && exportPackageDescriptionArray.length > 0) {
            resolverBundle.setNewFragmentExports(true);
        }
        if (this.isResolved() && genericDescriptionArray.length > 0) {
            resolverBundle.setNewFragmentCapabilities(true);
        }
        this.initFragments();
        for (ResolverBundle object22 : this.fragments) {
            object = object22.getName();
            if (object == null || !object.equals(resolverBundle.getName())) continue;
            return;
        }
        if (this.fragments.contains(resolverBundle)) {
            return;
        }
        this.fragments.add(resolverBundle);
        resolverBundle.getHost().addPossibleSupplier(this);
        if (importPackageSpecificationArray.length > 0) {
            void n3;
            arrayList = new ArrayList(importPackageSpecificationArray.length);
            boolean n2 = false;
            while (n3 < importPackageSpecificationArray.length) {
                if (!this.isImported(importPackageSpecificationArray[n3].getName())) {
                    arrayList.add(new ResolverImport(this, importPackageSpecificationArray[n3]));
                }
                ++n3;
            }
            this.fragmentImports.put(resolverBundle.bundleID, arrayList);
        }
        if (bundleSpecificationArray.length > 0) {
            void n5;
            arrayList = new ArrayList<Object>(bundleSpecificationArray.length);
            boolean n4 = false;
            while (n5 < bundleSpecificationArray.length) {
                if (!this.isRequired(bundleSpecificationArray[n5].getName())) {
                    arrayList.add(new BundleConstraint(this, bundleSpecificationArray[n5]));
                }
                ++n5;
            }
            this.fragmentRequires.put(resolverBundle.bundleID, arrayList);
        }
        if (genericSpecificationArray.length > 0) {
            void var9_15;
            arrayList = new ArrayList(genericSpecificationArray.length);
            boolean bl2 = false;
            while (var9_15 < genericSpecificationArray.length) {
                arrayList.add(new GenericConstraint(this, genericSpecificationArray[var9_15]));
                ++var9_15;
            }
            this.fragmentGenericRequires.put(resolverBundle.bundleID, arrayList);
        }
        arrayList = new ArrayList(exportPackageDescriptionArray.length);
        if (exportPackageDescriptionArray.length > 0 && bl) {
            void var9_17;
            boolean bl3 = false;
            while (var9_17 < exportPackageDescriptionArray.length) {
                object = this.getExports(exportPackageDescriptionArray[var9_17].getName());
                n = 0;
                int n2 = 0;
                while (n2 < ((ResolverExport[])object).length && n == 0) {
                    if (this.equivalentExports(object[n2], exportPackageDescriptionArray[var9_17])) {
                        n = 1;
                    }
                    ++n2;
                }
                if (n == 0) {
                    ExportPackageDescriptionImpl exportPackageDescriptionImpl = new ExportPackageDescriptionImpl(this.getBundleDescription(), exportPackageDescriptionArray[var9_17]);
                    arrayList.add(new ResolverExport(this, exportPackageDescriptionImpl));
                }
                ++var9_17;
            }
            this.fragmentExports.put(resolverBundle.bundleID, arrayList);
        }
        ArrayList<GenericCapability> arrayList2 = new ArrayList<GenericCapability>(genericDescriptionArray.length);
        if (genericDescriptionArray.length > 0 && bl) {
            GenericDescription[] genericDescriptionArray2 = genericDescriptionArray;
            int n3 = genericDescriptionArray.length;
            n = 0;
            while (n < n3) {
                object = genericDescriptionArray2[n];
                GenericDescriptionImpl genericDescriptionImpl = new GenericDescriptionImpl(this.getBundleDescription(), (GenericDescription)object);
                arrayList2.add(new GenericCapability(this, genericDescriptionImpl));
                ++n;
            }
            this.fragmentGenericCapabilities.put(resolverBundle.bundleID, arrayList2);
        }
        if (bl) {
            this.resolver.getResolverExports().put(arrayList.toArray(new ResolverExport[arrayList.size()]));
            this.resolver.addGenerics(arrayList2.toArray(new GenericCapability[arrayList2.size()]));
        }
    }

    private boolean equivalentExports(ResolverExport resolverExport, ExportPackageDescription exportPackageDescription) {
        ExportPackageDescription exportPackageDescription2 = resolverExport.getExportPackageDescription();
        if (!exportPackageDescription2.getName().equals(exportPackageDescription.getName())) {
            return false;
        }
        if (!exportPackageDescription2.getVersion().equals(exportPackageDescription.getVersion())) {
            return false;
        }
        if (!ResolverBundle.equivalentMaps(exportPackageDescription2.getAttributes(), exportPackageDescription.getAttributes(), true)) {
            return false;
        }
        return ResolverBundle.equivalentMaps(exportPackageDescription2.getDirectives(), exportPackageDescription.getDirectives(), true);
    }

    public static boolean equivalentMaps(Map<String, Object> map, Map<String, Object> map2, boolean bl) {
        if (map == null && map2 == null) {
            return true;
        }
        if (map == null ? map2 != null : map2 == null) {
            return false;
        }
        if (bl && map.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = map2.get(entry.getKey());
            if (object == null || entry.getValue().getClass() != object.getClass()) {
                return false;
            }
            if (!(object instanceof String[] ? !Arrays.equals((Object[])entry.getValue(), (Object[])object) : !entry.getValue().equals(object))) continue;
            return false;
        }
        return true;
    }

    boolean constraintsConflict(BundleDescription bundleDescription, ImportPackageSpecification[] importPackageSpecificationArray, BundleSpecification[] bundleSpecificationArray, GenericSpecification[] genericSpecificationArray) {
        VersionSupplier versionSupplier;
        ResolverConstraint resolverConstraint;
        boolean bl = false;
        int n = 0;
        while (n < importPackageSpecificationArray.length) {
            resolverConstraint = this.getImport(importPackageSpecificationArray[n].getName());
            versionSupplier = (ResolverExport)(resolverConstraint == null ? null : resolverConstraint.getSelectedSupplier());
            if (versionSupplier == null && this.isResolved() || versionSupplier != null && !importPackageSpecificationArray[n].isSatisfiedBy(((ResolverExport)versionSupplier).getExportPackageDescription())) {
                bl = true;
                this.resolver.getState().addResolverError(bundleDescription, 16, importPackageSpecificationArray[n].toString(), importPackageSpecificationArray[n]);
            }
            ++n;
        }
        n = 0;
        while (n < bundleSpecificationArray.length) {
            resolverConstraint = this.getRequire(bundleSpecificationArray[n].getName());
            versionSupplier = (ResolverBundle)(resolverConstraint == null ? null : resolverConstraint.getSelectedSupplier());
            if (versionSupplier == null && this.isResolved() || versionSupplier != null && !bundleSpecificationArray[n].isSatisfiedBy(((ResolverBundle)versionSupplier).getBundleDescription())) {
                bl = true;
                this.resolver.getState().addResolverError(bundleDescription, 16, bundleSpecificationArray[n].toString(), bundleSpecificationArray[n]);
            }
            ++n;
        }
        if (this.isResolved() && genericSpecificationArray != null && genericSpecificationArray.length > 0) {
            bl = true;
        }
        return bl;
    }

    private void setNewFragmentExports(boolean bl) {
        this.newFragmentExports = bl;
    }

    boolean isNewFragmentExports() {
        return this.newFragmentExports;
    }

    private void setNewFragmentCapabilities(boolean bl) {
        this.newFragmentCapabilities = bl;
    }

    boolean isNewFragmentCapabilities() {
        return this.newFragmentCapabilities;
    }

    void detachFragment(ResolverBundle resolverBundle, ResolverConstraint resolverConstraint) {
        VersionSupplier[] versionSupplierArray;
        if (this.isFragment()) {
            return;
        }
        this.initFragments();
        ResolverImport[] resolverImportArray = this.getImportPackages();
        BundleConstraint[] bundleConstraintArray = this.getRequires();
        if (!this.fragments.remove(resolverBundle)) {
            return;
        }
        resolverBundle.setNewFragmentExports(false);
        resolverBundle.setNewFragmentCapabilities(false);
        resolverBundle.getHost().removePossibleSupplier(this);
        this.fragmentImports.remove(resolverBundle.bundleID);
        this.fragmentRequires.remove(resolverBundle.bundleID);
        List<ResolverExport> list = this.fragmentExports.remove(resolverBundle.bundleID);
        this.fragmentGenericRequires.remove(resolverBundle.bundleID);
        List<GenericCapability> list2 = this.fragmentGenericCapabilities.remove(resolverBundle.bundleID);
        if (resolverConstraint != null) {
            VersionSupplier[] versionSupplierArray2 = versionSupplierArray = this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
            int n = versionSupplierArray.length;
            int n2 = 0;
            while (n2 < n) {
                VersionSupplier versionSupplier = versionSupplierArray2[n2];
                ArrayList<ResolverImport> arrayList = new ArrayList<ResolverImport>(0);
                ArrayList<BundleConstraint> arrayList2 = new ArrayList<BundleConstraint>(0);
                if (!this.hasUnresolvedConstraint(resolverConstraint, resolverBundle, (ResolverBundle)versionSupplier, resolverImportArray, bundleConstraintArray, arrayList, arrayList2)) {
                    List<ResolverConstraint> list3;
                    if (arrayList.size() > 0) {
                        list3 = this.fragmentImports.get(((ResolverBundle)versionSupplier).bundleID);
                        if (list3 == null) {
                            this.fragmentImports.put(((ResolverBundle)versionSupplier).bundleID, arrayList);
                        } else {
                            list3.addAll(arrayList);
                        }
                    }
                    if (arrayList2.size() > 0) {
                        list3 = this.fragmentRequires.get(((ResolverBundle)versionSupplier).bundleID);
                        if (list3 == null) {
                            this.fragmentRequires.put(((ResolverBundle)versionSupplier).bundleID, arrayList2);
                        } else {
                            list3.addAll(arrayList2);
                        }
                    }
                }
                ++n2;
            }
        }
        versionSupplierArray = list == null ? new ResolverExport[]{} : list.toArray(new ResolverExport[list.size()]);
        int n = 0;
        while (n < versionSupplierArray.length) {
            versionSupplierArray[n].setSubstitute(versionSupplierArray[n]);
            ++n;
        }
        this.resolver.getResolverExports().remove((ResolverExport)versionSupplierArray);
        if (list2 != null) {
            this.resolver.removeGenerics(list2.toArray(new GenericCapability[list2.size()]));
        }
    }

    private boolean hasUnresolvedConstraint(ResolverConstraint resolverConstraint, ResolverBundle resolverBundle, ResolverBundle resolverBundle2, ResolverImport[] resolverImportArray, BundleConstraint[] bundleConstraintArray, List<ResolverImport> list, List<BundleConstraint> list2) {
        int n;
        ImportPackageSpecification[] importPackageSpecificationArray = resolverBundle2.getBundleDescription().getImportPackages();
        BundleSpecification[] bundleSpecificationArray = resolverBundle2.getBundleDescription().getRequiredBundles();
        VersionConstraint[] versionConstraintArray = resolverConstraint instanceof ResolverImport ? importPackageSpecificationArray : bundleSpecificationArray;
        int n2 = 0;
        while (n2 < versionConstraintArray.length) {
            if (resolverConstraint.getName().equals(versionConstraintArray[n2].getName())) {
                this.detachFragment(resolverBundle2, resolverConstraint);
                return true;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < resolverImportArray.length) {
            if (resolverImportArray[n2].getVersionConstraint().getBundle() == resolverBundle.getBundleDescription()) {
                n = 0;
                while (n < importPackageSpecificationArray.length) {
                    if (resolverImportArray[n2].getName().equals(importPackageSpecificationArray[n].getName())) {
                        list.add(resolverImportArray[n2]);
                        resolverImportArray[n2].setVersionConstraint(importPackageSpecificationArray[n]);
                        break;
                    }
                    ++n;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < bundleConstraintArray.length) {
            if (bundleConstraintArray[n2].getVersionConstraint().getBundle() == resolverBundle.getBundleDescription()) {
                n = 0;
                while (n < bundleSpecificationArray.length) {
                    if (bundleConstraintArray[n2].getName().equals(bundleSpecificationArray[n].getName())) {
                        list2.add(bundleConstraintArray[n2]);
                        bundleConstraintArray[n2].setVersionConstraint(bundleSpecificationArray[n]);
                        break;
                    }
                    ++n;
                }
            }
            ++n2;
        }
        return false;
    }

    void detachAllFragments() {
        if (this.fragments == null) {
            return;
        }
        ResolverBundle[] resolverBundleArray = this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
        int n = 0;
        while (n < resolverBundleArray.length) {
            this.detachFragment(resolverBundleArray[n], null);
            ++n;
        }
        this.fragments = null;
    }

    boolean isResolvable() {
        return this.resolvable;
    }

    void setResolvable(boolean bl) {
        this.resolvable = bl;
    }

    void addExport(ResolverExport resolverExport) {
        ResolverExport[] resolverExportArray = new ResolverExport[this.exports.length + 1];
        int n = 0;
        while (n < this.exports.length) {
            resolverExportArray[n] = this.exports[n];
            ++n;
        }
        resolverExportArray[this.exports.length] = resolverExport;
        this.exports = resolverExportArray;
    }

    ResolverImpl getResolver() {
        return this.resolver;
    }

    ResolverBundle[] getFragments() {
        return this.fragments == null ? new ResolverBundle[]{} : this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
    }

    @Override
    public int compareTo(ResolverBundle resolverBundle) {
        String string = this.getName();
        String string2 = resolverBundle.getName();
        if (string == null) {
            return string2 == null ? 0 : 1;
        }
        return string2 == null ? -1 : string.compareTo(string2);
    }

    void setUninstalled() {
        this.uninstalled = true;
    }

    boolean isUninstalled() {
        return this.uninstalled;
    }
}

