/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedList<K, V> {
    protected final HashMap<K, List<V>> internal = new HashMap();
    protected final List<V> empty = Collections.EMPTY_LIST;

    public void put(K k, V v) {
        List<V> list = this.internal.get(k);
        if (list == null) {
            list = new ArrayList<V>(1);
            list.add(v);
            this.internal.put(k, list);
            return;
        }
        int n = this.insertionIndex(list, v);
        list.add(n, v);
    }

    protected int insertionIndex(List<V> list, V v) {
        return list.size();
    }

    public List<V> remove(K k) {
        return this.get(k, true);
    }

    public List<V> get(K k) {
        return this.get(k, false);
    }

    private List<V> get(K k, boolean bl) {
        List<V> list = bl ? this.internal.remove(k) : this.internal.get(k);
        return list == null ? this.empty : list;
    }

    public int getSize() {
        return this.internal.size();
    }

    public List<V> getAllValues() {
        if (this.getSize() == 0) {
            return this.empty;
        }
        ArrayList arrayList = new ArrayList(this.getSize());
        Iterator<List<V>> iterator = this.internal.values().iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(iterator.next());
        }
        return arrayList;
    }

    public void clear() {
        this.internal.clear();
    }
}

