/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.PackageSource;
import org.eclipse.osgi.internal.loader.SingleSourcePackage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSourcePackage
extends PackageSource {
    SingleSourcePackage[] suppliers;

    MultiSourcePackage(String string, SingleSourcePackage[] singleSourcePackageArray) {
        super(string);
        this.suppliers = singleSourcePackageArray;
    }

    @Override
    public SingleSourcePackage[] getSuppliers() {
        return this.suppliers;
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        int n = 0;
        while (n < this.suppliers.length) {
            clazz = this.suppliers[n].loadClass(string);
            if (clazz != null) {
                return clazz;
            }
            ++n;
        }
        return clazz;
    }

    @Override
    public URL getResource(String string) {
        URL uRL = null;
        int n = 0;
        while (n < this.suppliers.length) {
            uRL = this.suppliers[n].getResource(string);
            if (uRL != null) {
                return uRL;
            }
            ++n;
        }
        return uRL;
    }

    @Override
    public Enumeration<URL> getResources(String string) {
        Enumeration<URL> enumeration = null;
        int n = 0;
        while (n < this.suppliers.length) {
            enumeration = BundleLoader.compoundEnumerations(enumeration, this.suppliers[n].getResources(string));
            ++n;
        }
        return enumeration;
    }

    @Override
    public Collection<String> listResources(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SingleSourcePackage[] singleSourcePackageArray = this.suppliers;
        int n = this.suppliers.length;
        int n2 = 0;
        while (n2 < n) {
            SingleSourcePackage singleSourcePackage = singleSourcePackageArray[n2];
            Collection<String> collection = singleSourcePackage.listResources(string, string2);
            for (String string3 : collection) {
                if (arrayList.contains(string3)) continue;
                arrayList.add(string3);
            }
            ++n2;
        }
        return arrayList;
    }
}

