/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.protocol.reference;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.osgi.framework.adaptor.FilePath;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.ReferenceInputStream;

public class ReferenceURLConnection
extends URLConnection {
    protected URL reference;

    protected ReferenceURLConnection(URL uRL) {
        super(uRL);
    }

    public synchronized void connect() throws IOException {
        if (!this.connected) {
            File file;
            String string;
            String string2 = this.url.getPath().substring(5);
            File file2 = new File(string2);
            if (!file2.isAbsolute() && (string = this.getInstallPath()) != null) {
                file2 = ReferenceURLConnection.makeAbsolute(string, file2);
            }
            if (!file2.exists() && string2.indexOf(37) >= 0 && (file = new File(string = FrameworkProperties.decode(file2.getAbsolutePath()))).exists()) {
                file2 = file;
            }
            URL uRL = file2.toURL();
            this.checkRead(file2);
            this.reference = uRL;
        }
    }

    private void checkRead(File file) throws IOException {
        File[] fileArray;
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        if (file.isFile()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            ((InputStream)fileInputStream).close();
        } else if (file.isDirectory() && (fileArray = file.listFiles()) == null) {
            throw new FileNotFoundException(String.valueOf(file.toString()) + " (probably access denied)");
        }
    }

    public boolean getDoInput() {
        return true;
    }

    public boolean getDoOutput() {
        return false;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return new ReferenceInputStream(this.reference);
    }

    private String getInstallPath() {
        String string = FrameworkProperties.getProperty("osgi.install.area");
        if (string == null) {
            return null;
        }
        if (!string.startsWith("file:")) {
            return null;
        }
        return string.substring(5);
    }

    private static File makeAbsolute(String string, File file) {
        if (file.isAbsolute()) {
            return file;
        }
        return new File(new FilePath(String.valueOf(string) + file.getPath()).toString());
    }
}

