/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.protocol;

import java.io.IOException;
import java.net.ContentHandler;
import java.net.URLConnection;
import org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentHandlerProxy
extends ContentHandler
implements ServiceTrackerCustomizer<ContentHandler, ServiceReference<ContentHandler>> {
    protected ContentHandler realHandler;
    protected ServiceTracker<ContentHandler, ServiceReference<ContentHandler>> contentHandlerServiceTracker;
    protected BundleContext context;
    protected ServiceReference<ContentHandler> contentHandlerServiceReference;
    protected String contentType;
    protected int ranking = Integer.MIN_VALUE;
    static /* synthetic */ Class class$0;

    public ContentHandlerProxy(String string, ServiceReference<ContentHandler> serviceReference, BundleContext bundleContext) {
        this.context = bundleContext;
        this.contentType = string;
        this.setNewHandler(serviceReference, this.getRank(serviceReference));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.net.ContentHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.contentHandlerServiceTracker = new ServiceTracker<ContentHandler, ServiceReference<ContentHandler>>(bundleContext, clazz.getName(), this);
        StreamHandlerFactory.secureAction.open(this.contentHandlerServiceTracker);
    }

    private void setNewHandler(ServiceReference<ContentHandler> serviceReference, int n) {
        if (this.contentHandlerServiceReference != null) {
            this.context.ungetService(this.contentHandlerServiceReference);
        }
        this.contentHandlerServiceReference = serviceReference;
        this.ranking = n;
        this.realHandler = serviceReference == null ? new DefaultContentHandler() : StreamHandlerFactory.secureAction.getService(serviceReference, this.context);
    }

    @Override
    public ServiceReference<ContentHandler> addingService(ServiceReference<ContentHandler> serviceReference) {
        Object object = serviceReference.getProperty("url.content.mimetype");
        if (!(object instanceof String[])) {
            return null;
        }
        String[] stringArray = (String[])object;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(this.contentType)) {
                int n2 = this.getRank(serviceReference);
                if (n2 > this.ranking || this.contentHandlerServiceReference == null) {
                    this.setNewHandler(serviceReference, n2);
                }
                return serviceReference;
            }
            ++n;
        }
        return null;
    }

    @Override
    public void modifiedService(ServiceReference<ContentHandler> serviceReference, ServiceReference<ContentHandler> serviceReference2) {
        int n = this.getRank(serviceReference);
        if (serviceReference == this.contentHandlerServiceReference) {
            ServiceReference<ContentHandler> serviceReference3;
            if (n < this.ranking && (serviceReference3 = this.contentHandlerServiceTracker.getServiceReference()) != this.contentHandlerServiceReference && serviceReference3 != null) {
                this.setNewHandler(serviceReference3, (Integer)serviceReference3.getProperty("service.ranking"));
            }
        } else if (n > this.ranking) {
            this.setNewHandler(serviceReference, n);
        }
    }

    @Override
    public void removedService(ServiceReference<ContentHandler> serviceReference, ServiceReference<ContentHandler> serviceReference2) {
        if (serviceReference != this.contentHandlerServiceReference) {
            return;
        }
        ServiceReference<ContentHandler> serviceReference3 = this.contentHandlerServiceTracker.getServiceReference();
        this.setNewHandler(serviceReference3, this.getRank(serviceReference3));
    }

    @Override
    public Object getContent(URLConnection uRLConnection) throws IOException {
        return this.realHandler.getContent(uRLConnection);
    }

    private int getRank(ServiceReference<?> serviceReference) {
        if (serviceReference == null) {
            return Integer.MIN_VALUE;
        }
        Object object = serviceReference.getProperty("service.ranking");
        return object instanceof Integer ? (Integer)object : 0;
    }

    class DefaultContentHandler
    extends ContentHandler {
        DefaultContentHandler() {
        }

        public Object getContent(URLConnection uRLConnection) throws IOException {
            return uRLConnection.getInputStream();
        }
    }
}

