/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.ExportedPackageImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.InternalSystemBundle;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.BundleLoaderProxy;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.ResolverHookException;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageAdminImpl
implements PackageAdmin,
FrameworkWiring {
    protected Framework framework;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.core.PackageAdminImpl$GetBundleAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        clazz2.getName();
    }

    protected PackageAdminImpl(Framework framework) {
        this.framework = framework;
    }

    @Override
    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        ArrayList<ExportedPackageImpl> arrayList = new ArrayList<ExportedPackageImpl>();
        FrameworkAdaptor frameworkAdaptor = this.framework.adaptor;
        if (frameworkAdaptor == null) {
            return null;
        }
        ExportPackageDescription[] exportPackageDescriptionArray = frameworkAdaptor.getState().getExportedPackages();
        int n = 0;
        while (n < exportPackageDescriptionArray.length) {
            ExportedPackageImpl exportedPackageImpl = this.createExportedPackage(exportPackageDescriptionArray[n]);
            if (exportedPackageImpl != null && (bundle == null || exportedPackageImpl.getBundle() == bundle)) {
                arrayList.add(exportedPackageImpl);
            }
            ++n;
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new ExportedPackage[arrayList.size()]);
    }

    private ExportedPackageImpl createExportedPackage(ExportPackageDescription exportPackageDescription) {
        BundleDescription bundleDescription = exportPackageDescription.getExporter();
        if (bundleDescription == null || bundleDescription.getHost() != null) {
            return null;
        }
        Object object = bundleDescription.getUserObject();
        if (!(object instanceof BundleLoaderProxy)) {
            BundleHost bundleHost = (BundleHost)this.framework.getBundle(bundleDescription.getBundleId());
            if (bundleHost == null) {
                return null;
            }
            object = bundleHost.getLoaderProxy();
        }
        return new ExportedPackageImpl(exportPackageDescription, (BundleLoaderProxy)object);
    }

    @Override
    public ExportedPackage getExportedPackage(String string) {
        ExportedPackage[] exportedPackageArray = this.getExportedPackages((Bundle)null);
        if (exportedPackageArray == null) {
            return null;
        }
        ExportedPackage exportedPackage = null;
        int n = 0;
        while (n < exportedPackageArray.length) {
            if (string.equals(exportedPackageArray[n].getName())) {
                if (exportedPackage == null) {
                    exportedPackage = exportedPackageArray[n];
                } else {
                    Version version = exportedPackage.getVersion();
                    Version version2 = exportedPackageArray[n].getVersion();
                    if (version2.compareTo(version) >= 0) {
                        exportedPackage = exportedPackageArray[n];
                    }
                }
            }
            ++n;
        }
        return exportedPackage;
    }

    @Override
    public ExportedPackage[] getExportedPackages(String string) {
        ExportedPackage[] exportedPackageArray = this.getExportedPackages((Bundle)null);
        if (exportedPackageArray == null) {
            return null;
        }
        ArrayList<ExportedPackage> arrayList = new ArrayList<ExportedPackage>(1);
        int n = 0;
        while (n < exportedPackageArray.length) {
            if (string.equals(exportedPackageArray[n].getName())) {
                arrayList.add(exportedPackageArray[n]);
            }
            ++n;
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new ExportedPackage[arrayList.size()]);
    }

    @Override
    public void refreshPackages(Bundle[] bundleArray) {
        this.refreshPackages(bundleArray, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPackages(Bundle[] bundleArray, boolean bl, FrameworkListener[] frameworkListenerArray) {
        Bundle[] bundleArray2;
        Object object;
        this.framework.checkAdminPermission(this.framework.systemBundle, "resolve");
        if (bundleArray != null) {
            object = bundleArray;
            synchronized (bundleArray) {
                bundleArray2 = new AbstractBundle[bundleArray.length];
                System.arraycopy(bundleArray, 0, bundleArray2, 0, bundleArray.length);
                // ** MonitorExit[var5_4] (shouldn't be in output)
            }
        } else {
            bundleArray2 = null;
        }
        {
            if (bl) {
                this.doResolveBundles(bundleArray2, true, frameworkListenerArray);
                if (this.framework.isForcedRestart()) {
                    this.framework.systemBundle.stop();
                }
            } else {
                object = this.framework.secureAction.createThread(new Runnable((AbstractBundle[])bundleArray2, frameworkListenerArray){
                    private final /* synthetic */ AbstractBundle[] val$copy;
                    private final /* synthetic */ FrameworkListener[] val$listeners;
                    {
                        this.val$copy = abstractBundleArray;
                        this.val$listeners = frameworkListenerArray;
                    }

                    public void run() {
                        PackageAdminImpl.this.doResolveBundles(this.val$copy, true, this.val$listeners);
                        if (PackageAdminImpl.this.framework.isForcedRestart()) {
                            PackageAdminImpl.this.framework.shutdown(256);
                        }
                    }
                }, "Refresh Packages", this.framework.getContextFinder());
                ((Thread)object).start();
            }
            return;
        }
    }

    @Override
    public boolean resolveBundles(Bundle[] bundleArray) {
        return this.resolveBundles(bundleArray, false);
    }

    boolean resolveBundles(Bundle[] bundleArray, boolean bl) {
        block5: {
            this.framework.checkAdminPermission(this.framework.systemBundle, "resolve");
            if (bundleArray == null) {
                bundleArray = this.framework.getAllBundles();
            }
            try {
                this.doResolveBundles(bundleArray, false, null);
            }
            catch (ResolverHookException resolverHookException) {
                if (!bl) break block5;
                throw resolverHookException;
            }
        }
        int n = 0;
        while (n < bundleArray.length) {
            if (!((AbstractBundle)bundleArray[n]).isResolved()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doResolveBundles(Bundle[] bundleArray, boolean bl, FrameworkListener[] frameworkListenerArray) {
        try {
            try {
                Object object;
                Object object2;
                int n;
                if (Profile.STARTUP) {
                    Profile.logEnter("resolve bundles");
                }
                this.framework.publishBundleEvent(-2147483647, this.framework.systemBundle);
                State state = this.framework.adaptor.getState();
                BundleDescription[] bundleDescriptionArray = null;
                int n2 = n = bundleArray == null ? 0 : bundleArray.length;
                if (!bl) {
                    object2 = new ArrayList();
                    Bundle[] bundleArray2 = bundleArray;
                    int n3 = bundleArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        object = bundleArray2[n4];
                        BundleDescription bundleDescription = ((AbstractBundle)object).getBundleDescription();
                        if ((object.getState() & 2) != 0 && bundleDescription != null) {
                            object2.add(bundleDescription);
                        }
                        ++n4;
                    }
                    bundleDescriptionArray = object2.toArray(new BundleDescription[object2.size()]);
                } else if (n > 0) {
                    this.populateLoaders(this.framework.getAllBundles());
                    object2 = this.framework.bundles;
                    synchronized (object2) {
                        object = new ArrayList(n);
                        BundleDelta[] bundleDeltaArray = null;
                        int n5 = 0;
                        while (n5 < n) {
                            AbstractBundle[] abstractBundleArray;
                            BundleDescription bundleDescription = ((AbstractBundle)bundleArray[n5]).getBundleDescription();
                            if (bundleDescription != null && bundleDescription.getBundleId() != 0L && !object.contains(bundleDescription)) {
                                object.add(bundleDescription);
                            }
                            if (this.framework.isRefreshDuplicateBSNAllowed() && (abstractBundleArray = this.framework.bundles.getBundles(bundleArray[n5].getSymbolicName())) != null && abstractBundleArray.length > 1) {
                                if (bundleDeltaArray == null) {
                                    bundleDeltaArray = state.getChanges().getChanges(1, false);
                                }
                                int n6 = 0;
                                while (n6 < abstractBundleArray.length) {
                                    BundleDescription bundleDescription2;
                                    if (abstractBundleArray[n6] != bundleArray[n5] && (bundleDescription2 = abstractBundleArray[n6].getBundleDescription()) != null && bundleDescription2.getBundleId() != 0L && !object.contains(bundleDescription2) && this.checkExtensionBundle(bundleDescription2, bundleDeltaArray)) {
                                        object.add(bundleDescription2);
                                    }
                                    ++n6;
                                }
                            }
                            ++n5;
                        }
                        bundleDescriptionArray = object.size() == 0 ? null : object.toArray(new BundleDescription[object.size()]);
                    }
                }
                object2 = state.resolve(bundleDescriptionArray, bl);
                object = object2.getChanges();
                this.processDelta((BundleDelta[])object, bl, state);
                if (object2.getResovlerHookException() != null) {
                    throw object2.getResovlerHookException();
                }
            }
            catch (Throwable throwable) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("PackageAdminImpl.doResolveBundles: Error occured :");
                    Debug.printStackTrace(throwable);
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (Profile.STARTUP) {
                    Profile.logExit("resolve bundles");
                }
                if (this.framework.isActive()) {
                    this.framework.publishBundleEvent(Integer.MIN_VALUE, this.framework.systemBundle);
                    if (bl) {
                        this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null, frameworkListenerArray);
                    }
                }
            }
        }
        finally {
            if (Profile.STARTUP) {
                Profile.logExit("resolve bundles");
            }
            if (this.framework.isActive()) {
                this.framework.publishBundleEvent(Integer.MIN_VALUE, this.framework.systemBundle);
                if (bl) {
                    this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null, frameworkListenerArray);
                }
            }
        }
    }

    private void populateLoaders(AbstractBundle[] abstractBundleArray) {
        int n = 0;
        while (n < abstractBundleArray.length) {
            BundleLoader bundleLoader;
            if (abstractBundleArray[n] instanceof BundleHost && abstractBundleArray[n].isResolved() && (bundleLoader = ((BundleHost)abstractBundleArray[n]).getBundleLoader()) != null) {
                bundleLoader.getImportedSources(null);
            }
            ++n;
        }
    }

    private boolean checkExtensionBundle(BundleDescription bundleDescription, BundleDelta[] bundleDeltaArray) {
        if (bundleDescription.getHost() == null || !bundleDescription.isResolved()) {
            return true;
        }
        return ((BundleDescription)bundleDescription.getHost().getSupplier()).getBundleId() != 0L || bundleDeltaArray.length > 0;
    }

    private void resumeBundles(AbstractBundle[] abstractBundleArray, boolean bl, int[] nArray) {
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("PackageAdminImpl: restart the bundles");
        }
        if (abstractBundleArray == null) {
            return;
        }
        int n = 0;
        while (n < abstractBundleArray.length) {
            if (abstractBundleArray[n].isResolved() && (bl || (abstractBundleArray[n].getBundleData().getStatus() & 2) != 0 && !abstractBundleArray[n].testStateChanging(Thread.currentThread()))) {
                if (nArray[n] == 32) {
                    try {
                        abstractBundleArray[n].start(1);
                    }
                    catch (BundleException bundleException) {
                        this.framework.publishFrameworkEvent(2, abstractBundleArray[n], bundleException);
                    }
                } else {
                    this.framework.resumeBundle(abstractBundleArray[n]);
                }
            }
            ++n;
        }
    }

    private void suspendBundle(AbstractBundle abstractBundle) {
        if (abstractBundle.isActive() && !abstractBundle.isFragment()) {
            this.framework.suspendBundle(abstractBundle, true);
        } else if (abstractBundle.getStateChanging() != Thread.currentThread()) {
            try {
                abstractBundle.beginStateChange();
            }
            catch (BundleException bundleException) {
                this.framework.publishFrameworkEvent(2, abstractBundle, bundleException);
            }
        }
        if (Debug.DEBUG_PACKAGEADMIN && abstractBundle.stateChanging == null) {
            Debug.println(new StringBuffer("Bundle state change lock is clear! ").append(abstractBundle).toString());
            Debug.printStackTrace(new Exception("Stack trace"));
        }
    }

    private void applyRemovalPending(BundleDelta bundleDelta) throws BundleException {
        if ((bundleDelta.getType() & 0x100) != 0) {
            BundleDescription bundleDescription = bundleDelta.getBundle();
            if (bundleDescription.getDependents() != null && bundleDescription.getDependents().length > 0) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println(new StringBuffer("Bundles still depend on removed bundle! ").append(bundleDescription).toString());
                    Debug.printStackTrace(new Exception("Stack trace"));
                }
                throw new BundleException(Msg.OSGI_INTERNAL_ERROR);
            }
            Object object = bundleDescription.getUserObject();
            if (object instanceof BundleLoaderProxy) {
                BundleLoader.closeBundleLoader((BundleLoaderProxy)object);
                try {
                    ((BundleLoaderProxy)object).getBundleData().close();
                }
                catch (IOException iOException) {}
            } else if (object instanceof BundleData) {
                try {
                    ((BundleData)object).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private AbstractBundle setResolved(BundleDescription bundleDescription) {
        if (!bundleDescription.isResolved()) {
            return null;
        }
        AbstractBundle abstractBundle = this.framework.getBundle(bundleDescription.getBundleId());
        if (abstractBundle == null) {
            BundleException bundleException = new BundleException(NLS.bind(Msg.BUNDLE_NOT_IN_FRAMEWORK, bundleDescription));
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, bundleException);
            return null;
        }
        boolean bl = true;
        if (abstractBundle.isFragment()) {
            BundleDescription[] bundleDescriptionArray = bundleDescription.getHost().getHosts();
            int n = 0;
            while (n < bundleDescriptionArray.length) {
                BundleHost bundleHost = (BundleHost)this.framework.getBundle(bundleDescriptionArray[n].getBundleId());
                bl = ((BundleFragment)abstractBundle).addHost(bundleHost);
                ++n;
            }
        }
        if (bl) {
            abstractBundle.resolve();
        }
        return abstractBundle;
    }

    private void applyDeltas(BundleDelta[] bundleDeltaArray) throws BundleException {
        Arrays.sort(bundleDeltaArray, new Comparator<BundleDelta>(){

            @Override
            public int compare(BundleDelta bundleDelta, BundleDelta bundleDelta2) {
                return (int)(bundleDelta.getBundle().getBundleId() - bundleDelta2.getBundle().getBundleId());
            }
        });
        int n = 0;
        while (n < bundleDeltaArray.length) {
            NativeCodeSpecification nativeCodeSpecification;
            AbstractBundle abstractBundle;
            int n2 = bundleDeltaArray[n].getType();
            if ((n2 & 0x180) != 0) {
                this.applyRemovalPending(bundleDeltaArray[n]);
            }
            if ((n2 & 8) != 0 && (abstractBundle = this.setResolved(bundleDeltaArray[n].getBundle())) != null && abstractBundle.isResolved() && (nativeCodeSpecification = bundleDeltaArray[n].getBundle().getNativeCodeSpecification()) != null && nativeCodeSpecification.getSupplier() != null) {
                try {
                    BundleData bundleData = abstractBundle.getBundleData();
                    bundleData.installNativeCode(((NativeCodeDescription)nativeCodeSpecification.getSupplier()).getNativePaths());
                }
                catch (BundleException bundleException) {
                    this.framework.publishFrameworkEvent(2, abstractBundle, bundleException);
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private AbstractBundle[] processDelta(BundleDelta[] var1_1, boolean var2_2, State var3_3) {
        block47: {
            block48: {
                var4_4 = new ArrayList<Object>(var1_1.length);
                var5_5 = 0;
                while (var5_5 < var1_1.length) {
                    if (!((var1_1[var5_5].getType() & 256) != 0 && (var1_1[var5_5].getType() & 2) == 0 || (var6_7 = this.framework.getBundle(var1_1[var5_5].getBundle().getBundleId())) == null || var4_4.contains(var6_7))) {
                        var4_4.add(var6_7);
                    }
                    ++var5_5;
                }
                var5_6 = var4_4.toArray(new AbstractBundle[var4_4.size()]);
                Util.sort(var5_6, 0, var5_6.length);
                this.framework.startLevelManager.sortByDependency((AbstractBundle[])var5_6);
                var6_7 = new boolean[var5_6.length];
                var7_8 = new int[var5_6.length];
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: Suspend each bundle and acquire its state change lock");
                }
                var8_9 = false;
                var9_13 = var5_6.length - 1;
                while (var9_13 >= 0) {
                    var6_7[var9_13] = var5_6[var9_13].isResolved();
                    if (var5_6[var9_13] == this.framework.systemBundle) {
                        var8_9 = true;
                    } else if ((var5_6[var9_13].bundledata.getType() & 2) != 0 && var6_7[var9_13] != false) {
                        var8_9 = true;
                    } else if ((var5_6[var9_13].bundledata.getType() & 4) != 0) {
                        var8_9 = true;
                    } else if ((var5_6[var9_13].bundledata.getType() & 16) != 0 && var6_7[var9_13] != false) {
                        var8_9 = true;
                    }
                    --var9_13;
                }
                if (!var8_9) break block47;
                FrameworkProperties.setProperty("osgi.forcedRestart", "true");
                this.framework.setForcedRestart(true);
                if (!Debug.DEBUG_PACKAGEADMIN) break block48;
                Debug.println("refreshPackages: release the state change locks");
            }
            if (var2_2) {
                var12_17 = 0;
                while (var12_17 < var5_6.length) {
                    var13_20 = var5_6[var12_17];
                    var13_20.completeStateChange();
                    ++var12_17;
                }
            }
            return null;
        }
        try {
            block49: {
                if (var2_2) {
                    var9_13 = var5_6.length - 1;
                    while (var9_13 >= 0) {
                        var7_8[var9_13] = var5_6[var9_13].getState();
                        this.suspendBundle((AbstractBundle)var5_6[var9_13]);
                        --var9_13;
                    }
                }
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: refresh the bundles");
                }
                var9_14 = this.framework.bundles;
                synchronized (var9_14) {
                    var10_23 = var5_6.length - 1;
                    while (var10_23 >= 0) {
                        var5_6[var10_23].refresh();
                        --var10_23;
                    }
                }
                var9_15 = var5_6.length - 1;
                while (var9_15 >= 0) {
                    if (var6_7[var9_15] != false) {
                        this.framework.publishBundleEvent(64, (Bundle)var5_6[var9_15]);
                    }
                    --var9_15;
                }
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: applying deltas to bundles");
                }
                var9_16 = this.framework.bundles;
                synchronized (var9_16) {
                    this.applyDeltas(var1_1);
                    // MONITOREXIT @DISABLED, blocks:[2, 3, 5, 8] lbl85 : MonitorExitStatement: MONITOREXIT : var9_16
                }
                {
                    catch (Throwable var11_24) {}
                }
                finally {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages: release the state change locks");
                    }
                    if (!var2_2) break block49;
                    var12_19 = 0;
                    ** while (var12_19 < var5_6.length)
                }
lbl-1000:
                // 1 sources

                {
                    var13_22 = var5_6[var12_19];
                    var13_22.completeStateChange();
                    ++var12_19;
                    continue;
                }
            }
            if (var2_2) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: clean up adaptor storage");
                }
                try {
                    this.framework.adaptor.compactStorage();
                }
                catch (IOException var8_10) {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println(new StringBuffer("refreshPackages exception: ").append(var8_10.getMessage()).toString());
                        Debug.printStackTrace(var8_10);
                    }
                    this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.BUNDLE_REFRESH_FAILURE, var8_10));
                }
            }
        }
        catch (BundleException var8_11) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println(new StringBuffer("refreshPackages exception: ").append(var8_11.getMessage()).toString());
                Debug.printStackTrace(var8_11.getNestedException() == null ? var8_11 : var8_11.getNestedException());
            }
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.BUNDLE_REFRESH_FAILURE, var8_11));
        }
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: send out RESOLVED events");
        }
        var8_12 = 0;
        while (var8_12 < var5_6.length) {
            if (var5_6[var8_12].isResolved()) {
                this.framework.publishBundleEvent(32, (Bundle)var5_6[var8_12]);
            }
            ++var8_12;
        }
        if (!this.framework.isActive()) {
            return var5_6;
        }
        if (var2_2) {
            this.framework.securityAdmin.clearCaches();
            if (var1_1.length > 0) {
                var3_3.setTimeStamp(var3_3.getTimeStamp() == 0x7FFFFFFFFFFFFFFFL ? 0L : var3_3.getTimeStamp() + 1L);
            }
        }
        this.resumeBundles((AbstractBundle[])var5_6, var2_2, var7_8);
        return var5_6;
    }

    @Override
    public RequiredBundle[] getRequiredBundles(String string) {
        AbstractBundle[] abstractBundleArray = string == null ? this.framework.getAllBundles() : this.framework.getBundleBySymbolicName(string);
        if (abstractBundleArray == null || abstractBundleArray.length == 0) {
            return null;
        }
        ArrayList<BundleLoaderProxy> arrayList = new ArrayList<BundleLoaderProxy>(abstractBundleArray.length);
        int n = 0;
        while (n < abstractBundleArray.length) {
            if (!abstractBundleArray[n].isFragment() && abstractBundleArray[n].isResolved() && abstractBundleArray[n].getSymbolicName() != null && abstractBundleArray[n].hasPermission(new BundlePermission(abstractBundleArray[n].getSymbolicName(), "provide"))) {
                arrayList.add(((BundleHost)abstractBundleArray[n]).getLoaderProxy());
            }
            ++n;
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new RequiredBundle[arrayList.size()]);
    }

    @Override
    public Bundle[] getBundles(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        AbstractBundle[] abstractBundleArray = this.framework.getBundleBySymbolicName(string);
        if (abstractBundleArray == null) {
            return null;
        }
        if (string2 == null) {
            Bundle[] bundleArray = new AbstractBundle[abstractBundleArray.length];
            System.arraycopy(abstractBundleArray, 0, bundleArray, 0, bundleArray.length);
            return bundleArray;
        }
        ArrayList<AbstractBundle> arrayList = new ArrayList<AbstractBundle>(abstractBundleArray.length);
        VersionRange versionRange = new VersionRange(string2);
        int n = 0;
        while (n < abstractBundleArray.length) {
            if (versionRange.isIncluded(abstractBundleArray[n].getVersion())) {
                arrayList.add(abstractBundleArray[n]);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new AbstractBundle[arrayList.size()]);
    }

    @Override
    public Bundle[] getFragments(Bundle bundle) {
        return ((AbstractBundle)bundle).getFragments();
    }

    @Override
    public Bundle[] getHosts(Bundle bundle) {
        BundleHost[] bundleHostArray = ((AbstractBundle)bundle).getHosts();
        if (bundleHostArray == null) {
            return null;
        }
        Bundle[] bundleArray = new Bundle[bundleHostArray.length];
        int n = 0;
        while (n < bundleHostArray.length) {
            bundleArray[n] = bundleHostArray[n];
            ++n;
        }
        return bundleArray;
    }

    Bundle getBundlePriv(Class<?> clazz) {
        ClassLoaderDelegate classLoaderDelegate;
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof BundleClassLoader && (classLoaderDelegate = ((BundleClassLoader)((Object)classLoader)).getDelegate()) instanceof BundleLoader) {
            return ((BundleLoader)classLoaderDelegate).getBundle();
        }
        if (classLoader == this.getClass().getClassLoader()) {
            return this.framework.systemBundle;
        }
        return null;
    }

    @Override
    public Bundle getBundle(Class clazz) {
        if (System.getSecurityManager() == null) {
            return this.getBundlePriv(clazz);
        }
        return AccessController.doPrivileged(new GetBundleAction(this, clazz));
    }

    @Override
    public int getBundleType(Bundle bundle) {
        return ((AbstractBundle)bundle).isFragment() ? 1 : 0;
    }

    protected void cleanup() {
    }

    protected void setResolvedBundles(InternalSystemBundle internalSystemBundle) {
        this.checkSystemBundle(internalSystemBundle);
        State state = this.framework.adaptor.getState();
        BundleDescription[] bundleDescriptionArray = state.getBundles();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            if (bundleDescriptionArray[n].getBundleId() == 0L) {
                this.setFrameworkVersion(bundleDescriptionArray[n]);
            } else {
                this.setResolved(bundleDescriptionArray[n]);
            }
            ++n;
        }
    }

    private void checkSystemBundle(InternalSystemBundle internalSystemBundle) {
        try {
            State state = this.framework.adaptor.getState();
            BundleDescription bundleDescription = state.getBundle(0L);
            boolean bl = false;
            if (bundleDescription == null || !internalSystemBundle.getBundleData().getVersion().equals(bundleDescription.getVersion())) {
                bl = true;
            }
            if (!bl && FrameworkProperties.getProperty("osgi.dev") == null) {
                return;
            }
            BundleDescription bundleDescription2 = state.getFactory().createBundleDescription(state, internalSystemBundle.getHeaders(""), internalSystemBundle.getLocation(), 0L);
            if (bundleDescription2 == null) {
                throw new BundleException(Msg.OSGI_SYSTEMBUNDLE_DESCRIPTION_ERROR);
            }
            if (!bl) {
                ExportPackageDescription[] exportPackageDescriptionArray;
                ExportPackageDescription[] exportPackageDescriptionArray2 = bundleDescription.getExportPackages();
                if (exportPackageDescriptionArray2.length >= (exportPackageDescriptionArray = bundleDescription2.getExportPackages()).length) {
                    int n = 0;
                    while (n < exportPackageDescriptionArray.length && !bl) {
                        if (exportPackageDescriptionArray2[n].getName().equals(exportPackageDescriptionArray[n].getName())) {
                            Version version = exportPackageDescriptionArray2[n].getVersion();
                            Version version2 = exportPackageDescriptionArray[n].getVersion();
                            bl = version == null ? version2 != null : !((Object)version).equals(version2);
                        } else {
                            bl = true;
                        }
                        ++n;
                    }
                } else {
                    bl = true;
                }
            }
            if (bl) {
                state.removeBundle(0L);
                state.addBundle(bundleDescription2);
                state.resolve(false);
            }
        }
        catch (BundleException bundleException) {
            bundleException.printStackTrace();
            throw new RuntimeException(NLS.bind(Msg.OSGI_SYSTEMBUNDLE_CREATE_EXCEPTION, bundleException.getMessage()), bundleException);
        }
    }

    private void setFrameworkVersion(BundleDescription bundleDescription) {
        ExportPackageDescription[] exportPackageDescriptionArray = bundleDescription.getExportPackages();
        int n = 0;
        while (n < exportPackageDescriptionArray.length) {
            if (exportPackageDescriptionArray[n].getName().equals("org.osgi.framework")) {
                FrameworkProperties.setProperty("org.osgi.framework.version", exportPackageDescriptionArray[n].getVersion().toString());
                break;
            }
            ++n;
        }
        FrameworkProperties.setProperty("osgi.framework.version", bundleDescription.getVersion().toString());
    }

    @Override
    public Bundle getBundle() {
        return this.framework.getBundle(0L);
    }

    @Override
    public void refreshBundles(Collection<Bundle> collection, FrameworkListener[] frameworkListenerArray) {
        this.refreshPackages(collection == null ? null : collection.toArray(new Bundle[collection.size()]), false, frameworkListenerArray);
    }

    @Override
    public boolean resolveBundles(Collection<Bundle> collection) {
        return this.resolveBundles(collection == null ? null : collection.toArray(new Bundle[collection.size()]));
    }

    @Override
    public Collection<Bundle> getRemovalPendingBundles() {
        BundleDescription[] bundleDescriptionArray = this.framework.adaptor.getState().getRemovalPending();
        HashSet<Bundle> hashSet = new HashSet<Bundle>();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            Object object = bundleDescriptionArray[n].getUserObject();
            if (object instanceof BundleReference) {
                hashSet.add(((BundleReference)object).getBundle());
            }
            ++n;
        }
        return hashSet;
    }

    @Override
    public Collection<Bundle> getDependencyClosure(Collection<Bundle> collection) {
        Collection<BundleDescription> collection2 = this.getDescriptionClosure(collection);
        HashSet<Bundle> hashSet = new HashSet<Bundle>();
        for (BundleDescription bundleDescription : collection2) {
            Bundle bundle;
            Object object = bundleDescription.getUserObject();
            if (!(object instanceof BundleReference) || (bundle = ((BundleReference)object).getBundle()) == null) continue;
            hashSet.add(bundle);
        }
        return hashSet;
    }

    private Collection<BundleDescription> getDescriptionClosure(Collection<Bundle> collection) {
        State state = this.framework.adaptor.getState();
        ArrayList<BundleDescription> arrayList = new ArrayList<BundleDescription>();
        for (Bundle bundle : collection) {
            BundleDescription bundleDescription = state.getBundle(bundle.getBundleId());
            if (bundleDescription == null) continue;
            arrayList.add(bundleDescription);
        }
        return state.getDependencyClosure(arrayList);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GetBundleAction
    implements PrivilegedAction<Bundle> {
        private Class<?> clazz;
        private PackageAdminImpl impl;

        public GetBundleAction(PackageAdminImpl packageAdminImpl, Class<?> clazz) {
            this.impl = packageAdminImpl;
            this.clazz = clazz;
        }

        @Override
        public Bundle run() {
            return this.impl.getBundlePriv(this.clazz);
        }
    }
}

