/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.DirZipBundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.MRUBundleFileList;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleEntry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipBundleFile
extends BundleFile {
    private final MRUBundleFileList mruList;
    protected BaseData bundledata;
    protected volatile ZipFile zipFile;
    protected volatile boolean closed = true;
    private int referenceCount = 0;

    public ZipBundleFile(File file, BaseData baseData) throws IOException {
        this(file, baseData, null);
    }

    public ZipBundleFile(File file, BaseData baseData, MRUBundleFileList mRUBundleFileList) throws IOException {
        super(file);
        if (!BundleFile.secureAction.exists(file)) {
            throw new IOException(NLS.bind(AdaptorMsg.ADAPTER_FILEEXIST_EXCEPTION, file));
        }
        this.bundledata = baseData;
        this.closed = true;
        this.mruList = mRUBundleFileList;
    }

    protected boolean checkedOpen() {
        try {
            return this.getZipFile() != null;
        }
        catch (IOException iOException) {
            if (this.bundledata != null) {
                this.bundledata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, this.bundledata.getBundle(), iOException);
            }
            return false;
        }
    }

    protected ZipFile basicOpen() throws IOException {
        return BundleFile.secureAction.getZipFile(this.basefile);
    }

    protected synchronized ZipFile getZipFile() throws IOException {
        if (this.closed) {
            this.mruListAdd();
            this.zipFile = this.basicOpen();
            this.closed = false;
        } else {
            this.mruListUse();
        }
        return this.zipFile;
    }

    protected ZipEntry getZipEntry(String string) {
        ZipEntry zipEntry;
        ZipEntry zipEntry2;
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if ((zipEntry2 = this.zipFile.getEntry(string)) != null && zipEntry2.getSize() == 0L && !zipEntry2.isDirectory() && (zipEntry = this.zipFile.getEntry(new StringBuffer(String.valueOf(string)).append('/').toString())) != null) {
            zipEntry2 = zipEntry;
        }
        return zipEntry2;
    }

    protected synchronized File extractDirectory(String string) {
        if (!this.checkedOpen()) {
            return null;
        }
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().getName();
            if (!string2.startsWith(string) || string2.endsWith("/")) continue;
            this.getFile(string2, false);
        }
        return this.getExtractFile(string);
    }

    protected File getExtractFile(String string) {
        if (this.bundledata == null) {
            return null;
        }
        String string2 = ".cp";
        String string3 = string.replace('/', File.separatorChar);
        string2 = string3.length() > 1 && string3.charAt(0) == File.separatorChar ? string2.concat(string3) : new StringBuffer(String.valueOf(string2)).append(File.separator).append(string3).toString();
        return this.bundledata.getExtractFile(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized File getFile(String string, boolean bl) {
        InputStream inputStream;
        File file;
        block11: {
            if (!this.checkedOpen()) {
                return null;
            }
            ZipEntry zipEntry = this.getZipEntry(string);
            if (zipEntry == null) {
                return null;
            }
            file = this.getExtractFile(zipEntry.getName());
            if (file == null) return null;
            if (file.exists()) {
                if (Debug.DEBUG_GENERAL) {
                    Debug.println(new StringBuffer("File already present: ").append(file.getPath()).toString());
                }
                if (!file.isDirectory()) return file;
                this.extractDirectory(zipEntry.getName());
                return file;
            }
            if (zipEntry.getName().endsWith("/")) {
                if (!file.mkdirs()) {
                    if (!Debug.DEBUG_GENERAL) throw new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, file.getAbsolutePath()));
                    Debug.println(new StringBuffer("Unable to create directory: ").append(file.getPath()).toString());
                    throw new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, file.getAbsolutePath()));
                }
                this.extractDirectory(zipEntry.getName());
                return file;
            }
            inputStream = this.zipFile.getInputStream(zipEntry);
            if (inputStream != null) break block11;
            return null;
        }
        try {
            File file2;
            if (Debug.DEBUG_GENERAL) {
                Debug.println(new StringBuffer("Creating file: ").append(file.getPath()).toString());
            }
            if (!(file2 = new File(file.getParent())).exists() && !file2.mkdirs()) {
                if (!Debug.DEBUG_GENERAL) throw new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, file2.getAbsolutePath()));
                Debug.println(new StringBuffer("Unable to create directory: ").append(file2.getPath()).toString());
                throw new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, file2.getAbsolutePath()));
            }
            AdaptorUtil.readFile(inputStream, file);
            if (!bl) return file;
            ZipBundleFile.setPermissions(file);
            return file;
        }
        catch (IOException iOException) {
            if (!Debug.DEBUG_GENERAL) return null;
            Debug.printStackTrace(iOException);
        }
        return null;
    }

    @Override
    public synchronized boolean containsDir(String string) {
        if (!this.checkedOpen()) {
            return false;
        }
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return true;
        }
        if (string.charAt(0) == '/') {
            if (string.length() == 1) {
                return true;
            }
            string = string.substring(1);
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) != '/') {
            string = new StringBuffer(String.valueOf(string)).append('/').toString();
        }
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName();
            if (!string2.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized BundleEntry getEntry(String string) {
        if (!this.checkedOpen()) {
            return null;
        }
        ZipEntry zipEntry = this.getZipEntry(string);
        if (zipEntry == null) {
            if ((string.length() == 0 || string.charAt(string.length() - 1) == '/') && this.containsDir(string)) {
                return new DirZipBundleEntry(this, string);
            }
            return null;
        }
        return new ZipBundleEntry(zipEntry, this);
    }

    @Override
    public synchronized Enumeration<String> getEntryPaths(String string) {
        if (!this.checkedOpen()) {
            return null;
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() > 0 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) != '/') {
            string = new StringBuffer(string).append("/").toString();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName();
            if (!string2.startsWith(string) || string.length() >= string2.length()) continue;
            if (string2.lastIndexOf(47) < string.length()) {
                arrayList.add(string2);
                continue;
            }
            string2 = string2.substring(string.length());
            int n = string2.indexOf(47);
            string2 = new StringBuffer(String.valueOf(string)).append(string2.substring(0, n + 1)).toString();
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList.size() == 0 ? null : Collections.enumeration(arrayList);
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            if (this.referenceCount > 0 && this.isMruListClosing()) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
                if (this.referenceCount != 0 || this.closed) {
                    return;
                }
            }
            this.closed = true;
            this.zipFile.close();
            this.mruListRemove();
        }
    }

    private boolean isMruListClosing() {
        return this.mruList != null && this.mruList.isClosing(this);
    }

    boolean isMruEnabled() {
        return this.mruList != null && this.mruList.isEnabled();
    }

    private void mruListRemove() {
        if (this.mruList != null) {
            this.mruList.remove(this);
        }
    }

    private void mruListUse() {
        if (this.mruList != null) {
            this.mruList.use(this);
        }
    }

    private void mruListAdd() {
        if (this.mruList != null) {
            this.mruList.add(this);
        }
    }

    @Override
    public void open() {
    }

    synchronized void incrementReference() {
        ++this.referenceCount;
    }

    synchronized void decrementReference() {
        this.referenceCount = Math.max(0, this.referenceCount - 1);
        if (this.referenceCount == 0) {
            this.notify();
        }
    }
}

