/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.internal;

import java.util.LinkedList;

public class SerializedTaskQueue {
    private static final int MAX_WAIT = 5000;
    private final LinkedList<Runnable> tasks = new LinkedList();
    private Thread thread;
    private final String queueName;

    public SerializedTaskQueue(String string) {
        this.queueName = string;
    }

    public synchronized void put(Runnable runnable) {
        this.tasks.add(runnable);
        if (this.thread == null) {
            this.thread = new Thread(this.queueName){

                public void run() {
                    Runnable runnable = SerializedTaskQueue.this.nextTask(5000);
                    while (runnable != null) {
                        runnable.run();
                        runnable = SerializedTaskQueue.this.nextTask(5000);
                    }
                }
            };
            this.thread.start();
        } else {
            this.notify();
        }
    }

    synchronized Runnable nextTask(int n) {
        if (this.tasks.isEmpty()) {
            try {
                this.wait(n);
            }
            catch (InterruptedException interruptedException) {}
            if (this.tasks.isEmpty()) {
                this.thread = null;
                return null;
            }
        }
        return this.tasks.removeFirst();
    }
}

