/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.File;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.internal.adaptor.ClasspathManifest;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.baseadaptor.BaseClassLoadingHook;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseClassLoadingHook
implements ClassLoadingHook,
HookConfigurator {
    private static String[] NL_JAR_VARIANTS = EclipseClassLoadingHook.buildNLJarVariants(EclipseEnvironmentInfo.getDefault().getNL());
    private static boolean DEFINE_PACKAGES;
    private static final boolean DEFINE_PACKAGE_ATTRIBUTES;
    private static String[] LIB_VARIANTS;
    private Object pkgLock = new Object();

    static {
        DEFINE_PACKAGE_ATTRIBUTES = !"noattributes".equals(FrameworkProperties.getProperty("osgi.classloader.define.packages"));
        LIB_VARIANTS = EclipseClassLoadingHook.buildLibraryVariants();
        try {
            Class.forName("java.lang.Package");
            DEFINE_PACKAGES = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            DEFINE_PACKAGES = false;
        }
    }

    private static String[] buildLibraryVariants() {
        ArrayList<String> arrayList = new ArrayList<String>();
        EclipseEnvironmentInfo eclipseEnvironmentInfo = EclipseEnvironmentInfo.getDefault();
        arrayList.add(new StringBuffer("ws/").append(eclipseEnvironmentInfo.getWS()).append("/").toString());
        arrayList.add(new StringBuffer("os/").append(eclipseEnvironmentInfo.getOS()).append("/").append(eclipseEnvironmentInfo.getOSArch()).append("/").toString());
        arrayList.add(new StringBuffer("os/").append(eclipseEnvironmentInfo.getOS()).append("/").toString());
        String string = eclipseEnvironmentInfo.getNL();
        string = string.replace('_', '/');
        while (string.length() > 0) {
            arrayList.add(new StringBuffer("nl/").append(string).append("/").toString());
            int n = string.lastIndexOf(47);
            String string2 = string = n < 0 ? "" : string.substring(0, n);
        }
        arrayList.add("");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] processClass(String string, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
        Object object;
        Object object2;
        if (!DEFINE_PACKAGES) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        Object object3 = this.pkgLock;
        synchronized (object3) {
            object2 = classpathManager.getBaseClassLoader().publicGetPackage(string2);
            if (object2 != null) {
                return null;
            }
        }
        object3 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        if (DEFINE_PACKAGE_ATTRIBUTES) {
            Manifest manifest;
            object = (ClasspathManifest)classpathEntry.getUserObject(ClasspathManifest.KEY);
            if (object == null) {
                object = new ClasspathManifest();
                classpathEntry.addUserObject((KeyedElement)object);
            }
            if ((manifest = ((ClasspathManifest)object).getManifest(classpathEntry, classpathManager)) != null) {
                Attributes attributes = manifest.getMainAttributes();
                String string8 = new StringBuffer(String.valueOf(string2.replace('.', '/'))).append('/').toString();
                Attributes attributes2 = manifest.getAttributes(string8);
                boolean bl = false;
                if (attributes2 == null) {
                    bl = true;
                    attributes2 = attributes;
                }
                if ((object3 = attributes2.getValue(Attributes.Name.SPECIFICATION_TITLE)) == null && !bl) {
                    object3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                }
                if ((string3 = attributes2.getValue(Attributes.Name.SPECIFICATION_VERSION)) == null && !bl) {
                    string3 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                }
                if ((string4 = attributes2.getValue(Attributes.Name.SPECIFICATION_VENDOR)) == null && !bl) {
                    string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                }
                if ((string5 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_TITLE)) == null && !bl) {
                    string5 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                }
                if ((string6 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_VERSION)) == null && !bl) {
                    string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                }
                if ((string7 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_VENDOR)) == null && !bl) {
                    string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                }
            }
        }
        object = this.pkgLock;
        synchronized (object) {
            object2 = classpathManager.getBaseClassLoader().publicGetPackage(string2);
            if (object2 != null) {
                return null;
            }
            classpathManager.getBaseClassLoader().publicDefinePackage(string2, (String)object3, string3, string4, string5, string6, string7, null);
            return null;
        }
    }

    @Override
    public boolean addClassPathEntry(ArrayList<ClasspathEntry> arrayList, String string, ClasspathManager classpathManager, BaseData baseData, ProtectionDomain protectionDomain) {
        ClasspathEntry classpathEntry;
        String string2 = EclipseClassLoadingHook.hasPrefix(string);
        if (string2 != null) {
            return this.addInternalClassPath(string2, arrayList, string, classpathManager, baseData, protectionDomain);
        }
        if (string.startsWith("external:") && (classpathEntry = classpathManager.getExternalClassPath(BaseStorageHook.substituteVars(string = string.substring("external:".length())), baseData, protectionDomain)) != null) {
            arrayList.add(classpathEntry);
            return true;
        }
        return false;
    }

    private boolean addInternalClassPath(String string, ArrayList<ClasspathEntry> arrayList, String string2, ClasspathManager classpathManager, BaseData baseData, ProtectionDomain protectionDomain) {
        if (string.equals("ws")) {
            return ClasspathManager.addClassPathEntry(arrayList, new StringBuffer("ws/").append(EclipseEnvironmentInfo.getDefault().getWS()).append(string2.substring(4)).toString(), classpathManager, baseData, protectionDomain);
        }
        if (string.equals("os")) {
            return ClasspathManager.addClassPathEntry(arrayList, new StringBuffer("os/").append(EclipseEnvironmentInfo.getDefault().getOS()).append(string2.substring(4)).toString(), classpathManager, baseData, protectionDomain);
        }
        if (string.equals("nl")) {
            string2 = string2.substring(4);
            int n = 0;
            while (n < NL_JAR_VARIANTS.length) {
                if (ClasspathManager.addClassPathEntry(arrayList, new StringBuffer("nl/").append(NL_JAR_VARIANTS[n]).append(string2).toString(), classpathManager, baseData, protectionDomain)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private static String hasPrefix(String string) {
        if (string.startsWith("$ws$")) {
            return "ws";
        }
        if (string.startsWith("$os$")) {
            return "os";
        }
        if (string.startsWith("$nl$")) {
            return "nl";
        }
        return null;
    }

    private static String[] buildNLJarVariants(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        string = string.replace('_', '/');
        while (string.length() > 0) {
            arrayList.add(new StringBuffer("nl/").append(string).append("/").toString());
            int n = string.lastIndexOf(47);
            String string2 = string = n < 0 ? "" : string.substring(0, n);
        }
        arrayList.add("");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void recordClassDefine(String string, Class<?> clazz, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
    }

    @Override
    public String findLibrary(BaseData baseData, String string) {
        String string2;
        String string3;
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(0) == '/' || string.charAt(0) == '\\') {
            string = string.substring(1);
        }
        if ((string3 = this.searchVariants(baseData, string2 = System.mapLibraryName(string))) != null) {
            return string3;
        }
        String[] stringArray = BaseClassLoadingHook.mapLibraryNames(string2);
        int n = 0;
        while (n < stringArray.length && string3 == null) {
            string3 = this.searchVariants(baseData, stringArray[n]);
            ++n;
        }
        return string3;
    }

    private String searchVariants(BaseData baseData, String string) {
        int n = 0;
        while (n < LIB_VARIANTS.length) {
            BundleFile bundleFile = baseData.getBundleFile();
            BundleEntry bundleEntry = bundleFile.getEntry(new StringBuffer(String.valueOf(LIB_VARIANTS[n])).append(string).toString());
            if (bundleEntry != null) {
                File file = bundleFile.getFile(new StringBuffer(String.valueOf(LIB_VARIANTS[n])).append(string).toString(), true);
                if (file == null) {
                    return null;
                }
                if ("hpux".equals(EclipseEnvironmentInfo.getDefault().getOS())) {
                    try {
                        Runtime.getRuntime().exec(new String[]{"chmod", "755", file.getAbsolutePath()}).waitFor();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return file.getAbsolutePath();
            }
            ++n;
        }
        return null;
    }

    @Override
    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    @Override
    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addClassLoadingHook(this);
    }

    @Override
    public BaseClassLoader createClassLoader(ClassLoader classLoader, ClassLoaderDelegate classLoaderDelegate, BundleProtectionDomain bundleProtectionDomain, BaseData baseData, String[] stringArray) {
        return null;
    }

    @Override
    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData baseData) {
    }
}

