/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.LocationHelper;
import org.eclipse.core.runtime.internal.adaptor.Locker;
import org.eclipse.core.runtime.internal.adaptor.Locker_JavaIo;
import org.eclipse.core.runtime.internal.adaptor.Locker_JavaNio;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public class BasicLocation
implements Location {
    private final boolean isReadOnly;
    private URL location = null;
    private Location parent;
    private final URL defaultValue;
    private final String property;
    private final String dataAreaPrefix;
    private File lockFile;
    private Locker locker;
    public static final String PROP_OSGI_LOCKING = "osgi.locking";
    private static String DEFAULT_LOCK_FILENAME = ".metadata/.lock";
    public static boolean DEBUG;

    private static boolean isRunningWithNio() {
        try {
            Class.forName("java.nio.channels.FileLock");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public static Locker createLocker(File file, String string) {
        if (string == null) {
            string = FrameworkProperties.getProperty(PROP_OSGI_LOCKING);
        }
        if ("none".equals(string)) {
            return new MockLocker();
        }
        if ("java.io".equals(string)) {
            return new Locker_JavaIo(file);
        }
        if ("java.nio".equals(string)) {
            if (BasicLocation.isRunningWithNio()) {
                return new Locker_JavaNio(file);
            }
            return new Locker_JavaIo(file);
        }
        if (BasicLocation.isRunningWithNio()) {
            return new Locker_JavaNio(file);
        }
        return new Locker_JavaIo(file);
    }

    public BasicLocation(String string, URL uRL, boolean bl, String string2) {
        this.property = string;
        this.defaultValue = uRL;
        this.isReadOnly = bl;
        this.dataAreaPrefix = string2 == null ? "" : string2;
    }

    public boolean allowsDefault() {
        return this.defaultValue != null;
    }

    public URL getDefault() {
        return this.defaultValue;
    }

    public synchronized Location getParentLocation() {
        return this.parent;
    }

    public synchronized URL getURL() {
        if (this.location == null && this.defaultValue != null) {
            this.setURL(this.defaultValue, false);
        }
        return this.location;
    }

    public synchronized boolean isSet() {
        return this.location != null;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean setURL(URL uRL, boolean bl) throws IllegalStateException {
        try {
            return this.set(uRL, bl);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public synchronized boolean set(URL uRL, boolean bl) throws IllegalStateException, IOException {
        return this.set(uRL, bl, null);
    }

    public synchronized boolean set(URL uRL, boolean bl, String string) throws IllegalStateException, IOException {
        if (this.location != null) {
            throw new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_CANNOT_CHANGE_LOCATION);
        }
        Object object = null;
        if (uRL.getProtocol().equalsIgnoreCase("file")) {
            Object object2;
            try {
                object2 = new File(uRL.getFile()).getCanonicalPath();
                uRL = LocationHelper.buildURL("file:" + (String)object2, true);
            }
            catch (IOException iOException) {}
            object = string != null && string.length() > 0 ? (((File)(object2 = new File(string))).isAbsolute() ? object2 : new File(uRL.getFile(), string)) : new File(uRL.getFile(), DEFAULT_LOCK_FILENAME);
        }
        boolean bl2 = bl = bl && !this.isReadOnly;
        if (bl && !this.lock((File)object, uRL)) {
            return false;
        }
        this.lockFile = object;
        this.location = uRL;
        if (this.property != null) {
            FrameworkProperties.setProperty(this.property, this.location.toExternalForm());
        }
        return bl;
    }

    public synchronized void setParent(Location location) {
        this.parent = location;
    }

    public synchronized boolean lock() throws IOException {
        if (!this.isSet()) {
            throw new IOException(EclipseAdaptorMsg.location_notSet);
        }
        return this.lock(this.lockFile, this.location);
    }

    public synchronized boolean isLocked() throws IOException {
        if (!this.isSet()) {
            return false;
        }
        return this.isLocked(this.lockFile);
    }

    private boolean lock(File file, URL uRL) throws IOException {
        if (this.isReadOnly) {
            throw new IOException(NLS.bind(EclipseAdaptorMsg.location_folderReadOnly, file));
        }
        if (file == null) {
            if (uRL != null && !"file".equalsIgnoreCase(uRL.getProtocol())) {
                throw new IOException(NLS.bind(EclipseAdaptorMsg.location_notFileProtocol, uRL));
            }
            throw new IllegalStateException(EclipseAdaptorMsg.location_noLockFile);
        }
        if (this.isLocked()) {
            return false;
        }
        File file2 = new File(file.getParent());
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException(NLS.bind(EclipseAdaptorMsg.location_folderReadOnly, file2));
        }
        this.setLocker(file);
        if (this.locker == null) {
            return true;
        }
        boolean bl = false;
        try {
            boolean bl2 = bl = this.locker.lock();
            return bl2;
        }
        finally {
            if (!bl) {
                this.locker = null;
            }
        }
    }

    private boolean isLocked(File file) throws IOException {
        if (file == null || this.isReadOnly) {
            return true;
        }
        if (!file.exists()) {
            return false;
        }
        this.setLocker(file);
        return this.locker.isLocked();
    }

    private void setLocker(File file) {
        if (this.locker != null) {
            return;
        }
        String string = FrameworkProperties.getProperty(PROP_OSGI_LOCKING);
        this.locker = BasicLocation.createLocker(file, string);
    }

    public synchronized void release() {
        if (this.locker != null) {
            this.locker.release();
        }
    }

    public Location createLocation(Location location, URL uRL, boolean bl) {
        BasicLocation basicLocation = new BasicLocation(null, uRL, bl, this.dataAreaPrefix);
        basicLocation.setParent(location);
        return basicLocation;
    }

    public URL getDataArea(String string) throws IOException {
        URL uRL = this.getURL();
        if (uRL == null) {
            throw new IOException(EclipseAdaptorMsg.location_notSet);
        }
        String string2 = uRL.toExternalForm();
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) != '/') {
            string2 = String.valueOf(string2) + '/';
        }
        if ((string = string.replace('\\', '/')).length() > 0 && string.charAt(0) == '/') {
            string.substring(1);
        }
        return new URL(String.valueOf(string2) + this.dataAreaPrefix + string);
    }

    static class MockLocker
    implements Locker {
        MockLocker() {
        }

        public boolean lock() throws IOException {
            return true;
        }

        public boolean isLocked() {
            return false;
        }

        public void release() {
        }
    }
}

